/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.HashMap;
import java.util.Map;

public enum RelOp {
    GT,
    GEQ,
    MIN,
    LEQ,
    LT,
    MAX,
    EQ;

    protected static Map<RelOp, String> symbols;

    public String toString() {
        return symbols.get((Object)this);
    }

    public boolean isLowerBound() {
        switch (this) {
            case GT: 
            case GEQ: {
                return true;
            }
        }
        return false;
    }

    public boolean isUpperBound() {
        switch (this) {
            case LT: 
            case LEQ: {
                return true;
            }
        }
        return false;
    }

    public boolean isStrict() {
        switch (this) {
            case GT: 
            case LT: {
                return true;
            }
        }
        return false;
    }

    public boolean isMin() {
        switch (this) {
            case MIN: {
                return true;
            }
        }
        return false;
    }

    public boolean isMax() {
        switch (this) {
            case MAX: {
                return true;
            }
        }
        return false;
    }

    public static RelOp parseSymbol(String string) {
        for (Map.Entry<RelOp, String> entry : symbols.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        symbols = new HashMap<RelOp, String>();
        symbols.put(GT, ">");
        symbols.put(GEQ, ">=");
        symbols.put(MIN, "min=");
        symbols.put(LT, "<");
        symbols.put(LEQ, "<=");
        symbols.put(MAX, "max=");
        symbols.put(EQ, "=");
    }
}

