/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import param.BigRational;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class Property
extends ASTElement {
    private Expression expr;
    private String name;
    private String comment;

    public Property(Expression expression) {
        this(expression, null, null);
    }

    public Property(Expression expression, String string) {
        this(expression, string, null);
    }

    public Property(Expression expression, String string, String string2) {
        this.expr = expression;
        this.name = string;
        this.comment = string2;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean checkAgainstExpectedResult(Object object) throws PrismException {
        return this.checkAgainstExpectedResult(object, null);
    }

    public boolean checkAgainstExpectedResult(Object object, Values values) throws PrismException {
        String string = this.getExpectedResultString(values);
        return this.checkAgainstExpectedResultString(string, object);
    }

    private String getExpectedResultString(Values values) throws PrismException {
        String string = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String[] stringArray;
                String string2 = matcher.group(2) == null ? "" : matcher.group(2);
                boolean bl = true;
                for (String string3 : stringArray = string2.split(",")) {
                    boolean bl2 = true;
                    if ((string3 = string3.trim()).length() == 0) continue;
                    String[] stringArray2 = string3.split("=");
                    if (stringArray2.length != 2) {
                        throw new PrismException("Badly formed RESULT specification \"" + matcher.group() + "\"");
                    }
                    String string4 = stringArray2[0].trim();
                    String string5 = stringArray2[1].trim();
                    Object object = values.getValueOf(string4);
                    bl2 = object == null ? false : (object instanceof Double ? PrismUtils.doublesAreCloseRel((Double)object, Double.parseDouble(string5), 1.0E-10) : object.toString().equals(string5));
                    bl &= bl2;
                }
                if (!bl) continue;
                string = matcher.group(3);
            }
        }
        if (string == null) {
            throw new PrismException("Did not find a RESULT specification (for " + values + ") to test against");
        }
        return string;
    }

    private String getExpectedResultString(String string) throws PrismException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String string3;
                String string4 = matcher.group(2) == null ? "" : matcher.group(2);
                if (hashMap.put(string4, string3 = matcher.group(3)) == null) continue;
                if (string4.length() == 0) {
                    throw new PrismException("Multiple RESULT specificiations for test");
                }
                throw new PrismException("Multiple RESULT (" + string4 + ") specificiations for test");
            }
        }
        if (hashMap.size() == 0) {
            throw new PrismException("Did not find any RESULT specifications to test against");
        }
        string2 = (String)hashMap.get(string);
        if (string2 == null) {
            throw new PrismException("Did not find a RESULT specification (for " + string + ") to test against");
        }
        return string2;
    }

    private boolean checkAgainstExpectedResultString(String string, Object object) throws PrismException {
        if (string.equals("?")) {
            return false;
        }
        if (object instanceof PrismNotSupportedException) {
            throw (PrismNotSupportedException)object;
        }
        if (object instanceof Exception) {
            String string2 = ((Exception)object).getMessage();
            if (string.startsWith("Error")) {
                if (string.startsWith("Error:")) {
                    String[] stringArray;
                    for (String string3 : stringArray = string.substring(6).split(",")) {
                        if (string3.length() == 0) {
                            throw new PrismException("Invalid RESULT specification: no expected words immediately following 'Error:'");
                        }
                        if (string2.toLowerCase().contains(string3)) continue;
                        throw new PrismException("Error message should contain \"" + string3 + "\"");
                    }
                }
                return true;
            }
            throw new PrismException("Unexpected error: " + string2);
        }
        if (string.startsWith("Error")) {
            throw new PrismException("Was expecting an error");
        }
        Type type = this.expr.getType();
        if (type instanceof TypeBool) {
            boolean bl;
            if ((string = string.toLowerCase()).equals("true")) {
                bl = true;
            } else if (string.equals("false")) {
                bl = false;
            } else {
                throw new PrismException("Invalid RESULT specification \"" + string + "\" for boolean-valued property");
            }
            if (!(object instanceof Boolean)) {
                throw new PrismException("Result is wrong type for (boolean-valued) property");
            }
            boolean bl2 = (Boolean)object;
            if (bl2 != bl) {
                throw new PrismException("Wrong result (expected " + bl + ", got " + bl2 + ")");
            }
        } else if (type instanceof TypeInt) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid RESULT specification \"" + string + "\" for integer-valued property");
            }
            if (!(object instanceof Integer)) {
                throw new PrismException("Result is wrong type for (integer-valued) property");
            }
            int n2 = (Integer)object;
            if (n2 != n) {
                throw new PrismException("Wrong result (expected " + n + ", got " + n2 + ")");
            }
        } else if (type instanceof TypeDouble && !(object instanceof BigRational)) {
            double d;
            try {
                if (string.equals("NaN")) {
                    d = Double.NaN;
                } else if (string.matches("[0-9]+/[0-9]+")) {
                    int n = Integer.parseInt(string.substring(0, string.indexOf(47)));
                    int n3 = Integer.parseInt(string.substring(string.indexOf(47) + 1));
                    d = (double)n / (double)n3;
                } else {
                    d = Double.parseDouble(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid RESULT specification \"" + string + "\" for double-valued property");
            }
            if (!(object instanceof Double)) {
                throw new PrismException("Result is wrong type for (double-valued) property");
            }
            double d2 = (Double)object;
            if (Double.isNaN(d2)) {
                if (!Double.isNaN(d)) {
                    throw new PrismException("Wrong result (expected " + d + ", got NaN)");
                }
            } else if (!PrismUtils.doublesAreCloseRel(d, d2, 1.0E-5)) {
                throw new PrismException("Wrong result (expected " + d + ", got " + d2 + ")");
            }
        } else if (type instanceof TypeDouble && object instanceof BigRational) {
            BigRational bigRational = (BigRational)object;
            BigRational bigRational2 = null;
            try {
                if (string.equals("NaN")) {
                    if (!bigRational.isNaN()) {
                        throw new PrismException("Wrong result (expected NaN, got " + bigRational + ")");
                    }
                } else {
                    bigRational2 = new BigRational(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid RESULT specification \"" + string + "\" for rational-valued property");
            }
            if (!bigRational.equals(bigRational2)) {
                throw new PrismException("Wrong result (expected " + bigRational2 + ", got " + bigRational + ")");
            }
        } else {
            throw new PrismException("Don't know how to test properties of type " + type);
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        if (this.name != null) {
            string = string + "\"" + this.name + "\": ";
        }
        string = string + this.expr;
        return string;
    }

    @Override
    public Property deepCopy() {
        Property property = new Property(this.expr, this.name, this.comment);
        property.setType(this.type);
        property.setPosition(this);
        return property;
    }
}

