/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.List;
import java.util.Vector;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.Property;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class PropertiesFile
extends ASTElement {
    private ModulesFile modulesFile;
    private FormulaList formulaList;
    private LabelList labelList;
    private LabelList combinedLabelList;
    private ConstantList constantList;
    private Vector<Property> properties;
    private Vector<String> allIdentsUsed;
    private Values constantValues;

    public PropertiesFile(ModulesFile modulesFile) {
        this.setModulesFile(modulesFile);
        this.formulaList = new FormulaList();
        this.labelList = new LabelList();
        this.combinedLabelList = new LabelList();
        this.constantList = new ConstantList();
        this.properties = new Vector();
        this.allIdentsUsed = new Vector();
        this.constantValues = null;
    }

    public void setModulesFile(ModulesFile modulesFile) {
        this.modulesFile = modulesFile;
    }

    public void setFormulaList(FormulaList formulaList) {
        this.formulaList = formulaList;
    }

    public void setLabelList(LabelList labelList) {
        this.labelList = labelList;
    }

    public void setConstantList(ConstantList constantList) {
        this.constantList = constantList;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addProperty(Expression expression, String string) {
        this.properties.addElement(new Property(expression, null, string));
    }

    public void setPropertyObject(int n, Property property) {
        this.properties.set(n, property);
    }

    public void setPropertyExpression(int n, Expression expression) {
        this.properties.get(n).setExpression(expression);
    }

    public void insertPropertiesFile(PropertiesFile propertiesFile) throws PrismLangException {
        int n;
        FormulaList formulaList = propertiesFile.formulaList;
        int n2 = formulaList.size();
        for (n = 0; n < n2; ++n) {
            this.formulaList.addFormula(formulaList.getFormulaNameIdent(n), formulaList.getFormula(n));
        }
        LabelList labelList = propertiesFile.labelList;
        n2 = labelList.size();
        for (n = 0; n < n2; ++n) {
            this.labelList.addLabel(labelList.getLabelNameIdent(n), labelList.getLabel(n));
        }
        ConstantList constantList = propertiesFile.constantList;
        n2 = constantList.size();
        for (n = 0; n < n2; ++n) {
            this.constantList.addConstant(constantList.getConstantNameIdent(n), constantList.getConstant(n), constantList.getConstantType(n));
        }
        n2 = propertiesFile.properties.size();
        for (n = 0; n < n2; ++n) {
            this.properties.add(propertiesFile.properties.get(n));
        }
        this.tidyUp();
    }

    public FormulaList getFormulaList() {
        return this.formulaList;
    }

    public LabelList getLabelList() {
        return this.labelList;
    }

    public LabelList getCombinedLabelList() {
        return this.combinedLabelList;
    }

    public ConstantList getConstantList() {
        return this.constantList;
    }

    public int getNumProperties() {
        return this.properties.size();
    }

    public Property getPropertyObject(int n) {
        return this.properties.get(n);
    }

    public Expression getProperty(int n) {
        return this.properties.get(n).getExpression();
    }

    public String getPropertyName(int n) {
        return this.properties.get(n).getName();
    }

    public String getPropertyComment(int n) {
        return this.properties.get(n).getComment();
    }

    public Property getPropertyObjectByName(String string) {
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.getPropertyName(i))) continue;
            return this.getPropertyObject(i);
        }
        return null;
    }

    public int getPropertyIndexByName(String string) {
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    public Property lookUpPropertyObjectByName(String string) {
        return this.getPropertyObjectByName(string);
    }

    public boolean isIdentUsed(String string) {
        return this.allIdentsUsed.contains(string);
    }

    public void tidyUp() throws PrismLangException {
        this.allIdentsUsed.clear();
        this.checkFormulaIdents();
        this.findAllFormulas(this.modulesFile.getFormulaList());
        this.findAllFormulas(this.formulaList);
        this.formulaList.findCycles();
        this.expandFormulas(this.modulesFile.getFormulaList(), false);
        this.expandFormulas(this.formulaList, false);
        this.checkLabelIdents();
        this.checkConstantIdents();
        this.findAllConstants(this.modulesFile.getConstantList());
        this.findAllConstants(this.constantList);
        this.constantList.findCycles();
        this.checkPropertyNames();
        this.findAllVars(this.modulesFile.getVarNames(), this.modulesFile.getVarTypes());
        this.findAllPropRefs(null, this);
        this.findCyclesInPropertyReferences();
        this.semanticCheck(this.modulesFile, this);
        this.typeCheck(this);
        this.setSomeUndefinedConstants(null);
    }

    private void checkFormulaIdents() throws PrismLangException {
        int n = this.formulaList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.formulaList.getFormulaName(i);
            if (this.modulesFile.isIdentUsed(string)) {
                throw new PrismLangException("Identifier \"" + string + "\" already used in model file", this.formulaList.getFormulaNameIdent(i));
            }
            if (this.isIdentUsed(string)) {
                throw new PrismLangException("Duplicated identifier \"" + string + "\"", this.formulaList.getFormulaNameIdent(i));
            }
            this.allIdentsUsed.add(string);
        }
    }

    private void checkLabelIdents() throws PrismLangException {
        int n;
        LabelList labelList = this.modulesFile.getLabelList();
        int n2 = labelList.size();
        for (n = 0; n < n2; ++n) {
            this.combinedLabelList.addLabel(labelList.getLabelNameIdent(n), labelList.getLabel(n).deepCopy());
        }
        n2 = this.labelList.size();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            String string = this.labelList.getLabelName(n);
            if (labelList.getLabelIndex(string) != -1) {
                throw new PrismLangException("Label \"" + string + "\" already defined in model file", this.labelList.getLabelNameIdent(n));
            }
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated label name \"" + string + "\"", this.labelList.getLabelNameIdent(n));
            }
            vector.addElement(string);
            this.combinedLabelList.addLabel(this.labelList.getLabelNameIdent(n), this.labelList.getLabel(n));
        }
    }

    private void checkConstantIdents() throws PrismLangException {
        int n = this.constantList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.constantList.getConstantName(i);
            if (this.modulesFile.isIdentUsed(string)) {
                throw new PrismLangException("Identifier \"" + string + "\" already used in model file", this.constantList.getConstantNameIdent(i));
            }
            if (this.isIdentUsed(string)) {
                throw new PrismLangException("Duplicated identifier \"" + string + "\"", this.constantList.getConstantNameIdent(i));
            }
            this.allIdentsUsed.add(string);
        }
    }

    private void checkPropertyNames() throws PrismLangException {
        LabelList labelList = this.modulesFile.getLabelList();
        int n = this.properties.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.properties.get(i).getName();
            if (string == null) continue;
            if (labelList.getLabelIndex(string) != -1) {
                throw new PrismLangException("Property name \"" + string + "\" clashes with label in model file", this.getPropertyObject(i));
            }
            if (this.labelList.getLabelIndex(string) != -1) {
                throw new PrismLangException("Property name \"" + string + "\" clashes with label", this.getPropertyObject(i));
            }
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated property name \"" + string + "\"", this.getPropertyObject(i));
            }
            vector.addElement(string);
        }
    }

    public void findCyclesInPropertyReferences() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.properties.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.properties.get(n).getExpression();
            Vector<String> vector = ((ASTElement)object).getAllPropRefs();
            for (int i = 0; i < vector.size(); ++i) {
                int n3 = this.getPropertyIndexByName(vector.elementAt(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in property references from property \"" + this.getPropertyName(n) + "\"";
            throw new PrismLangException((String)object, this.getPropertyObject(n));
        }
    }

    public Vector<String> getUndefinedConstants() {
        return this.constantList.getUndefinedConstants();
    }

    public Vector<String> getUndefinedConstantsUsedInLabels() {
        Vector<String> vector = new Vector<String>();
        int n = this.labelList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.labelList.getLabel(i);
            Vector<String> vector2 = expression.getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, null);
            for (String string : vector2) {
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        return vector;
    }

    public Vector<String> getUndefinedConstantsUsedInProperty(Property property) {
        return property.getExpression().getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, this);
    }

    public Vector<String> getUndefinedConstantsUsedInProperties(List<Property> list) {
        Vector<String> vector = new Vector<String>();
        for (Property property : list) {
            Vector<String> vector2 = property.getExpression().getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, this);
            for (String string : vector2) {
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        return vector;
    }

    public void setUndefinedConstants(Values values) throws PrismLangException {
        this.constantValues = this.constantList.evaluateConstants(values, this.modulesFile.getConstantValues());
    }

    public void setSomeUndefinedConstants(Values values) throws PrismLangException {
        this.constantValues = this.constantList.evaluateSomeConstants(values, this.modulesFile.getConstantValues());
    }

    public boolean isDefinedConstant(String string) {
        return this.constantList.isDefinedConstant(string);
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        String string2 = "" + this.formulaList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        string2 = "" + this.labelList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        string2 = "" + this.constantList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            string = string + this.getPropertyObject(i) + ";\n";
            if (i >= n - 1) continue;
            string = string + "\n";
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        PropertiesFile propertiesFile = new PropertiesFile(this.modulesFile);
        propertiesFile.setPosition(this);
        propertiesFile.setFormulaList((FormulaList)this.formulaList.deepCopy());
        propertiesFile.setLabelList((LabelList)this.labelList.deepCopy());
        propertiesFile.combinedLabelList = (LabelList)this.combinedLabelList.deepCopy();
        propertiesFile.setConstantList((ConstantList)this.constantList.deepCopy());
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            propertiesFile.addProperty(this.getPropertyObject(i).deepCopy());
        }
        propertiesFile.allIdentsUsed = this.allIdentsUsed == null ? null : (Vector)this.allIdentsUsed.clone();
        propertiesFile.constantValues = this.constantValues == null ? null : new Values(this.constantValues);
        return propertiesFile;
    }
}

