/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.Expression;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.Property;
import parser.ast.RenamedModule;
import parser.ast.RewardStruct;
import parser.ast.SystemDefn;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.ModelType;
import prism.PrismLangException;
import prism.PrismUtils;

public class ModulesFile
extends ASTElement {
    private ModelType modelType;
    private FormulaList formulaList = new FormulaList();
    private LabelList labelList = new LabelList();
    private ConstantList constantList = new ConstantList();
    private Vector<Declaration> globals;
    private Vector<Object> modules;
    private ArrayList<SystemDefn> systemDefns;
    private ArrayList<String> systemDefnNames;
    private ArrayList<RewardStruct> rewardStructs;
    private Expression initStates = null;
    private Vector<String> formulaIdents;
    private Vector<String> constantIdents;
    private Vector<String> varIdents;
    private String[] moduleNames;
    private Vector<String> synchs;
    private Vector<Declaration> varDecls;
    private Vector<String> varNames;
    private Vector<Type> varTypes;
    private Values undefinedConstantValues = null;
    private Values constantValues = null;

    public ModulesFile() {
        this.modelType = ModelType.MDP;
        this.globals = new Vector();
        this.modules = new Vector();
        this.systemDefns = new ArrayList();
        this.systemDefnNames = new ArrayList();
        this.rewardStructs = new ArrayList();
        this.formulaIdents = new Vector();
        this.constantIdents = new Vector();
        this.varIdents = new Vector();
        this.varDecls = new Vector();
        this.varNames = new Vector();
        this.varTypes = new Vector();
    }

    public void setFormulaList(FormulaList formulaList) {
        this.formulaList = formulaList;
    }

    public void setLabelList(LabelList labelList) {
        this.labelList = labelList;
    }

    public void setConstantList(ConstantList constantList) {
        this.constantList = constantList;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void addGlobal(Declaration declaration) {
        this.globals.add(declaration);
    }

    public void setGlobal(int n, Declaration declaration) {
        this.globals.set(n, declaration);
    }

    public void addModule(Module module) {
        this.modules.add(module);
        module.setParent(this);
    }

    public void setModule(int n, Module module) {
        this.modules.set(n, module);
        module.setParent(this);
    }

    public void addRenamedModule(RenamedModule renamedModule) {
        this.modules.add(renamedModule);
    }

    public void setSystemDefn(SystemDefn systemDefn) {
        this.clearSystemDefns();
        this.addSystemDefn(systemDefn);
    }

    public void clearSystemDefns() {
        this.systemDefns.clear();
        this.systemDefnNames.clear();
    }

    public void addSystemDefn(SystemDefn systemDefn) {
        this.addSystemDefn(systemDefn, null);
    }

    public void addSystemDefn(SystemDefn systemDefn, String string) {
        this.systemDefns.add(systemDefn);
        this.systemDefnNames.add(string);
    }

    public void setSystemDefn(int n, SystemDefn systemDefn, String string) {
        this.systemDefns.set(n, systemDefn);
        this.systemDefnNames.set(n, string);
    }

    public void clearRewardStructs() {
        this.rewardStructs.clear();
    }

    public void addRewardStruct(RewardStruct rewardStruct) {
        this.rewardStructs.add(rewardStruct);
    }

    public void setRewardStruct(int n, RewardStruct rewardStruct) {
        this.rewardStructs.set(n, rewardStruct);
    }

    public void setRewardStruct(RewardStruct rewardStruct) {
        this.rewardStructs.clear();
        this.rewardStructs.add(rewardStruct);
    }

    public void setInitialStates(Expression expression) {
        this.initStates = expression;
    }

    public FormulaList getFormulaList() {
        return this.formulaList;
    }

    public LabelList getLabelList() {
        return this.labelList;
    }

    public ConstantList getConstantList() {
        return this.constantList;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getTypeString() {
        return "" + (Object)((Object)this.modelType);
    }

    public String getTypeFullString() {
        return this.modelType.fullName();
    }

    public int getNumGlobals() {
        return this.globals.size();
    }

    public Declaration getGlobal(int n) {
        return this.globals.elementAt(n);
    }

    public int getNumModules() {
        return this.modules.size();
    }

    public Module getModule(int n) {
        Object object = this.modules.elementAt(n);
        return object instanceof Module ? (Module)object : null;
    }

    public int getModuleIndex(String string) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module module = this.getModule(i);
            if (module == null || !string.equals(module.getName())) continue;
            return i;
        }
        return -1;
    }

    public SystemDefn getSystemDefn() {
        int n = this.systemDefns.size();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (this.systemDefnNames.get(i) != null) continue;
            return this.systemDefns.get(i);
        }
        return this.systemDefns.get(0);
    }

    public int getNumSystemDefns() {
        return this.systemDefns.size();
    }

    public SystemDefn getSystemDefn(int n) {
        return this.systemDefns.get(n);
    }

    public String getSystemDefnName(int n) {
        return this.systemDefnNames.get(n);
    }

    public int getSystemDefnIndex(String string) {
        int n = this.systemDefns.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.systemDefnNames.get(i);
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return i;
        }
        return -1;
    }

    public SystemDefn getSystemDefnByName(String string) {
        int n = this.getSystemDefnIndex(string);
        return n == -1 ? null : this.getSystemDefn(n);
    }

    public int getNumRewardStructs() {
        return this.rewardStructs.size();
    }

    public RewardStruct getRewardStruct(int n) {
        return n < this.rewardStructs.size() ? this.rewardStructs.get(n) : null;
    }

    public List<RewardStruct> getRewardStructs() {
        return this.rewardStructs;
    }

    public int getRewardStructIndex(String string) {
        int n = this.rewardStructs.size();
        for (int i = 0; i < n; ++i) {
            if (!this.rewardStructs.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public RewardStruct getRewardStructByName(String string) {
        int n = this.getRewardStructIndex(string);
        return n == -1 ? null : this.getRewardStruct(n);
    }

    public RewardStruct getRewardStruct() {
        return this.getRewardStruct(0);
    }

    public Expression getInitialStates() {
        return this.initStates;
    }

    public Property getPropertyByName(String string) {
        return null;
    }

    public boolean isIdentUsed(String string) {
        return this.formulaIdents.contains(string) || this.constantIdents.contains(string) || this.varIdents.contains(string);
    }

    public String getModuleName(int n) {
        return this.moduleNames[n];
    }

    public String[] getModuleNames() {
        return this.moduleNames;
    }

    public Vector<String> getSynchs() {
        return this.synchs;
    }

    public String getSynch(int n) {
        return this.synchs.get(n);
    }

    public boolean isSynch(String string) {
        if (this.synchs == null) {
            return false;
        }
        return this.synchs.contains(string);
    }

    public int getNumVars() {
        return this.varNames.size();
    }

    public int getVarIndex(String string) {
        return this.varNames.indexOf(string);
    }

    public Declaration getVarDeclaration(int n) {
        return this.varDecls.get(n);
    }

    public String getVarName(int n) {
        return this.varNames.get(n);
    }

    public Type getVarType(int n) {
        return this.varTypes.get(n);
    }

    public Vector<String> getVarNames() {
        return this.varNames;
    }

    public Vector<Type> getVarTypes() {
        return this.varTypes;
    }

    public boolean isGlobalVariable(String string) {
        int n = this.getNumGlobals();
        for (int i = 0; i < n; ++i) {
            if (!this.getGlobal(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void tidyUp() throws PrismLangException {
        this.formulaIdents.clear();
        this.constantIdents.clear();
        this.varIdents.clear();
        this.varDecls.clear();
        this.varNames.clear();
        this.varTypes.clear();
        this.checkFormulaIdents();
        this.findAllFormulas(this.formulaList);
        this.formulaList.findCycles();
        this.expandFormulas(this.formulaList);
        this.sortRenamings();
        this.checkLabelIdents();
        this.checkModuleNames();
        this.checkConstantIdents();
        this.findAllConstants(this.constantList);
        this.constantList.findCycles();
        this.checkVarNames();
        this.findAllVars(this.varNames, this.varTypes);
        this.findAllPropRefs(this, null);
        this.checkRewardStructNames();
        this.checkSystemDefns();
        this.getSynchNames();
        this.findAllActions(this.synchs);
        this.semanticCheck(this);
        this.typeCheck();
        if (this.getUndefinedConstants().isEmpty()) {
            this.setUndefinedConstants(null);
        }
    }

    private void checkFormulaIdents() throws PrismLangException {
        int n = this.formulaList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.formulaList.getFormulaName(i);
            if (this.isIdentUsed(string)) {
                throw new PrismLangException("Duplicated identifier \"" + string + "\"", this.formulaList.getFormulaNameIdent(i));
            }
            this.formulaIdents.add(string);
        }
    }

    private void sortRenamings() throws PrismLangException {
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object = this.modules.elementAt(i);
            if (object instanceof Module) continue;
            RenamedModule renamedModule = (RenamedModule)object;
            int n2 = this.getModuleIndex(renamedModule.getBaseModule());
            if (n2 == -1) {
                string = "No such module " + renamedModule.getBaseModule();
                string = string + " in renamed module \"" + renamedModule.getName() + "\"";
                throw new PrismLangException(string, renamedModule.getBaseModuleASTElement());
            }
            int n3 = renamedModule.getNumRenames();
            HashSet<String> hashSet = new HashSet<String>();
            for (int j = 0; j < n3; ++j) {
                string = renamedModule.getOldName(j);
                if (!hashSet.add(string)) {
                    throw new PrismLangException("Identifier \"" + string + "\" is renamed more than once in module \"" + renamedModule.getName() + "\"", renamedModule.getOldNameASTElement(j));
                }
                if (this.formulaList.getFormulaIndex(string) == -1) continue;
                throw new PrismLangException("Formula \"" + string + "\" cannot be renamed since formulas are expanded before module renaming", renamedModule.getOldNameASTElement(j));
            }
            Module module = (Module)this.getModule(n2).deepCopy().rename(renamedModule);
            module.setNameASTElement(renamedModule.getNameASTElement());
            module.setBaseModule(renamedModule.getBaseModule());
            this.setModule(i, module);
        }
    }

    private void checkLabelIdents() throws PrismLangException {
        int n = this.labelList.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.labelList.getLabelName(i);
            if (vector.contains(string)) {
                throw new PrismLangException("Duplicated label name \"" + string + "\"", this.labelList.getLabelNameIdent(i));
            }
            vector.add(string);
        }
    }

    private void checkModuleNames() throws PrismLangException {
        int n = this.modules.size();
        if (n == 0) {
            throw new PrismLangException("There must be at least one module");
        }
        this.moduleNames = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = this.getModule(i).getName();
            for (int j = 0; j < i; ++j) {
                if (!string.equals(this.moduleNames[j])) continue;
                throw new PrismLangException("Duplicated module name \"" + string + "\"", this.getModule(i).getNameASTElement());
            }
            this.moduleNames[i] = string;
        }
    }

    private void getSynchNames() throws PrismLangException {
        this.synchs = new Vector();
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            Vector<String> vector = this.getModule(i).getAllSynchs();
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                String string = vector.elementAt(j);
                if (this.synchs.contains(string)) continue;
                this.synchs.add(string);
            }
        }
        SystemDefn systemDefn = this.getSystemDefn();
        if (systemDefn != null) {
            systemDefn.getSynchs(this.synchs, this);
        }
    }

    private void checkConstantIdents() throws PrismLangException {
        int n = this.constantList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.constantList.getConstantName(i);
            if (this.isIdentUsed(string)) {
                throw new PrismLangException("Duplicated identifier \"" + string + "\"", this.constantList.getConstantNameIdent(i));
            }
            this.constantIdents.add(string);
        }
    }

    private void checkVarNames() throws PrismLangException {
        String string;
        int n;
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            string = this.getGlobal(n).getName();
            if (this.isIdentUsed(string)) {
                throw new PrismLangException("Duplicated identifier \"" + string + "\"", this.getGlobal(n));
            }
            this.varIdents.add(string);
            this.varDecls.add(this.getGlobal(n));
            this.varNames.add(string);
            this.varTypes.add(this.getGlobal(n).getType());
        }
        n2 = this.modules.size();
        for (n = 0; n < n2; ++n) {
            Module module = this.getModule(n);
            int n3 = module.getNumDeclarations();
            for (int i = 0; i < n3; ++i) {
                string = module.getDeclaration(i).getName();
                if (this.isIdentUsed(string)) {
                    throw new PrismLangException("Duplicated identifier \"" + string + "\"", module.getDeclaration(i));
                }
                this.varIdents.add(string);
                this.varDecls.add(module.getDeclaration(i));
                this.varNames.add(string);
                this.varTypes.add(module.getDeclaration(i).getType());
            }
        }
        if (this.varNames.size() == 0) {
            throw new PrismLangException("There must be at least one variable");
        }
    }

    private void checkRewardStructNames() throws PrismLangException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            String string = this.getRewardStruct(i).getName();
            if (string == null || "".equals(string) || hashSet.add(string)) continue;
            throw new PrismLangException("Duplicated reward structure name \"" + string + "\"", this.getRewardStruct(i));
        }
    }

    private void checkSystemDefns() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.systemDefns.size();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n2; ++i) {
            String string = this.systemDefnNames.get(i);
            if (string == null) {
                ++n3;
            } else if (!hashSet.add(string)) {
                throw new PrismLangException("Duplicated system...endystem name \"" + string + "\"", this.getSystemDefn(i));
            }
            if (n3 <= 1) continue;
            throw new PrismLangException("There can be at most one un-named system...endsystem construct", this.getSystemDefn(i));
        }
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.systemDefns.get(n);
            Vector<String> vector = new Vector<String>();
            ((SystemDefn)object).getReferences(vector);
            for (int i = 0; i < vector.size(); ++i) {
                int n4 = this.getSystemDefnIndex(vector.elementAt(i));
                if (n4 == -1) continue;
                blArray[n][n4] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency from references in system...endsystem definition \"" + this.getSystemDefnName(n) + "\"";
            throw new PrismLangException((String)object, this.getSystemDefn(n));
        }
    }

    public Vector<String> getUndefinedConstants() {
        return this.constantList.getUndefinedConstants();
    }

    public void setUndefinedConstants(Values values) throws PrismLangException {
        this.undefinedConstantValues = values == null ? null : new Values(values);
        this.constantValues = this.constantList.evaluateConstants(values, null);
        this.semanticCheckAfterConstants(this, null);
    }

    public void setSomeUndefinedConstants(Values values) throws PrismLangException {
        this.undefinedConstantValues = values == null ? null : new Values(values);
        this.constantValues = this.constantList.evaluateSomeConstants(values, null);
        this.semanticCheckAfterConstants(this, null);
    }

    public boolean isDefinedConstant(String string) {
        return this.constantList.isDefinedConstant(string);
    }

    public Values getUndefinedConstantValues() {
        return this.undefinedConstantValues;
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    public State getDefaultInitialState() throws PrismLangException {
        Object object;
        Declaration declaration;
        int n;
        if (this.initStates != null) {
            return null;
        }
        State state = new State(this.getNumVars());
        int n2 = 0;
        int n3 = this.getNumGlobals();
        for (n = 0; n < n3; ++n) {
            declaration = this.getGlobal(n);
            object = declaration.getStartOrDefault().evaluate(this.constantValues);
            object = this.getGlobal(n).getType().castValueTo(object);
            state.setValue(n2++, object);
        }
        n3 = this.getNumModules();
        for (n = 0; n < n3; ++n) {
            Module module = this.getModule(n);
            int n4 = module.getNumDeclarations();
            for (int i = 0; i < n4; ++i) {
                declaration = module.getDeclaration(i);
                object = declaration.getStartOrDefault().evaluate(this.constantValues);
                object = module.getDeclaration(i).getType().castValueTo(object);
                state.setValue(n2++, object);
            }
        }
        return state;
    }

    public Values getInitialValues() throws PrismLangException {
        Object object;
        Declaration declaration;
        int n;
        if (this.initStates != null) {
            throw new PrismLangException("There are multiple initial states");
        }
        Values values = new Values();
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            declaration = this.getGlobal(n);
            object = declaration.getStartOrDefault().evaluate(this.constantValues);
            object = this.getGlobal(n).getType().castValueTo(object);
            values.addValue(declaration.getName(), object);
        }
        n2 = this.getNumModules();
        for (n = 0; n < n2; ++n) {
            Module module = this.getModule(n);
            int n3 = module.getNumDeclarations();
            for (int i = 0; i < n3; ++i) {
                declaration = module.getDeclaration(i);
                object = declaration.getStartOrDefault().evaluate(this.constantValues);
                object = module.getDeclaration(i).getType().castValueTo(object);
                values.addValue(declaration.getName(), object);
            }
        }
        return values;
    }

    public void recomputeVariableinformation() throws PrismLangException {
        this.varDecls = new Vector();
        this.varNames = new Vector();
        this.varTypes = new Vector();
        for (Declaration declaration : this.globals) {
            this.varDecls.add(declaration);
            this.varNames.add(declaration.getName());
            this.varTypes.add(declaration.getType());
        }
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            for (Declaration declaration : this.getModule(i).getDeclarations()) {
                this.varDecls.add(declaration);
                this.varNames.add(declaration.getName());
                this.varTypes.add(declaration.getType());
            }
        }
        this.findAllVars(this.varNames, this.varTypes);
    }

    public VarList createVarList() throws PrismLangException {
        return new VarList(this);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        int n;
        String string = "";
        string = string + this.modelType.toString().toLowerCase() + "\n\n";
        String string2 = "" + this.formulaList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        string2 = "" + this.labelList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        string2 = "" + this.constantList;
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        string = string + string2;
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            string = string + "global " + this.getGlobal(n) + ";\n";
        }
        if (n2 > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.modules.size() - 1; ++n) {
            string = string + this.modules.elementAt(n) + "\n\n";
        }
        string = string + this.modules.elementAt(this.modules.size() - 1) + "\n";
        for (n = 0; n < this.systemDefns.size(); ++n) {
            string = string + "\nsystem ";
            if (this.systemDefnNames.get(n) != null) {
                string = string + "\"" + this.systemDefnNames.get(n) + "\" ";
            }
            string = string + this.systemDefns.get(n) + " endsystem\n";
        }
        n2 = this.getNumRewardStructs();
        for (n = 0; n < n2; ++n) {
            string = string + "\n" + this.getRewardStruct(n);
        }
        if (this.initStates != null) {
            string = string + "\ninit " + this.initStates + " endinit\n";
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        int n;
        ModulesFile modulesFile = new ModulesFile();
        modulesFile.setPosition(this);
        modulesFile.setModelType(this.modelType);
        modulesFile.setFormulaList((FormulaList)this.formulaList.deepCopy());
        modulesFile.setLabelList((LabelList)this.labelList.deepCopy());
        modulesFile.setConstantList((ConstantList)this.constantList.deepCopy());
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            modulesFile.addGlobal((Declaration)this.getGlobal(n).deepCopy());
        }
        n2 = this.getNumModules();
        for (n = 0; n < n2; ++n) {
            modulesFile.addModule((Module)this.getModule(n).deepCopy());
        }
        n2 = this.getNumSystemDefns();
        for (n = 0; n < n2; ++n) {
            modulesFile.addSystemDefn(this.getSystemDefn(n).deepCopy(), this.getSystemDefnName(n));
        }
        n2 = this.getNumRewardStructs();
        for (n = 0; n < n2; ++n) {
            modulesFile.addRewardStruct((RewardStruct)this.getRewardStruct(n).deepCopy());
        }
        if (this.initStates != null) {
            modulesFile.setInitialStates(this.initStates.deepCopy());
        }
        modulesFile.formulaIdents = this.formulaIdents == null ? null : (Vector)this.formulaIdents.clone();
        modulesFile.constantIdents = this.constantIdents == null ? null : (Vector)this.constantIdents.clone();
        modulesFile.varIdents = this.varIdents == null ? null : (Vector)this.varIdents.clone();
        modulesFile.moduleNames = this.moduleNames == null ? null : (String[])this.moduleNames.clone();
        Vector<String> vector = modulesFile.synchs = this.synchs == null ? null : (Vector<String>)this.synchs.clone();
        if (this.varDecls != null) {
            modulesFile.varDecls = new Vector();
            for (Declaration declaration : this.varDecls) {
                modulesFile.varDecls.add((Declaration)declaration.deepCopy());
            }
        }
        modulesFile.varNames = this.varNames == null ? null : (Vector)this.varNames.clone();
        modulesFile.varTypes = this.varTypes == null ? null : (Vector)this.varTypes.clone();
        modulesFile.constantValues = this.constantValues == null ? null : new Values(this.constantValues);
        return modulesFile;
    }
}

