/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.ModulesFile;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class Module
extends ASTElement {
    private String name;
    private ExpressionIdent nameASTElement;
    private ArrayList<Declaration> decls;
    private ArrayList<Command> commands;
    private Expression invariant;
    private ModulesFile parent;
    private String baseModule;

    public Module(String string) {
        this.name = string;
        this.decls = new ArrayList();
        this.commands = new ArrayList();
        this.invariant = null;
        this.parent = null;
        this.baseModule = null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameASTElement(ExpressionIdent expressionIdent) {
        this.nameASTElement = expressionIdent;
    }

    public void addDeclaration(Declaration declaration) {
        this.decls.add(declaration);
    }

    public void setDeclaration(int n, Declaration declaration) {
        this.decls.set(n, declaration);
    }

    public void addCommand(Command command) {
        this.commands.add(command);
        command.setParent(this);
    }

    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    public void setCommand(int n, Command command) {
        this.commands.set(n, command);
        command.setParent(this);
    }

    public void setInvariant(Expression expression) {
        this.invariant = expression;
    }

    public void setParent(ModulesFile modulesFile) {
        this.parent = modulesFile;
    }

    public void setBaseModule(String string) {
        this.baseModule = string;
    }

    public String getName() {
        return this.name;
    }

    public ExpressionIdent getNameASTElement() {
        return this.nameASTElement;
    }

    public int getNumDeclarations() {
        return this.decls.size();
    }

    public Declaration getDeclaration(int n) {
        return this.decls.get(n);
    }

    public List<Declaration> getDeclarations() {
        return this.decls;
    }

    public boolean isVariableName(String string) {
        for (Declaration declaration : this.decls) {
            if (!declaration.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getNumCommands() {
        return this.commands.size();
    }

    public Command getCommand(int n) {
        return this.commands.get(n);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public Expression getInvariant() {
        return this.invariant;
    }

    public ModulesFile getParent() {
        return this.parent;
    }

    public String getBaseModule() {
        return this.baseModule;
    }

    public Vector<String> getAllSynchs() {
        Vector<String> vector = new Vector<String>();
        int n = this.getNumCommands();
        for (int i = 0; i < n; ++i) {
            String string = this.getCommand(i).getSynch();
            if (string.equals("") || vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    public boolean usesSynch(String string) {
        return this.getAllSynchs().contains(string);
    }

    public boolean isLocalVariable(String string) {
        int n = this.getNumDeclarations();
        for (int i = 0; i < n; ++i) {
            if (!this.getDeclaration(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        int n;
        String string = "";
        string = string + "module " + this.name + "\n\n";
        int n2 = this.getNumDeclarations();
        for (n = 0; n < n2; ++n) {
            string = string + "\t" + this.getDeclaration(n) + ";\n";
        }
        if (n2 > 0) {
            string = string + "\n";
        }
        if (this.invariant != null) {
            string = string + "\tinvariant " + this.invariant + " endinvariant\n\n";
        }
        n2 = this.getNumCommands();
        for (n = 0; n < n2; ++n) {
            string = string + "\t" + this.getCommand(n) + ";\n";
        }
        string = string + "\nendmodule";
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        int n;
        Module module = new Module(this.name);
        if (this.nameASTElement != null) {
            module.setNameASTElement((ExpressionIdent)this.nameASTElement.deepCopy());
        }
        int n2 = this.getNumDeclarations();
        for (n = 0; n < n2; ++n) {
            module.addDeclaration((Declaration)this.getDeclaration(n).deepCopy());
        }
        n2 = this.getNumCommands();
        for (n = 0; n < n2; ++n) {
            module.addCommand((Command)this.getCommand(n).deepCopy());
        }
        if (this.invariant != null) {
            module.setInvariant(this.invariant.deepCopy());
        }
        module.setPosition(this);
        return module;
    }
}

