/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class LabelList
extends ASTElement {
    private Vector<String> names = new Vector();
    private Vector<Expression> labels = new Vector();
    private Vector<ExpressionIdent> nameIdents = new Vector();

    public void addLabel(ExpressionIdent expressionIdent, Expression expression) {
        this.names.addElement(expressionIdent.getName());
        this.labels.addElement(expression);
        this.nameIdents.add(expressionIdent);
    }

    public void setLabelName(int n, ExpressionIdent expressionIdent) {
        this.names.set(n, expressionIdent.getName());
        this.nameIdents.set(n, expressionIdent);
    }

    public void setLabel(int n, Expression expression) {
        this.labels.set(n, expression);
    }

    public int size() {
        return this.labels.size();
    }

    public String getLabelName(int n) {
        return this.names.elementAt(n);
    }

    public Expression getLabel(int n) {
        return this.labels.elementAt(n);
    }

    public ExpressionIdent getLabelNameIdent(int n) {
        return this.nameIdents.elementAt(n);
    }

    public int getLabelIndex(String string) {
        return this.names.indexOf(string);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            string = string + "label \"" + this.getLabelName(i);
            string = string + "\" = " + this.getLabel(i) + ";\n";
        }
        return string;
    }

    @Override
    public ASTElement deepCopy() {
        LabelList labelList = new LabelList();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            labelList.addLabel((ExpressionIdent)this.getLabelNameIdent(i).deepCopy(), this.getLabel(i).deepCopy());
        }
        labelList.setPosition(this);
        return labelList;
    }
}

