/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionTemporal
extends Expression {
    public static final int P_X = 1;
    public static final int P_U = 2;
    public static final int P_F = 3;
    public static final int P_G = 4;
    public static final int P_W = 5;
    public static final int P_R = 6;
    public static final int R_C = 11;
    public static final int R_I = 12;
    public static final int R_F = 13;
    public static final int R_S = 14;
    public static final String[] opSymbols = new String[]{"", "X", "U", "F", "G", "W", "R", "", "", "", "", "C", "I", "F", "S"};
    protected int op = 0;
    protected Expression operand1 = null;
    protected Expression operand2 = null;
    protected Expression lBound = null;
    protected Expression uBound = null;
    protected boolean lBoundStrict = false;
    protected boolean uBoundStrict = false;
    protected boolean equals = false;

    public ExpressionTemporal() {
    }

    public ExpressionTemporal(int n, Expression expression, Expression expression2) {
        this.op = n;
        this.operand1 = expression;
        this.operand2 = expression2;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperand1(Expression expression) {
        this.operand1 = expression;
    }

    public void setOperand2(Expression expression) {
        this.operand2 = expression;
    }

    public void setLowerBound(Expression expression) {
        this.setLowerBound(expression, false);
    }

    public void setLowerBound(Expression expression, boolean bl) {
        this.lBound = expression;
        this.lBoundStrict = bl;
    }

    public void setUpperBound(Expression expression) {
        this.setUpperBound(expression, false);
    }

    public void setUpperBound(Expression expression, boolean bl) {
        this.uBound = expression;
        this.uBoundStrict = bl;
    }

    public void setEqualBounds(Expression expression) {
        this.lBound = expression;
        this.lBoundStrict = false;
        this.uBound = expression;
        this.uBoundStrict = false;
        this.equals = true;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    public int getNumOperands() {
        if (this.operand1 == null) {
            return 0;
        }
        return this.operand2 == null ? 1 : 2;
    }

    public boolean hasBounds() {
        return this.lBound != null || this.uBound != null;
    }

    public Expression getLowerBound() {
        return this.lBound;
    }

    public boolean lowerBoundIsStrict() {
        return this.lBoundStrict;
    }

    public Expression getUpperBound() {
        return this.uBound;
    }

    public boolean upperBoundIsStrict() {
        return this.uBoundStrict;
    }

    public boolean getEquals() {
        return this.equals;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a temporal operator without a path");
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        if (this.operand1 != null) {
            string = string + this.operand1 + " ";
        }
        string = string + opSymbols[this.op];
        if (this.lBound == null) {
            if (this.uBound != null) {
                string = this.op != 12 ? string + "<" + (this.uBoundStrict ? "" : "=") + this.uBound : string + "=" + this.uBound;
            }
        } else {
            string = this.uBound == null ? string + ">" + (this.lBoundStrict ? "" : "=") + this.lBound : (this.equals ? string + "=" + this.lBound : string + "[" + this.lBound + "," + this.uBound + "]");
        }
        if (this.operand2 != null) {
            string = string + " " + this.operand2;
        }
        return string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionTemporal expressionTemporal = new ExpressionTemporal();
        expressionTemporal.setOperator(this.op);
        if (this.operand1 != null) {
            expressionTemporal.setOperand1(this.operand1.deepCopy());
        }
        if (this.operand2 != null) {
            expressionTemporal.setOperand2(this.operand2.deepCopy());
        }
        expressionTemporal.setLowerBound(this.lBound == null ? null : this.lBound.deepCopy(), this.lBoundStrict);
        expressionTemporal.setUpperBound(this.uBound == null ? null : this.uBound.deepCopy(), this.uBoundStrict);
        expressionTemporal.equals = this.equals;
        expressionTemporal.setType(this.type);
        expressionTemporal.setPosition(this);
        return expressionTemporal;
    }

    public Expression convertToUntilForm() throws PrismLangException {
        ExpressionTemporal expressionTemporal = null;
        switch (this.op) {
            case 2: {
                return this;
            }
            case 3: {
                Expression expression = Expression.True();
                expressionTemporal = new ExpressionTemporal(2, expression, this.operand2);
                expressionTemporal.setLowerBound(this.lBound, this.lBoundStrict);
                expressionTemporal.setUpperBound(this.uBound, this.uBoundStrict);
                expressionTemporal.equals = this.equals;
                return expressionTemporal;
            }
            case 4: {
                Expression expression = Expression.True();
                Expression expression2 = Expression.Not(this.operand2);
                expressionTemporal = new ExpressionTemporal(2, expression, expression2);
                expressionTemporal.setLowerBound(this.lBound, this.lBoundStrict);
                expressionTemporal.setUpperBound(this.uBound, this.uBoundStrict);
                expressionTemporal.equals = this.equals;
                return Expression.Not(expressionTemporal);
            }
            case 5: {
                Expression expression = Expression.And(this.operand1, Expression.Not(this.operand2));
                Expression expression3 = Expression.And(Expression.Not(this.operand1), Expression.Not(this.operand2));
                expressionTemporal = new ExpressionTemporal(2, expression, expression3);
                expressionTemporal.setLowerBound(this.lBound, this.lBoundStrict);
                expressionTemporal.setUpperBound(this.uBound, this.uBoundStrict);
                expressionTemporal.equals = this.equals;
                return Expression.Not(expressionTemporal);
            }
            case 6: {
                Expression expression = Expression.Not(this.operand1);
                Expression expression4 = Expression.Not(this.operand2);
                expressionTemporal = new ExpressionTemporal(2, expression, expression4);
                expressionTemporal.setLowerBound(this.lBound, this.lBoundStrict);
                expressionTemporal.setUpperBound(this.uBound, this.uBoundStrict);
                expressionTemporal.equals = this.equals;
                return Expression.Not(expressionTemporal);
            }
        }
        throw new PrismLangException("Cannot convert " + this.getOperatorSymbol() + " to until form");
    }
}

