/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.List;
import parser.EvaluateContext;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionStrategy
extends Expression {
    protected boolean thereExists = false;
    protected Coalition coalition = new Coalition();
    protected Expression expression = null;

    public ExpressionStrategy() {
    }

    public ExpressionStrategy(boolean bl) {
        this.thereExists = bl;
    }

    public ExpressionStrategy(boolean bl, Expression expression) {
        this.thereExists = bl;
        this.expression = expression;
    }

    public void setThereExists(boolean bl) {
        this.thereExists = bl;
    }

    public void setCoalitionAllPlayers() {
        this.coalition.setAllPlayers();
    }

    public void setCoalition(List<String> list) {
        this.coalition.setPlayers(list);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isThereExists() {
        return this.thereExists;
    }

    public String getOperatorString() {
        return this.thereExists ? "<<>>" : "[[]]";
    }

    public Coalition getCoalition() {
        return this.coalition;
    }

    public boolean coalitionIsAllPlayers() {
        return this.coalition.isAllPlayers();
    }

    public List<String> getCoalitionPlayers() {
        return this.coalition.getPlayers();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a " + this.getOperatorString() + " operator without a model");
    }

    @Override
    public String getResultName() {
        return this.expression.getResultName();
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + (this.thereExists ? "<<" : "[[");
        string = string + this.coalition;
        string = string + (this.thereExists ? ">>" : "]]");
        string = string + " " + this.expression.toString();
        return string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionStrategy expressionStrategy = new ExpressionStrategy();
        expressionStrategy.setThereExists(this.isThereExists());
        expressionStrategy.coalition = new Coalition(this.coalition);
        expressionStrategy.setExpression(this.expression == null ? null : this.expression.deepCopy());
        expressionStrategy.setType(this.type);
        expressionStrategy.setPosition(this);
        return expressionStrategy;
    }
}

