/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionQuant;
import parser.ast.Filter;
import parser.ast.ModulesFile;
import parser.ast.RelOp;
import parser.ast.RewardStruct;
import parser.visitor.ASTVisitor;
import prism.OpRelOpBound;
import prism.PrismException;
import prism.PrismLangException;

public class ExpressionReward
extends ExpressionQuant {
    protected Object rewardStructIndex = null;
    protected Object rewardStructIndexDiv = null;

    public ExpressionReward() {
    }

    public ExpressionReward(Expression expression, String string, Expression expression2) {
        this.setExpression(expression);
        this.setRelOp(string);
        this.setBound(expression2);
    }

    public void setRewardStructIndex(Object object) {
        this.rewardStructIndex = object;
    }

    public void setRewardStructIndexDiv(Object object) {
        this.rewardStructIndexDiv = object;
    }

    public void setReward(Expression expression) {
        this.setBound(expression);
    }

    public Object getRewardStructIndex() {
        return this.rewardStructIndex;
    }

    public Object getRewardStructIndexDiv() {
        return this.rewardStructIndexDiv;
    }

    public Expression getReward() {
        return this.getBound();
    }

    public String getTypeOfROperator() {
        String string = "";
        string = string + "R" + (Object)((Object)this.getRelOp());
        string = string + (this.getBound() == null ? "?" : "r");
        return string;
    }

    public int getRewardStructIndexByIndexObject(ModulesFile modulesFile, Values values) throws PrismException {
        int n = -1;
        Object object = this.rewardStructIndex;
        if (modulesFile == null) {
            throw new PrismException("No model file to obtain reward structures");
        }
        if (modulesFile.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            n = 0;
        } else if (this.rewardStructIndex instanceof Expression) {
            int n2 = ((Expression)this.rewardStructIndex).evaluateInt(values);
            object = new Integer(n2);
            n = n2 - 1;
        } else if (object instanceof String) {
            n = modulesFile.getRewardStructIndex((String)object);
        }
        if (n == -1) {
            throw new PrismException("Invalid reward structure index \"" + object + "\"");
        }
        return n;
    }

    public RewardStruct getRewardStructByIndexObject(ModulesFile modulesFile, Values values) throws PrismException {
        int n = this.getRewardStructIndexByIndexObject(modulesFile, values);
        return modulesFile.getRewardStruct(n);
    }

    @Override
    public OpRelOpBound getRelopBoundInfo(Values values) throws PrismException {
        if (this.getBound() != null) {
            double d = this.getBound().evaluateDouble(values);
            return new OpRelOpBound("R", this.getRelOp(), d);
        }
        return new OpRelOpBound("R", this.getRelOp(), null);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate an R operator without a model");
    }

    @Override
    public String getResultName() {
        if (this.getBound() == null) {
            String string = "E";
            string = this.getRelOp() == RelOp.MIN ? "Minimum e" : (this.getRelOp() == RelOp.MAX ? "Maximum e" : "E");
            string = this.rewardStructIndex instanceof String ? (this.rewardStructIndexDiv instanceof String ? string + "xpected " + this.rewardStructIndex + "/" + this.rewardStructIndexDiv : (this.rewardStructIndexDiv == null ? string + "xpected " + this.rewardStructIndex : string + "xpected reward")) : string + "xpected reward";
            return string;
        }
        return "Result";
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "R" + this.getModifierString();
        if (this.rewardStructIndex != null) {
            if (this.rewardStructIndex instanceof Expression) {
                string = string + "{" + this.rewardStructIndex + "}";
            } else if (this.rewardStructIndex instanceof String) {
                string = string + "{\"" + this.rewardStructIndex + "\"}";
            }
            if (this.rewardStructIndexDiv != null) {
                string = string + "/";
                if (this.rewardStructIndexDiv instanceof Expression) {
                    string = string + "{" + this.rewardStructIndexDiv + "}";
                } else if (this.rewardStructIndexDiv instanceof String) {
                    string = string + "{\"" + this.rewardStructIndexDiv + "\"}";
                }
            }
        }
        string = string + (Object)((Object)this.getRelOp());
        string = string + (this.getBound() == null ? "?" : this.getBound().toString());
        string = string + " [ " + this.getExpression();
        if (this.getFilter() != null) {
            string = string + " " + this.getFilter();
        }
        string = string + " ]";
        return string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionReward expressionReward = new ExpressionReward();
        expressionReward.setExpression(this.getExpression() == null ? null : this.getExpression().deepCopy());
        expressionReward.setRelOp(this.getRelOp());
        expressionReward.setBound(this.getBound() == null ? null : this.getBound().deepCopy());
        if (this.rewardStructIndex != null && this.rewardStructIndex instanceof Expression) {
            expressionReward.setRewardStructIndex(((Expression)this.rewardStructIndex).deepCopy());
        } else {
            expressionReward.setRewardStructIndex(this.rewardStructIndex);
        }
        if (this.rewardStructIndexDiv != null && this.rewardStructIndexDiv instanceof Expression) {
            expressionReward.setRewardStructIndexDiv(((Expression)this.rewardStructIndexDiv).deepCopy());
        } else {
            expressionReward.setRewardStructIndexDiv(this.rewardStructIndexDiv);
        }
        expressionReward.setFilter(this.getFilter() == null ? null : (Filter)this.getFilter().deepCopy());
        expressionReward.setType(this.type);
        expressionReward.setPosition(this);
        return expressionReward;
    }
}

