/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class ExpressionFunc
extends Expression {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int FLOOR = 2;
    public static final int CEIL = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    public static final int LOG = 6;
    public static final int MULTI = 7;
    public static final String[] names = new String[]{"min", "max", "floor", "ceil", "pow", "mod", "log", "multi"};
    public static final int[] minArities = new int[]{2, 2, 1, 1, 2, 2, 2, 1};
    public static final int[] maxArities = new int[]{-1, -1, 1, 1, 2, 2, 2, -1};
    private String name = "";
    private int code = -1;
    private ArrayList<Expression> operands;
    private boolean oldStyle = false;

    public ExpressionFunc() {
        this.operands = new ArrayList();
    }

    public ExpressionFunc(String string) {
        this.setName(string);
        this.operands = new ArrayList();
    }

    public void setName(String string) {
        this.name = string;
        int n = names.length;
        this.code = -1;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(names[i])) continue;
            this.code = i;
            break;
        }
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    public void setOperand(int n, Expression expression) {
        this.operands.set(n, expression);
    }

    public void setOldStyle(boolean bl) {
        this.oldStyle = bl;
    }

    public String getName() {
        return this.name;
    }

    public int getNameCode() {
        return this.code;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return this.operands.get(n);
    }

    public boolean getOldStyle() {
        return this.oldStyle;
    }

    public int getMinArity() {
        return this.code == -1 ? Integer.MAX_VALUE : minArities[this.code];
    }

    public int getMaxArity() {
        return this.code == -1 ? -1 : maxArities[this.code];
    }

    @Override
    public boolean isConstant() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isProposition() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isProposition()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.code) {
            case 0: {
                return this.evaluateMin(evaluateContext);
            }
            case 1: {
                return this.evaluateMax(evaluateContext);
            }
            case 2: {
                return this.evaluateFloor(evaluateContext);
            }
            case 3: {
                return this.evaluateCeil(evaluateContext);
            }
            case 4: {
                return this.evaluatePow(evaluateContext);
            }
            case 5: {
                return this.evaluateMod(evaluateContext);
            }
            case 6: {
                return this.evaluateLog(evaluateContext);
            }
        }
        throw new PrismLangException("Unknown function \"" + this.name + "\"", this);
    }

    private Object evaluateMin(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.type instanceof TypeInt) {
            int n = this.getOperand(0).evaluateInt(evaluateContext);
            int n2 = this.getNumOperands();
            for (int i = 1; i < n2; ++i) {
                int n3 = this.getOperand(i).evaluateInt(evaluateContext);
                n = n3 < n ? n3 : n;
            }
            return new Integer(n);
        }
        double d = this.getOperand(0).evaluateDouble(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            double d2 = this.getOperand(i).evaluateDouble(evaluateContext);
            d = d2 < d ? d2 : d;
        }
        return new Double(d);
    }

    private Object evaluateMax(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.type instanceof TypeInt) {
            int n = this.getOperand(0).evaluateInt(evaluateContext);
            int n2 = this.getNumOperands();
            for (int i = 1; i < n2; ++i) {
                int n3 = this.getOperand(i).evaluateInt(evaluateContext);
                n = n3 > n ? n3 : n;
            }
            return new Integer(n);
        }
        double d = this.getOperand(0).evaluateDouble(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            double d2 = this.getOperand(i).evaluateDouble(evaluateContext);
            d = d2 > d ? d2 : d;
        }
        return new Double(d);
    }

    public Object evaluateFloor(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return new Integer(ExpressionFunc.evaluateFloor(this.getOperand(0).evaluateDouble(evaluateContext)));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateFloor(double d) throws PrismLangException {
        double d2 = Math.floor(d);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new PrismLangException("Cannot take floor() of " + d2);
        }
        return (int)d2;
    }

    public Object evaluateCeil(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return new Integer(ExpressionFunc.evaluateCeil(this.getOperand(0).evaluateDouble(evaluateContext)));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateCeil(double d) throws PrismLangException {
        double d2 = Math.ceil(d);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new PrismLangException("Cannot take ceil() of " + d2);
        }
        return (int)d2;
    }

    public Object evaluatePow(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            if (this.type instanceof TypeInt) {
                return new Integer(ExpressionFunc.evaluatePowInt(this.getOperand(0).evaluateInt(evaluateContext), this.getOperand(1).evaluateInt(evaluateContext)));
            }
            return new Double(ExpressionFunc.evaluatePowDouble(this.getOperand(0).evaluateDouble(evaluateContext), this.getOperand(1).evaluateDouble(evaluateContext)));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluatePowInt(int n, int n2) throws PrismLangException {
        if (n2 < 0) {
            throw new PrismLangException("Negative exponent not allowed for integer power");
        }
        double d = Math.pow(n, n2);
        if (d > 2.147483647E9) {
            throw new PrismLangException("Overflow evaluating integer power");
        }
        return (int)d;
    }

    public static double evaluatePowDouble(double d, double d2) throws PrismLangException {
        return Math.pow(d, d2);
    }

    public Object evaluateMod(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return new Integer(ExpressionFunc.evaluateMod(this.getOperand(0).evaluateInt(evaluateContext), this.getOperand(1).evaluateInt(evaluateContext)));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateMod(int n, int n2) throws PrismLangException {
        if (n2 <= 0) {
            throw new PrismLangException("Attempt to compute modulo with non-positive divisor");
        }
        int n3 = n % n2;
        return n3 < 0 ? n3 + n2 : n3;
    }

    public Object evaluateLog(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return new Double(ExpressionFunc.evaluateLog(this.getOperand(0).evaluateDouble(evaluateContext), this.getOperand(1).evaluateDouble(evaluateContext)));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static double evaluateLog(double d, double d2) throws PrismLangException {
        return PrismUtils.log(d, d2);
    }

    @Override
    public boolean returnsSingleValue() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).returnsSingleValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = "";
        boolean bl = true;
        string = !this.oldStyle ? string + this.name + "(" : string + "func(" + this.name + ", ";
        int n = this.operands.size();
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                string = string + ", ";
            } else {
                bl = false;
            }
            string = string + this.getOperand(i);
        }
        string = string + ")";
        return string;
    }

    @Override
    public Expression deepCopy() {
        ExpressionFunc expressionFunc = new ExpressionFunc(this.name);
        expressionFunc.setOldStyle(this.oldStyle);
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            expressionFunc.addOperand(this.getOperand(i).deepCopy());
        }
        expressionFunc.setType(this.type);
        expressionFunc.setPosition(this);
        return expressionFunc;
    }
}

