/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionConstant
extends Expression {
    String name;

    public ExpressionConstant() {
    }

    public ExpressionConstant(String string, Type type) {
        this.setType(type);
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getConstantValue(this.name);
        if (object == null) {
            throw new PrismLangException("Could not evaluate constant", this);
        }
        return object;
    }

    @Override
    public boolean returnsSingleValue() {
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Expression deepCopy() {
        ExpressionConstant expressionConstant = new ExpressionConstant(this.name, this.type);
        expressionConstant.setPosition(this);
        return expressionConstant;
    }
}

