/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionBinaryOp
extends Expression {
    public static final int IMPLIES = 1;
    public static final int IFF = 2;
    public static final int OR = 3;
    public static final int AND = 4;
    public static final int EQ = 5;
    public static final int NE = 6;
    public static final int GT = 7;
    public static final int GE = 8;
    public static final int LT = 9;
    public static final int LE = 10;
    public static final int PLUS = 11;
    public static final int MINUS = 12;
    public static final int TIMES = 13;
    public static final int DIVIDE = 14;
    public static final String[] opSymbols = new String[]{"", "=>", "<=>", "|", "&", "=", "!=", ">", ">=", "<", "<=", "+", "-", "*", "/"};
    protected int op = 0;
    protected Expression operand1 = null;
    protected Expression operand2 = null;

    public static boolean isLogical(int n) {
        return n == 1 || n == 2 || n == 3 || n == 4;
    }

    public static boolean isRelOp(int n) {
        return n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10;
    }

    public static boolean isArithmetic(int n) {
        return n == 11 || n == 12 || n == 13 || n == 14;
    }

    public ExpressionBinaryOp() {
    }

    public ExpressionBinaryOp(int n, Expression expression, Expression expression2) {
        this.operand1 = expression;
        this.operand2 = expression2;
        this.op = n;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperand1(Expression expression) {
        this.operand1 = expression;
    }

    public void setOperand2(Expression expression) {
        this.operand2 = expression;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public boolean isConstant() {
        return this.operand1.isConstant() && this.operand2.isConstant();
    }

    @Override
    public boolean isProposition() {
        return this.operand1.isProposition() && this.operand2.isProposition();
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.op) {
            case 1: {
                return new Boolean(!this.operand1.evaluateBoolean(evaluateContext) || this.operand2.evaluateBoolean(evaluateContext));
            }
            case 2: {
                return new Boolean(this.operand1.evaluateBoolean(evaluateContext) == this.operand2.evaluateBoolean(evaluateContext));
            }
            case 3: {
                return new Boolean(this.operand1.evaluateBoolean(evaluateContext) || this.operand2.evaluateBoolean(evaluateContext));
            }
            case 4: {
                return new Boolean(this.operand1.evaluateBoolean(evaluateContext) && this.operand2.evaluateBoolean(evaluateContext));
            }
            case 5: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) == this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) == this.operand2.evaluateDouble(evaluateContext));
            }
            case 6: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) != this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) != this.operand2.evaluateDouble(evaluateContext));
            }
            case 7: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) > this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) > this.operand2.evaluateDouble(evaluateContext));
            }
            case 8: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) >= this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) >= this.operand2.evaluateDouble(evaluateContext));
            }
            case 9: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) < this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) < this.operand2.evaluateDouble(evaluateContext));
            }
            case 10: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Boolean(this.operand1.evaluateInt(evaluateContext) <= this.operand2.evaluateInt(evaluateContext));
                }
                return new Boolean(this.operand1.evaluateDouble(evaluateContext) <= this.operand2.evaluateDouble(evaluateContext));
            }
            case 11: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Integer(this.operand1.evaluateInt(evaluateContext) + this.operand2.evaluateInt(evaluateContext));
                }
                return new Double(this.operand1.evaluateDouble(evaluateContext) + this.operand2.evaluateDouble(evaluateContext));
            }
            case 12: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Integer(this.operand1.evaluateInt(evaluateContext) - this.operand2.evaluateInt(evaluateContext));
                }
                return new Double(this.operand1.evaluateDouble(evaluateContext) - this.operand2.evaluateDouble(evaluateContext));
            }
            case 13: {
                if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                    return new Integer(this.operand1.evaluateInt(evaluateContext) * this.operand2.evaluateInt(evaluateContext));
                }
                return new Double(this.operand1.evaluateDouble(evaluateContext) * this.operand2.evaluateDouble(evaluateContext));
            }
            case 14: {
                return new Double(this.operand1.evaluateDouble(evaluateContext) / this.operand2.evaluateDouble(evaluateContext));
            }
        }
        throw new PrismLangException("Unknown binary operator", this);
    }

    @Override
    public boolean returnsSingleValue() {
        return this.operand1.returnsSingleValue() && this.operand2.returnsSingleValue();
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.operand1 + opSymbols[this.op] + this.operand2;
    }

    @Override
    public Expression deepCopy() {
        ExpressionBinaryOp expressionBinaryOp = new ExpressionBinaryOp(this.op, this.operand1.deepCopy(), this.operand2.deepCopy());
        expressionBinaryOp.setType(this.type);
        expressionBinaryOp.setPosition(this);
        return expressionBinaryOp;
    }
}

