/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import jltl2ba.SimpleLTL;
import parser.EvaluateContext;
import parser.EvaluateContextState;
import parser.EvaluateContextSubstate;
import parser.EvaluateContextValues;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypePathBool;
import parser.visitor.ASTTraverse;
import parser.visitor.CheckValid;
import parser.visitor.ConvertForJltl2ba;
import prism.ModelType;
import prism.PrismLangException;

public abstract class Expression
extends ASTElement {
    public abstract boolean isConstant();

    public abstract boolean isProposition();

    public abstract Object evaluate(EvaluateContext var1) throws PrismLangException;

    public String getResultName() {
        return "Result";
    }

    public abstract boolean returnsSingleValue();

    @Override
    public abstract Expression deepCopy();

    public void checkValid(ModelType modelType) throws PrismLangException {
        CheckValid checkValid = new CheckValid(modelType);
        this.accept(checkValid);
    }

    public boolean isSimplePathFormula() throws PrismLangException {
        if (this instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)this;
            int n = expressionUnaryOp.getOperator();
            if (n == 1 || n == 3) {
                return expressionUnaryOp.getOperand().isSimplePathFormula();
            }
            return false;
        }
        if (this instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)this;
            if (expressionTemporal.getOperand1() != null && !(expressionTemporal.getOperand1().getType() instanceof TypeBool)) {
                return false;
            }
            return expressionTemporal.getOperand2() == null || expressionTemporal.getOperand2().getType() instanceof TypeBool;
        }
        return false;
    }

    public boolean isPathFormula(boolean bl) {
        try {
            if (this.getType() == null) {
                this.typeCheck();
            }
            if (this.getType() == TypePathBool.getInstance() || this.getType() == TypeBool.getInstance()) {
                return bl || this.computeProbNesting() < 1;
            }
            return false;
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
    }

    public SimpleLTL convertForJltl2ba() throws PrismLangException {
        ConvertForJltl2ba convertForJltl2ba = new ConvertForJltl2ba();
        this.accept(convertForJltl2ba);
        return convertForJltl2ba.getFormula(this);
    }

    public Object evaluate() throws PrismLangException {
        return this.evaluate(new EvaluateContextValues(null, null));
    }

    public Object evaluate(Values values) throws PrismLangException {
        return this.evaluate(new EvaluateContextValues(values, null));
    }

    public Object evaluate(Values values, Values values2) throws PrismLangException {
        return this.evaluate(new EvaluateContextValues(values, values2));
    }

    public Object evaluate(State state) throws PrismLangException {
        return this.evaluate(new EvaluateContextState(state));
    }

    public Object evaluate(Values values, State state) throws PrismLangException {
        return this.evaluate(new EvaluateContextState(values, state));
    }

    public Object evaluate(State state, int[] nArray) throws PrismLangException {
        return this.evaluate(new EvaluateContextSubstate(state, nArray));
    }

    public Object evaluate(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluate(new EvaluateContextSubstate(values, state, nArray));
    }

    public int evaluateInt(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = this.evaluate(evaluateContext);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        throw new PrismLangException("Cannot evaluate to an integer", this);
    }

    public int evaluateInt() throws PrismLangException {
        return this.evaluateInt(new EvaluateContextValues(null, null));
    }

    public int evaluateInt(Values values) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextValues(values, null));
    }

    public int evaluateInt(Values values, Values values2) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextValues(values, values2));
    }

    public int evaluateInt(State state) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextState(state));
    }

    public int evaluateInt(Values values, State state) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextState(values, state));
    }

    public int evaluateInt(State state, int[] nArray) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextSubstate(state, nArray));
    }

    public int evaluateInt(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateInt(new EvaluateContextSubstate(values, state, nArray));
    }

    public double evaluateDouble(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = this.evaluate(evaluateContext);
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new PrismLangException("Cannot evaluate to a double", this);
    }

    public double evaluateDouble() throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextValues(null, null));
    }

    public double evaluateDouble(Values values) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextValues(values, null));
    }

    public double evaluateDouble(Values values, Values values2) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextValues(values, values2));
    }

    public double evaluateDouble(State state) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextState(state));
    }

    public double evaluateDouble(Values values, State state) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextState(values, state));
    }

    public double evaluateDouble(State state, int[] nArray) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextSubstate(state, nArray));
    }

    public double evaluateDouble(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateDouble(new EvaluateContextSubstate(values, state, nArray));
    }

    public boolean evaluateBoolean(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = this.evaluate(evaluateContext);
        if (!(object instanceof Boolean)) {
            throw new PrismLangException("Cannot evaluate to a boolean", this);
        }
        return (Boolean)object;
    }

    public boolean evaluateBoolean() throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextValues(null, null));
    }

    public boolean evaluateBoolean(Values values) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextValues(values, null));
    }

    public boolean evaluateBoolean(Values values, Values values2) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextValues(values, values2));
    }

    public boolean evaluateBoolean(State state) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextState(state));
    }

    public boolean evaluateBoolean(Values values, State state) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextState(values, state));
    }

    public boolean evaluateBoolean(State state, int[] nArray) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextSubstate(state, nArray));
    }

    public boolean evaluateBoolean(Values values, State state, int[] nArray) throws PrismLangException {
        return this.evaluateBoolean(new EvaluateContextSubstate(values, state, nArray));
    }

    public static Expression True() {
        return new ExpressionLiteral(TypeBool.getInstance(), true);
    }

    public static Expression False() {
        return new ExpressionLiteral(TypeBool.getInstance(), false);
    }

    public static Expression Int(int n) {
        return new ExpressionLiteral(TypeInt.getInstance(), n);
    }

    public static Expression Double(double d) {
        return new ExpressionLiteral(TypeDouble.getInstance(), d);
    }

    public static Expression Literal(Object object) throws PrismLangException {
        if (object instanceof Integer) {
            return Expression.Int((Integer)object);
        }
        if (object instanceof Double) {
            return Expression.Double((Double)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? Expression.True() : Expression.False();
        }
        throw new PrismLangException("Unknown object type " + object.getClass());
    }

    public static Expression Not(Expression expression) {
        return new ExpressionUnaryOp(1, expression);
    }

    public static Expression And(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(4, expression, expression2);
    }

    public static Expression Or(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(3, expression, expression2);
    }

    public static Expression Iff(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(2, expression, expression2);
    }

    public static Expression Implies(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(1, expression, expression2);
    }

    public static Expression Plus(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(11, expression, expression2);
    }

    public static Expression Minus(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(12, expression, expression2);
    }

    public static Expression Times(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(13, expression, expression2);
    }

    public static Expression Divide(Expression expression, Expression expression2) {
        return new ExpressionBinaryOp(14, expression, expression2);
    }

    public static Expression Parenth(Expression expression) {
        return new ExpressionUnaryOp(3, expression);
    }

    public static boolean isTrue(Expression expression) {
        return expression instanceof ExpressionLiteral && ((ExpressionLiteral)expression).getValue().equals(true);
    }

    public static boolean isFalse(Expression expression) {
        return expression instanceof ExpressionLiteral && ((ExpressionLiteral)expression).getValue().equals(false);
    }

    public static boolean isInt(Expression expression) {
        return expression instanceof ExpressionLiteral && expression.getType() instanceof TypeInt;
    }

    public static boolean isDouble(Expression expression) {
        return expression instanceof ExpressionLiteral && expression.getType() instanceof TypeDouble;
    }

    public static boolean isNot(Expression expression) {
        return expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1;
    }

    public static boolean isAnd(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 4;
    }

    public static boolean isOr(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 3;
    }

    public static boolean isIff(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 2;
    }

    public static boolean isImplies(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == 1;
    }

    public static boolean isParenth(Expression expression) {
        return expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 3;
    }

    public static boolean isRelOp(Expression expression) {
        return expression instanceof ExpressionBinaryOp && ExpressionBinaryOp.isRelOp(((ExpressionBinaryOp)expression).getOperator());
    }

    public static boolean isFunc(Expression expression, int n) {
        return expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getNameCode() == n;
    }

    public static boolean isQuantitative(Expression expression) {
        if (expression instanceof ExpressionProb) {
            return ((ExpressionProb)expression).getProb() == null;
        }
        if (expression instanceof ExpressionReward) {
            return ((ExpressionReward)expression).getReward() == null;
        }
        if (expression instanceof ExpressionSS) {
            return ((ExpressionSS)expression).getProb() == null;
        }
        return false;
    }

    public static boolean containsTemporalTimeBounds(Expression expression) {
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPre(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    if (expressionTemporal.getLowerBound() != null) {
                        throw new PrismLangException(expressionTemporal.getOperatorSymbol());
                    }
                    if (expressionTemporal.getUpperBound() != null) {
                        throw new PrismLangException(expressionTemporal.getOperatorSymbol());
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static boolean containsMultiObjective(Expression expression) {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionFunc expressionFunc) throws PrismLangException {
                    if (expressionFunc.getNameCode() == 7) {
                        throw new PrismLangException("Found one", expressionFunc);
                    }
                }
            };
            expression.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }

    public static Expression convertSimplePathFormulaToCanonicalForm(Expression expression) throws PrismLangException {
        Expression expression2;
        boolean bl = false;
        if (!expression.isSimplePathFormula()) {
            throw new PrismLangException("Expression is not a simple path formula.");
        }
        while (expression instanceof ExpressionUnaryOp) {
            expression2 = (ExpressionUnaryOp)expression;
            if (((ExpressionUnaryOp)expression2).getOperator() == 3) {
                expression = ((ExpressionUnaryOp)expression2).getOperand();
                continue;
            }
            if (((ExpressionUnaryOp)expression2).getOperator() == 1) {
                bl = !bl;
                expression = ((ExpressionUnaryOp)expression2).getOperand();
                continue;
            }
            throw new PrismLangException("Expression is not a simple path formula: Unexpected unary operator " + ((ExpressionUnaryOp)expression2).getOperatorSymbol());
        }
        if (expression instanceof ExpressionTemporal) {
            expression2 = (ExpressionTemporal)expression;
            if (((ExpressionTemporal)expression2).getOperator() == 1) {
                if (bl) {
                    if (((ExpressionTemporal)expression2).hasBounds()) {
                        throw new PrismLangException("Next-Step operator should not have bounds!");
                    }
                    return new ExpressionTemporal(1, null, Expression.Not(Expression.Parenth(((ExpressionTemporal)expression2).getOperand2())));
                }
                return expression2;
            }
            expression = ((ExpressionTemporal)expression2).getOperator() == 2 ? expression2 : ((ExpressionTemporal)expression2).convertToUntilForm();
        } else {
            throw new PrismLangException("Expression is not a simple path formula: Unsupported expression " + expression.toString());
        }
        if (bl) {
            if (expression instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
                return ((ExpressionUnaryOp)expression).getOperand();
            }
            return Expression.Not(expression);
        }
        return expression;
    }
}

