/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.lang.constant.Constable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import parser.State;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismLangException;

public class Values {
    protected ArrayList<String> names;
    protected ArrayList<Object> values;

    public Values() {
        this.names = new ArrayList();
        this.values = new ArrayList();
    }

    public Values(Values values) {
        this.names = (ArrayList)values.names.clone();
        this.values = (ArrayList)values.values.clone();
    }

    public Values(Values values, Values values2) {
        this(values);
        this.addValues(values2);
    }

    public Values(State state, ModulesFile modulesFile) {
        this();
        int n = state.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.addValue(modulesFile.getVarName(i), state.varValues[i]);
        }
    }

    public void addValue(String string, Object object) {
        this.names.add(string);
        this.values.add(object);
    }

    public void addValues(Values values) {
        if (values == null) {
            return;
        }
        int n = values.getNumValues();
        for (int i = 0; i < n; ++i) {
            this.addValue(values.getName(i), values.getValue(i));
        }
    }

    public int setValue(String string, Object object) {
        int n = this.getIndexOf(string);
        if (n == -1) {
            this.addValue(string, object);
            return 0;
        }
        this.values.set(n, object);
        return -1;
    }

    public int setValues(Values values) {
        int n = 0;
        if (values == null) {
            return n;
        }
        int n2 = values.getNumValues();
        for (int i = 0; i < n2; ++i) {
            if (this.setValue(values.getName(i), values.getValue(i)) != 0) continue;
            ++n;
        }
        return n;
    }

    public void removeValue(int n) {
        if (n >= 0 && n < this.getNumValues()) {
            this.names.remove(n);
            this.values.remove(n);
        }
    }

    public void removeValue(String string) {
        int n = this.getIndexOf(string);
        if (n != -1) {
            this.removeValue(n);
        }
    }

    public int getNumValues() {
        return this.names.size();
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public int getIndexOf(String string) {
        return this.names.indexOf(string);
    }

    public boolean contains(String string) {
        return this.names.contains(string);
    }

    public Type getType(int n) {
        Object object = this.values.get(n);
        if (object instanceof Integer) {
            return TypeInt.getInstance();
        }
        if (object instanceof Double) {
            return TypeDouble.getInstance();
        }
        if (object instanceof Boolean) {
            return TypeBool.getInstance();
        }
        return null;
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public int getIntValue(int n) throws PrismLangException {
        Object object = this.values.get(n);
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new PrismLangException("Cannot get integer value for \"" + this.getName(n) + "\"");
    }

    public double getDoubleValue(int n) throws PrismLangException {
        Object object = this.values.get(n);
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new PrismLangException("Cannot get double value for \"" + this.getName(n) + "\"");
    }

    public boolean getBooleanValue(int n) throws PrismLangException {
        Object object = this.values.get(n);
        if (!(object instanceof Boolean)) {
            throw new PrismLangException("Cannot get boolean value for \"" + this.getName(n) + "\"");
        }
        return (Boolean)object;
    }

    public Object getValueOf(String string) throws PrismLangException {
        int n = this.getIndexOf(string);
        if (n == -1) {
            throw new PrismLangException("Couldn't get value for \"" + string + "\"");
        }
        return this.getValue(n);
    }

    public int getIntValueOf(String string) throws PrismLangException {
        int n = this.getIndexOf(string);
        if (n == -1) {
            throw new PrismLangException("Couldn't get value for \"" + string + "\"");
        }
        return this.getIntValue(n);
    }

    public double getDoubleValueOf(String string) throws PrismLangException {
        int n = this.getIndexOf(string);
        if (n == -1) {
            throw new PrismLangException("Couldn't get value for \"" + string + "\"");
        }
        return this.getDoubleValue(n);
    }

    public boolean getBooleanValueOf(String string) throws PrismLangException {
        int n = this.getIndexOf(string);
        if (n == -1) {
            throw new PrismLangException("Couldn't get value for \"" + string + "\"");
        }
        return this.getBooleanValue(n);
    }

    public boolean equals(Object object) {
        Values values;
        if (object == null) {
            return false;
        }
        try {
            values = (Values)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n = this.getNumValues();
        if (values.getNumValues() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.getName(i);
            int n2 = values.getIndexOf(string);
            if (n2 == -1) {
                return false;
            }
            object = values.getValue(n2);
            if (this.getValue(i).equals(object)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        Values values = new Values();
        int n = this.getNumValues();
        for (int i = 0; i < n; ++i) {
            String string = this.getName(i);
            Object object = this.getValue(i);
            object = object instanceof Integer ? new Integer((Integer)object) : (object instanceof Double ? (Constable)new Double((Double)object) : (Constable)new Boolean((Boolean)object));
            values.addValue(string, object);
        }
        return values;
    }

    public String toString() {
        return this.toString(true, ",");
    }

    public String toString(boolean bl, String string) {
        int n = this.getNumValues();
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            if (bl) {
                string2 = string2 + this.getName(i) + "=";
            }
            string2 = string2 + this.valToString(this.getValue(i));
            if (i >= n - 1) continue;
            string2 = string2 + string;
        }
        return string2;
    }

    public static String toStringConcatenated(Values values, Values values2) {
        String string;
        String string2 = "";
        if (values != null) {
            string2 = string2 + values.toString();
        }
        if (values2 != null && (string = values2.toString()).length() > 0) {
            if (string2.length() > 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    private String valToString(Object object) {
        String string;
        if (object instanceof Double) {
            NumberFormat numberFormat = DecimalFormat.getInstance(Locale.UK);
            numberFormat.setMaximumFractionDigits(6);
            string = numberFormat.format((Double)object);
        } else {
            string = object.toString();
        }
        return string;
    }
}

