/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import param.ChoiceListFlexi;
import param.TransitionList;
import parser.State;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Update;
import parser.ast.Updates;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;

public class SymbolicEngine {
    protected ModulesFile modulesFile;
    protected ModelType modelType;
    protected int numModules;
    protected int numSynchs;
    protected Vector<String> synchs;
    protected List<List<List<Updates>>> updateLists;
    protected BitSet enabledSynchs;
    protected BitSet[] enabledModules;
    protected int[] synchModuleCounts;

    public SymbolicEngine(ModulesFile modulesFile) {
        int n;
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.numModules = modulesFile.getNumModules();
        this.synchs = modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        ArrayList<HashSet<String>> arrayList = new ArrayList<HashSet<String>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            arrayList.add(new HashSet<String>(modulesFile.getModule(n).getAllSynchs()));
        }
        this.synchModuleCounts = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            this.synchModuleCounts[n] = 0;
            String string = this.synchs.get(n);
            for (int i = 0; i < this.numModules; ++i) {
                if (!((HashSet)arrayList.get(i)).contains(string)) continue;
                int n2 = n;
                this.synchModuleCounts[n2] = this.synchModuleCounts[n2] + 1;
            }
        }
        this.updateLists = new ArrayList<List<List<Updates>>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            this.updateLists.add(new ArrayList(this.numSynchs + 1));
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                this.updateLists.get(n).add(new ArrayList());
            }
        }
        this.enabledSynchs = new BitSet(this.numSynchs + 1);
        this.enabledModules = new BitSet[this.numSynchs + 1];
        for (n = 0; n < this.numSynchs + 1; ++n) {
            this.enabledModules[n] = new BitSet(this.numModules);
        }
    }

    private void calculateUpdatesForModule(int n, State state) throws PrismLangException {
        Module module = this.modulesFile.getModule(n);
        int n2 = module.getNumCommands();
        for (int i = 0; i < n2; ++i) {
            Command command = module.getCommand(i);
            if (!command.getGuard().evaluateBoolean(state)) continue;
            int n3 = command.getSynchIndex();
            this.updateLists.get(n).get(n3).add(command.getUpdates());
            this.enabledSynchs.set(n3);
            this.enabledModules[n3].set(n);
        }
    }

    public Expression getProbabilityInState(Updates updates, int n, State state) throws PrismLangException {
        Expression expression = updates.getProbability(n);
        return expression == null ? Expression.Double(1.0) : expression;
    }

    static boolean hasMoreThanOneVariable(Expression expression) {
        int n = 0;
        try {
            n = expression.getAllVars().size();
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
        return n > 1;
    }

    private ChoiceListFlexi processUpdatesAndCreateNewChoice(int n, Updates updates, State state) throws PrismLangException {
        ChoiceListFlexi choiceListFlexi = new ChoiceListFlexi();
        choiceListFlexi.setModuleOrActionIndex(n);
        int n2 = updates.getNumUpdates();
        for (int i = 0; i < n2; ++i) {
            Expression expression = this.getProbabilityInState(updates, i, state);
            int[] nArray = new int[state.varValues.length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = j;
            }
            expression = (Expression)expression.deepCopy().evaluatePartially(state, nArray);
            ArrayList<Update> arrayList = new ArrayList<Update>();
            arrayList.add(updates.getUpdate(i));
            choiceListFlexi.add(expression, arrayList);
        }
        return choiceListFlexi;
    }

    public TransitionList calculateTransitions(State state) throws PrismException {
        int n;
        int n2;
        TransitionList transitionList = new TransitionList();
        transitionList.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                this.updateLists.get(n2).get(n).clear();
            }
        }
        this.enabledSynchs.clear();
        for (n2 = 0; n2 < this.numSynchs + 1; ++n2) {
            this.enabledModules[n2].clear();
        }
        for (n2 = 0; n2 < this.numModules; ++n2) {
            this.calculateUpdatesForModule(n2, state);
        }
        n2 = this.enabledModules[0].nextSetBit(0);
        while (n2 >= 0) {
            for (Updates object2 : this.updateLists.get(n2).get(0)) {
                transitionList.add(this.processUpdatesAndCreateNewChoice(-(n2 + 1), object2, state));
            }
            n2 = this.enabledModules[0].nextSetBit(n2 + 1);
        }
        ArrayList<ChoiceListFlexi> arrayList = new ArrayList<ChoiceListFlexi>();
        n2 = this.enabledSynchs.nextSetBit(1);
        while (n2 >= 0) {
            arrayList.clear();
            if (this.enabledModules[n2].cardinality() >= this.synchModuleCounts[n2 - 1]) {
                n = this.enabledModules[n2].nextSetBit(0);
                while (n >= 0) {
                    Object object;
                    int n3 = this.updateLists.get(n).get(n2).size();
                    if (n3 == 1) {
                        object = this.updateLists.get(n).get(n2).get(0);
                        if (arrayList.size() == 0) {
                            arrayList.add(this.processUpdatesAndCreateNewChoice(n2, (Updates)object, state));
                        } else {
                            for (ChoiceListFlexi choiceListFlexi : arrayList) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, choiceListFlexi);
                            }
                        }
                    } else if (arrayList.size() == 0) {
                        for (Updates updates : this.updateLists.get(n).get(n2)) {
                            arrayList.add(this.processUpdatesAndCreateNewChoice(n2, updates, state));
                        }
                    } else {
                        int n4;
                        int n5;
                        int n6 = arrayList.size();
                        for (n5 = 0; n5 < n3 - 1; ++n5) {
                            for (n4 = 0; n4 < n6; ++n4) {
                                arrayList.add(new ChoiceListFlexi((ChoiceListFlexi)arrayList.get(n4)));
                            }
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            object = this.updateLists.get(n).get(n2).get(n5);
                            for (n4 = 0; n4 < n6; ++n4) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, (ChoiceListFlexi)arrayList.get(n5 * n6 + n4));
                            }
                        }
                    }
                    n = this.enabledModules[n2].nextSetBit(n + 1);
                }
                for (ChoiceListFlexi choiceListFlexi : arrayList) {
                    transitionList.add(choiceListFlexi);
                }
            }
            n2 = this.enabledSynchs.nextSetBit(n2 + 1);
        }
        return transitionList;
    }

    private void processUpdatesAndAddToProduct(Updates updates, State state, ChoiceListFlexi choiceListFlexi) throws PrismLangException {
        ChoiceListFlexi choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(0, updates, state);
        choiceListFlexi.productWith(choiceListFlexi2);
    }
}

