/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import param.BoxRegion;
import param.ConstraintChecker;
import param.Function;
import param.Region;

final class RahdConstraintChecker
extends ConstraintChecker {
    static final String rahdBin = "/home/scratch/svn/pers-sb/rahd/rahd-bin";

    public RahdConstraintChecker(int n) {
        super(n);
    }

    private boolean runRahd(Region region, String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < region.getDimensions(); ++i) {
            stringBuilder.append("x");
            stringBuilder.append(i);
            stringBuilder.append(" ");
        }
        String[] stringArray = new String[]{"timeout", "5m", rahdBin, "-v", stringBuilder.toString(), "-f", string};
        Process process = null;
        try {
            String string2;
            process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.equals(" unsat")) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    private String buildRegionString(Region region) {
        BoxRegion boxRegion = (BoxRegion)region;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < region.getDimensions(); ++i) {
            stringBuilder.append("x");
            stringBuilder.append(i);
            stringBuilder.append(">=");
            stringBuilder.append(boxRegion.getDimensionLower(i));
            stringBuilder.append(" /\\ ");
            stringBuilder.append("x");
            stringBuilder.append(i);
            stringBuilder.append("<=");
            stringBuilder.append(boxRegion.getDimensionUpper(i));
            if (i >= region.getDimensions() - 1) continue;
            stringBuilder.append(" /\\ ");
        }
        return stringBuilder.toString();
    }

    @Override
    boolean mainCheck(Region region, Function function, boolean bl) {
        String string = this.buildRegionString(region);
        return this.runRahd(region, string + " /\\ " + function + (bl ? " <= 0" : " < 0"));
    }
}

