/*
 * Decompiled with CFR 0.152.
 */
package param;

import explicit.IndexedSet;
import explicit.Model;
import explicit.StateStorage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import param.BigRational;
import param.CachedFunctionFactory;
import param.ChoiceListFlexi;
import param.DagFunctionFactory;
import param.Function;
import param.FunctionFactory;
import param.JasFunctionFactory;
import param.ParamModel;
import param.SymbolicEngine;
import param.TransitionList;
import parser.State;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ModulesFile;
import parser.visitor.ASTTraverseModify;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;

public final class ModelBuilder
extends PrismComponent {
    private ModulesFile modulesFile;
    private ParamModel model;
    private FunctionFactory functionFactory;
    private String[] paramNames;
    private BigRational[] lower;
    private BigRational[] upper;
    private String functionType;
    private double dagMaxError;
    private static Map<String, Expression> constExprs;

    public ModelBuilder(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (this.settings != null) {
            this.functionType = this.settings.getString("prism.param.function");
            this.dagMaxError = this.settings.getDouble("prism.param.functionDagMaxError");
        }
    }

    Function expr2function(FunctionFactory functionFactory, Expression expression) throws PrismException {
        if (expression instanceof ExpressionLiteral) {
            String string = ((ExpressionLiteral)expression).getString();
            if (string == null || string.equals("")) {
                throw new PrismException("cannot convert from literal for which no string is set");
            }
            return functionFactory.fromBigRational(new BigRational(string));
        }
        if (expression instanceof ExpressionConstant) {
            String string = ((ExpressionConstant)expression).getName();
            int n = this.modulesFile.getConstantList().getConstantIndex(string);
            if (n != -1) {
                Expression expression2 = this.modulesFile.getConstantList().getConstant(n);
                if (expression2 != null) {
                    return this.expr2function(functionFactory, expression2);
                }
                return functionFactory.getVar(string);
            }
            throw new PrismException("Invalid parametric constant definition used");
        }
        if (expression instanceof ExpressionBinaryOp) {
            ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
            Function function = this.expr2function(functionFactory, expressionBinaryOp.getOperand1());
            Function function2 = this.expr2function(functionFactory, expressionBinaryOp.getOperand2());
            switch (expressionBinaryOp.getOperator()) {
                case 11: {
                    return function.add(function2);
                }
                case 12: {
                    return function.subtract(function2);
                }
                case 13: {
                    return function.multiply(function2);
                }
                case 14: {
                    return function.divide(function2);
                }
            }
            throw new PrismNotSupportedException("parametric analysis with rate/probability of " + expression + " not implemented");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            Function function = this.expr2function(functionFactory, expressionUnaryOp.getOperand());
            switch (expressionUnaryOp.getOperator()) {
                case 2: {
                    return function.negate();
                }
                case 3: {
                    return function;
                }
            }
            throw new PrismNotSupportedException("parametric analysis with rate/probability of " + expression + " not implemented");
        }
        throw new PrismNotSupportedException("parametric analysis with rate/probability of " + expression + " not implemented");
    }

    public void setModulesFile(ModulesFile modulesFile) {
        this.modulesFile = modulesFile;
    }

    public void setParameters(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.paramNames = stringArray;
        this.lower = new BigRational[stringArray2.length];
        this.upper = new BigRational[stringArray3.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.lower[i] = new BigRational(stringArray2[i]);
            this.upper[i] = new BigRational(stringArray3[i]);
        }
    }

    public void build() throws PrismException {
        if (this.functionType.equals("JAS")) {
            this.functionFactory = new JasFunctionFactory(this.paramNames, this.lower, this.upper);
        } else if (this.functionType.equals("JAS-cached")) {
            this.functionFactory = new CachedFunctionFactory(new JasFunctionFactory(this.paramNames, this.lower, this.upper));
        } else if (this.functionType.equals("DAG")) {
            this.functionFactory = new DagFunctionFactory(this.paramNames, this.lower, this.upper, this.dagMaxError, false);
        }
        if (this.modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismNotSupportedException("You cannot build a PTA model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model...\n");
        long l = System.currentTimeMillis();
        ConstantList constantList = this.modulesFile.getConstantList();
        constExprs = constantList.evaluateConstantsPartially(this.modulesFile.getUndefinedConstantValues(), null);
        this.modulesFile = (ModulesFile)this.modulesFile.deepCopy();
        this.modulesFile = (ModulesFile)this.modulesFile.accept(new ASTTraverseModify(){

            @Override
            public Object visit(ExpressionConstant expressionConstant) throws PrismLangException {
                Expression expression = (Expression)constExprs.get(expressionConstant.getName());
                return expression != null ? expression.deepCopy() : expressionConstant;
            }
        });
        ParamModel paramModel = this.constructModel(this.modulesFile);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        this.model = paramModel;
    }

    public Model getModel() {
        return this.model;
    }

    private void reserveMemoryAndExploreStates(ModulesFile modulesFile, ParamModel paramModel, ModelType modelType, SymbolicEngine symbolicEngine, StateStorage<State> stateStorage) throws PrismException {
        boolean bl = modelType == ModelType.MDP;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList<State> linkedList = new LinkedList<State>();
        State state = modulesFile.getDefaultInitialState();
        stateStorage.add(state);
        linkedList.add(state);
        ++n;
        while (!linkedList.isEmpty()) {
            state = (State)linkedList.removeFirst();
            TransitionList transitionList = symbolicEngine.calculateTransitions(state);
            int n4 = transitionList.getNumChoices();
            n2 = bl ? (n2 += n4) : ++n2;
            for (int i = 0; i < n4; ++i) {
                int n5 = transitionList.getChoice(i).size();
                n3 += n5;
                for (int j = 0; j < n5; ++j) {
                    State state2 = transitionList.getChoice(i).computeTarget(j, state);
                    if (!stateStorage.add(state2)) continue;
                    ++n;
                    linkedList.add(state2);
                    stateStorage.add(state2);
                }
            }
            if (n4 != 0) continue;
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        paramModel.reserveMem(n, n2, n3);
    }

    private ParamModel constructModel(ModulesFile modulesFile) throws PrismException {
        if (modulesFile.getInitialStates() != null) {
            throw new PrismNotSupportedException("Cannot do explicit-state reachability if there are multiple initial states");
        }
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        long l = System.currentTimeMillis();
        ModelType modelType = modulesFile.getModelType();
        ParamModel paramModel = new ParamModel();
        paramModel.setModelType(modelType);
        if (modelType != ModelType.DTMC && modelType != ModelType.CTMC && modelType != ModelType.MDP) {
            throw new PrismNotSupportedException("Unsupported model type: " + (Object)((Object)modelType));
        }
        SymbolicEngine symbolicEngine = new SymbolicEngine(modulesFile);
        if (modulesFile.getInitialStates() != null) {
            throw new PrismNotSupportedException("Explicit model construction does not support multiple initial states");
        }
        boolean bl = modelType == ModelType.MDP;
        boolean bl2 = modelType == ModelType.CTMC;
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        this.reserveMemoryAndExploreStates(modulesFile, paramModel, modelType, symbolicEngine, indexedSet);
        int[] nArray = indexedSet.buildSortingPermutation();
        ArrayList<State> arrayList = indexedSet.toPermutedArrayList(nArray);
        paramModel.setStatesList(arrayList);
        paramModel.addInitialState(nArray[0]);
        int n = 0;
        for (State state : arrayList) {
            int n2;
            ChoiceListFlexi choiceListFlexi;
            int n3;
            Function function;
            TransitionList transitionList = symbolicEngine.calculateTransitions(state);
            int n4 = transitionList.getNumChoices();
            if (bl) {
                function = this.functionFactory.getOne();
            } else {
                function = this.functionFactory.getZero();
                for (n3 = 0; n3 < n4; ++n3) {
                    choiceListFlexi = transitionList.getChoice(n3);
                    n2 = choiceListFlexi.size();
                    for (int i = 0; i < n2; ++i) {
                        ChoiceListFlexi choiceListFlexi2 = transitionList.getChoice(n3);
                        Expression expression = choiceListFlexi2.getProbability(i);
                        function = function.add(this.expr2function(this.functionFactory, expression));
                    }
                }
            }
            if (function.isZero()) {
                function = this.functionFactory.getOne();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                choiceListFlexi = transitionList.getChoice(n3);
                n2 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n3, 0));
                String string = n2 < 0 ? null : modulesFile.getSynch(n2 - 1);
                int n5 = choiceListFlexi.size();
                for (int i = 0; i < n5; ++i) {
                    ChoiceListFlexi choiceListFlexi3 = transitionList.getChoice(n3);
                    State state2 = choiceListFlexi3.computeTarget(i, state);
                    Expression expression = choiceListFlexi3.getProbability(i);
                    Function function2 = this.expr2function(this.functionFactory, expression).divide(function);
                    paramModel.addTransition(nArray[indexedSet.get(state2)], function2, string);
                }
                if (!bl) continue;
                paramModel.setSumLeaving(bl2 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            if (n4 == 0) {
                paramModel.addDeadlockState(n);
                paramModel.addTransition(n, this.functionFactory.getOne(), null);
                if (bl) {
                    paramModel.setSumLeaving(bl2 ? function : this.functionFactory.getOne());
                    paramModel.finishChoice();
                }
            }
            if (!bl) {
                paramModel.setSumLeaving(bl2 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            paramModel.finishState();
            ++n;
        }
        paramModel.setFunctionFactory(this.functionFactory);
        this.mainLog.println();
        this.mainLog.print("Reachable states exploration and model construction");
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        return paramModel;
    }
}

