/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.FunctionFactory;
import param.Point;
import param.StateValue;

public abstract class Function
extends StateValue {
    protected FunctionFactory factory;

    protected Function(FunctionFactory functionFactory) {
        this.factory = functionFactory;
    }

    abstract Function add(Function var1);

    abstract Function negate();

    abstract Function multiply(Function var1);

    abstract Function divide(Function var1);

    abstract Function star();

    abstract Function toConstraint();

    abstract BigRational evaluate(Point var1, boolean var2);

    abstract BigRational asBigRational();

    abstract boolean isNaN();

    abstract boolean isInf();

    abstract boolean isMInf();

    abstract boolean isOne();

    abstract boolean isZero();

    public Function multiply(int n) {
        Function function = this.factory.fromLong(n);
        return this.multiply(function);
    }

    public Function divide(int n) {
        Function function = this.factory.fromLong(n);
        return this.divide(function);
    }

    public FunctionFactory getFactory() {
        return this.factory;
    }

    public Function subtract(Function function) {
        return this.add(function.negate());
    }

    public BigRational evaluate(Point point) {
        return this.evaluate(point, true);
    }

    boolean check(Point point, boolean bl) {
        BigRational bigRational = this.evaluate(point, false);
        int n = bigRational.signum();
        return bl ? n > 0 : n >= 0;
    }
}

