/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.math.BigInteger;

public final class BigRational
implements Comparable<BigRational> {
    private static final BigInteger BMONE = BigInteger.ONE.negate();
    private static final BigInteger BITWO = new BigInteger("2");
    private static final BigInteger BITEN = new BigInteger("10");
    static final BigRational ONE = new BigRational(BigInteger.ONE);
    static final BigRational MONE = new BigRational(BigInteger.ONE);
    static final BigRational ZERO = new BigRational(BigInteger.ZERO);
    static final BigRational INF = new BigRational(BigInteger.ONE, BigInteger.ZERO);
    static final BigRational MINF = new BigRational(BMONE, BigInteger.ZERO);
    static final BigRational NAN = new BigRational(BigInteger.ZERO, BigInteger.ZERO);
    private BigInteger num;
    private BigInteger den;

    public BigRational() {
        this.num = BigInteger.ZERO;
        this.den = BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger) {
        this.num = bigInteger;
        this.den = BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, true);
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
        if (bigInteger2.equals(BigInteger.ZERO)) {
            int n = bigInteger.compareTo(BigInteger.ZERO);
            switch (n) {
                case -1: {
                    bigInteger = BMONE;
                    break;
                }
                case 1: {
                    bigInteger = BigInteger.ONE;
                }
            }
        }
        if (bl) {
            if (bigInteger.equals(BigInteger.ZERO)) {
                bigInteger = BigInteger.ZERO;
                bigInteger2 = BigInteger.ONE;
            } else {
                BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
                bigInteger = bigInteger.divide(bigInteger3);
                if ((bigInteger2 = bigInteger2.divide(bigInteger3)).signum() == -1) {
                    bigInteger = bigInteger.negate();
                    bigInteger2 = bigInteger2.negate();
                }
            }
        }
        this.num = bigInteger;
        this.den = bigInteger2;
    }

    public BigRational(long l, long l2) {
        this(new BigInteger(Long.toString(l)), new BigInteger(Long.toString(l2)));
    }

    public BigRational(long l) {
        this(l, 1L);
    }

    public BigRational(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (string.equals("Infinity") || string.equals("Inf")) {
            this.num = new BigInteger("1");
            this.den = new BigInteger("0");
            return;
        }
        if (string.equals("-Infinity") || string.equals("-Inf")) {
            this.num = new BigInteger("-1");
            this.den = new BigInteger("0");
            return;
        }
        int n = (string = string.trim()).indexOf(47);
        if (n < 0) {
            Object object;
            String string2;
            int n2;
            Double.parseDouble(string);
            boolean bl = false;
            if (string.charAt(0) == '-') {
                bl = true;
                string = string.substring(1);
            }
            if ((n2 = string.indexOf("e")) < 0) {
                n2 = string.indexOf("E");
            }
            String string3 = string.substring(0, n2 >= 0 ? n2 : string.length());
            int n3 = string3.indexOf(46);
            int n4 = 0;
            if (n3 >= 0) {
                string2 = string3.substring(0, n3);
                string2 = string2 + string3.substring(n3 + 1);
                n4 = -string3.substring(n3 + 1).length();
            } else {
                string2 = string3;
            }
            if (n2 >= 0) {
                object = string.substring(n2 + 1);
                int n5 = Integer.parseInt((String)object);
                n4 += n5;
            }
            bigInteger2 = new BigInteger((bl ? "-" : "") + string2);
            object = BITEN;
            if (n4 == 0) {
                bigInteger = BigInteger.ONE;
            } else if (n4 > 0) {
                bigInteger = BigInteger.ONE;
                bigInteger2 = bigInteger2.multiply(((BigInteger)object).pow(n4));
            } else {
                bigInteger = ((BigInteger)object).pow(-n4);
            }
        } else {
            BigInteger bigInteger3 = new BigInteger(string.substring(0, n));
            BigInteger bigInteger4 = new BigInteger(string.substring(n + 1, string.length()));
            BigRational bigRational = BigRational.cancel(bigInteger3, bigInteger4);
            this.num = bigRational.num;
            this.den = bigRational.den;
            return;
        }
        BigRational bigRational = new BigRational(bigInteger2, bigInteger, true);
        this.num = bigRational.num;
        this.den = bigRational.den;
    }

    public BigRational negate() {
        return new BigRational(this.num.negate(), this.den, false);
    }

    public BigRational cancel() {
        return new BigRational(this.num, this.den, true);
    }

    private static BigRational cancel(BigInteger bigInteger, BigInteger bigInteger2) {
        return new BigRational(bigInteger, bigInteger2);
    }

    public BigRational add(BigRational bigRational, boolean bl) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isInf() || bigRational.isInf()) {
            if (this.isMInf() || bigRational.isMInf()) {
                return ZERO;
            }
            return INF;
        }
        if (this.isMInf() || bigRational.isMInf()) {
            return MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.den).add(bigRational.num.multiply(this.den));
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2, bl);
    }

    public BigRational add(BigRational bigRational) {
        return this.add(bigRational, true);
    }

    public BigRational subtract(BigRational bigRational) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isInf() && bigRational.isInf() || this.isMInf() && bigRational.isMInf()) {
            return ZERO;
        }
        if (this.isInf()) {
            return INF;
        }
        if (this.isMInf()) {
            return MINF;
        }
        if (bigRational.isInf()) {
            return INF;
        }
        if (bigRational.isMInf()) {
            return MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.den).subtract(bigRational.num.multiply(this.den));
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2);
    }

    public BigRational multiply(BigRational bigRational, boolean bl) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isZero() || bigRational.isZero()) {
            return ZERO;
        }
        if (this.isInf() || bigRational.isInf()) {
            return this.signum() * bigRational.signum() == 1 ? INF : MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.num);
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2, bl);
    }

    public BigRational multiply(BigRational bigRational) {
        return this.multiply(bigRational, true);
    }

    public BigRational multiply(long l, boolean bl) {
        return this.multiply(new BigRational(l), bl);
    }

    public BigRational multiply(long l) {
        return this.multiply(l, true);
    }

    public BigRational divide(BigRational bigRational, boolean bl) {
        if (bigRational.isInf() || bigRational.isMInf()) {
            return NAN;
        }
        BigRational bigRational2 = new BigRational(bigRational.den, bigRational.num, bl);
        return this.multiply(bigRational2, bl);
    }

    public BigRational divide(BigRational bigRational) {
        return this.divide(bigRational, true);
    }

    public BigRational divide(long l) {
        return this.divide(new BigRational(l));
    }

    public int signum() {
        return this.num.signum() * this.den.signum();
    }

    public BigRational pow(int n) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n == 0) {
            return ONE;
        }
        if (n > 0) {
            bigInteger2 = this.num.pow(n);
            bigInteger = this.den.pow(n);
        } else {
            bigInteger2 = this.den.pow(n);
            bigInteger = this.num.pow(n);
        }
        return new BigRational(bigInteger2, bigInteger, false);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigRational)) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        if (this.isNaN()) {
            return bigRational.isNaN();
        }
        if (this.isInf()) {
            return bigRational.isInf();
        }
        if (this.isMInf()) {
            return bigRational.isMInf();
        }
        return this.num.equals(bigRational.num) && this.den.equals(bigRational.den);
    }

    public int hashCode() {
        return 37 * this.num.hashCode() + this.den.hashCode();
    }

    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInf()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isMInf()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isOne()) {
            return 1.0;
        }
        if (this.isZero()) {
            return 0.0;
        }
        int n = this.num.signum() * this.den.signum();
        BigInteger bigInteger = this.num.signum() == 1 ? this.num : this.num.negate();
        BigInteger bigInteger2 = this.den.signum() == 1 ? this.den : this.den.negate();
        BigInteger bigInteger3 = bigInteger.shiftLeft(55);
        BigInteger bigInteger4 = bigInteger3.divide(bigInteger2);
        if (bigInteger3.mod(bigInteger2).multiply(BITWO).compareTo(bigInteger2) == 1) {
            bigInteger4 = bigInteger4.add(BigInteger.ONE);
        }
        return (double)n * bigInteger4.doubleValue() / Math.pow(2.0, 55.0);
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInf()) {
            return "Inf";
        }
        if (this.isMInf()) {
            return "-Inf";
        }
        if (this.den.equals(BigInteger.ONE)) {
            return this.num.toString();
        }
        return this.num + "/" + this.den;
    }

    @Override
    public int compareTo(BigRational bigRational) {
        if (this.isInf()) {
            if (bigRational.isInf()) {
                return 0;
            }
            return 1;
        }
        if (this.isMInf()) {
            if (bigRational.isMInf()) {
                return 0;
            }
            return -1;
        }
        return this.num.multiply(bigRational.den).compareTo(bigRational.num.multiply(this.den));
    }

    @Override
    public int compareTo(long l) {
        return this.compareTo(new BigRational(l));
    }

    public BigInteger getNum() {
        return this.num;
    }

    public BigInteger getDen() {
        return this.den;
    }

    public BigRational abs() {
        if (this.num.signum() == -1) {
            return new BigRational(this.num.negate(), this.den);
        }
        return this;
    }

    public BigRational max(BigRational bigRational) {
        if (this.compareTo(bigRational) >= 0) {
            return this;
        }
        return bigRational;
    }

    public BigRational min(BigRational bigRational) {
        if (this.compareTo(bigRational) <= 0) {
            return this;
        }
        return bigRational;
    }

    public boolean isZero() {
        return this.num.equals(BigInteger.ZERO) && this.den.equals(BigInteger.ONE);
    }

    public boolean isOne() {
        return this.num.equals(BigInteger.ONE) && this.den.equals(BigInteger.ONE);
    }

    public boolean isNaN() {
        return this.num.equals(BigInteger.ZERO) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isInf() {
        return this.num.equals(BigInteger.ONE) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isMInf() {
        return this.num.equals(BMONE) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isRational() {
        return !this.isNaN() && !this.isInf() && !this.isMInf();
    }

    public boolean isSpecial() {
        return this.isNaN() || this.isInf() || this.isMInf();
    }
}

