/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.Stack;
import jltl2ba.APElement;
import jltl2ba.APElementIterator;
import jltl2ba.APSet;
import jltl2dstar.DA_State;
import jltl2dstar.DRA;
import jltl2dstar.SafraTree;
import jltl2dstar.SafraTreeTemplate;
import jltl2dstar.SafrasAlgorithm;
import jltl2dstar.StateMapperInterface;
import prism.PrismException;

public class SafraNBA2DRA {
    private boolean _detailed_states;

    public SafraNBA2DRA(boolean bl) {
        this._detailed_states = bl;
    }

    public void convert(SafrasAlgorithm safrasAlgorithm, DRA dRA, int n, StateMapperInterface<SafraTreeTemplate, SafraTree, DA_State> stateMapperInterface) throws PrismException {
        APSet aPSet = dRA.getAPSet();
        if (safrasAlgorithm.checkEmpty()) {
            dRA.constructEmpty();
            return;
        }
        safrasAlgorithm.prepareAcceptance(dRA.acceptance());
        SafraTree safraTree = safrasAlgorithm.getStartState();
        DA_State dA_State = dRA.newState();
        safraTree.generateAcceptance(dA_State.acceptance());
        if (this._detailed_states) {
            dA_State.setDescription(safraTree.toHTML());
        }
        stateMapperInterface.add(safraTree, dA_State);
        dRA.setStartState(dA_State);
        Stack<unprocessed_value> stack = new Stack<unprocessed_value>();
        stack.push(new unprocessed_value(safraTree, dA_State));
        while (!stack.empty()) {
            unprocessed_value unprocessed_value2 = (unprocessed_value)stack.pop();
            SafraTree safraTree2 = unprocessed_value2.algo_state;
            DA_State dA_State2 = unprocessed_value2.da_state;
            APElementIterator aPElementIterator = new APElementIterator(aPSet.size());
            while (aPElementIterator.hasNext()) {
                APElement aPElement = aPElementIterator.next();
                SafraTreeTemplate safraTreeTemplate = safrasAlgorithm.delta(safraTree2, aPElement);
                DA_State dA_State3 = stateMapperInterface.find(safraTreeTemplate);
                if (dA_State3 == null) {
                    dA_State3 = dRA.newState();
                    safraTreeTemplate.getState().generateAcceptance(dA_State3.acceptance());
                    if (this._detailed_states) {
                        dA_State3.setDescription(safraTreeTemplate.getState().toHTML());
                    }
                    stateMapperInterface.add(safraTreeTemplate.getState(), dA_State3);
                    stack.push(new unprocessed_value(safraTreeTemplate.getState(), dA_State3));
                }
                dA_State2.edges().put(aPElement, dA_State3);
                if (n == 0 || dRA.size() <= n) continue;
                throw new PrismException("State limit reached");
            }
        }
    }

    private class unprocessed_value {
        public SafraTree algo_state;
        public DA_State da_state;

        public unprocessed_value(SafraTree safraTree, DA_State dA_State) {
            this.algo_state = safraTree;
            this.da_state = dA_State;
        }
    }
}

