/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2ba.MyBitSet;
import jltl2dstar.APMonom;
import jltl2dstar.NBA;

public class NBA_State
implements Iterable<Map.Entry<APElement, MyBitSet>> {
    private NBA _graph;
    boolean _isFinal;
    String _description;
    EdgeManager _edge_manager;

    public NBA_State(NBA nBA) {
        this._graph = nBA;
        this._isFinal = false;
        this._edge_manager = new EdgeManager(this, nBA.getAPSet());
        this._description = "";
    }

    public void addEdge(APElement aPElement, NBA_State nBA_State) {
        this._edge_manager.addEdge(aPElement, nBA_State);
    }

    public void addEdge(APMonom aPMonom, NBA_State nBA_State) {
        this._edge_manager.addEdge(aPMonom, nBA_State);
    }

    public void addEdges(APElement aPElement, MyBitSet myBitSet) {
        this._edge_manager.addEdges(aPElement, myBitSet);
    }

    public MyBitSet getEdge(APElement aPElement) {
        return this._edge_manager.getEdge(aPElement);
    }

    public int getName() {
        return this._graph.getIndexForState(this);
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public void setFinal(boolean bl) {
        this._isFinal = bl;
        this._graph.getFinalStates().set(this._graph.getIndexForState(this), bl);
    }

    public void setDescription(String string) {
        this._description = string;
    }

    String getDescription() {
        return this._description;
    }

    public boolean hasDescription() {
        return this._description.length() != 0;
    }

    public NBA getGraph() {
        return this._graph;
    }

    @Override
    public Iterator<Map.Entry<APElement, MyBitSet>> iterator() {
        return this._edge_manager.getEdgeContainer().entrySet().iterator();
    }

    public Iterator<Integer> successorIterator() {
        MyBitSet myBitSet = new MyBitSet(this._graph.getStateCount());
        for (MyBitSet myBitSet2 : this._edge_manager.getEdgeContainer().values()) {
            myBitSet.or(myBitSet2);
        }
        return new MyBitSet.MyBitSetIterator(myBitSet);
    }

    public static class EdgeManager {
        private NBA_State _state;
        private HashMap<APElement, MyBitSet> _container;
        private int _apset_size;

        public EdgeManager(NBA_State nBA_State, APSet aPSet) {
            this._apset_size = aPSet.size();
            this._state = nBA_State;
            this._container = new HashMap();
        }

        public MyBitSet getEdge(APElement aPElement) {
            if (this._container.get(aPElement) == null) {
                this._container.put(aPElement, new MyBitSet(this._apset_size));
            }
            return this._container.get(aPElement);
        }

        public void addEdges(APElement aPElement, MyBitSet myBitSet) {
            this._container.put(aPElement, myBitSet);
        }

        public void addEdge(APElement aPElement, NBA_State nBA_State) {
            if (this._container.get(aPElement) == null) {
                this._container.put(aPElement, new MyBitSet(this._apset_size));
            }
            this._container.get(aPElement).set(nBA_State.getName());
        }

        public void addEdge(APMonom aPMonom, NBA_State nBA_State) {
            APSet aPSet = this._state.getGraph().getAPSet();
            Iterator<APElement> iterator = aPMonom.APElementIterator(aPSet);
            while (iterator.hasNext()) {
                APElement aPElement = iterator.next();
                this.addEdge(aPElement, nBA_State);
            }
        }

        public HashMap<APElement, MyBitSet> getEdgeContainer() {
            return this._container;
        }
    }
}

