/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import automata.DA;
import java.util.BitSet;
import jltl2ba.APSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.DRA;
import jltl2dstar.LTL2DRA;
import jltl2dstar.Options_LTL2DRA;
import jltl2dstar.Scheduler;
import prism.PrismException;

public class LTL2Rabin {
    public static DA<BitSet, AcceptanceRabin> ltl2rabin(SimpleLTL simpleLTL) throws PrismException {
        DA<BitSet, ? extends AcceptanceOmega> dA = LTL2Rabin.ltl2da(simpleLTL, AcceptanceType.RABIN);
        return dA;
    }

    public static DA<BitSet, AcceptanceStreett> ltl2streett(SimpleLTL simpleLTL) throws PrismException {
        DA<BitSet, ? extends AcceptanceOmega> dA = LTL2Rabin.ltl2da(simpleLTL, AcceptanceType.STREETT);
        return dA;
    }

    public static DA<BitSet, ? extends AcceptanceOmega> ltl2da(SimpleLTL simpleLTL, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        SimpleLTL simpleLTL2 = simpleLTL.simplify();
        boolean bl = AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN);
        boolean bl2 = AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT);
        if (bl && bl2) {
            bl2 = false;
        }
        return LTL2Rabin.ltl2da(simpleLTL2, simpleLTL2.getAPs(), bl, bl2).createPrismDA();
    }

    private static DRA ltl2da(SimpleLTL simpleLTL, APSet aPSet, boolean bl, boolean bl2) throws PrismException {
        DRA dRA = null;
        Options_LTL2DRA options_LTL2DRA = new Options_LTL2DRA();
        boolean bl3 = false;
        boolean bl4 = false;
        double d = 10.0;
        options_LTL2DRA.allow_union = true;
        options_LTL2DRA.recursive_union = true;
        options_LTL2DRA.only_union = false;
        options_LTL2DRA.optimizeAcceptance = true;
        options_LTL2DRA.bisim = true;
        options_LTL2DRA.recursive_bisim = true;
        if (bl) {
            options_LTL2DRA.automata = bl2 ? Options_LTL2DRA.AutomataType.RABIN_AND_STREETT : Options_LTL2DRA.AutomataType.RABIN;
        } else if (bl2) {
            options_LTL2DRA.automata = Options_LTL2DRA.AutomataType.STREETT;
        } else {
            throw new PrismException("Can not generate deterministic automata if neither Rabin nor Streett is allowed.");
        }
        options_LTL2DRA.detailed_states = false;
        options_LTL2DRA.verbose_scheduler = false;
        options_LTL2DRA.opt_safra.opt_accloop = true;
        options_LTL2DRA.opt_safra.opt_accsucc = true;
        options_LTL2DRA.opt_safra.opt_rename = true;
        options_LTL2DRA.opt_safra.opt_reorder = true;
        options_LTL2DRA.opt_safra.dba_check = false;
        options_LTL2DRA.opt_safra.stat = false;
        options_LTL2DRA.opt_safra.union_trueloop = true;
        LTL2DRA lTL2DRA = new LTL2DRA(options_LTL2DRA.opt_safra);
        Scheduler scheduler = new Scheduler(lTL2DRA, bl3, d);
        scheduler.flagStatNBA(bl4);
        dRA = scheduler.calculate(simpleLTL, aPSet, options_LTL2DRA);
        if (dRA == null) {
            throw new PrismException("Couldn't generate DRA!");
        }
        if (!dRA.isCompact()) {
            dRA.makeCompact();
        }
        return dRA;
    }
}

