/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2dstar.RabinAcceptance;
import jltl2dstar.RabinSignature;
import prism.PrismException;

public class AcceptanceForState {
    private RabinAcceptance _acceptance;
    private int _state_index;

    public AcceptanceForState(RabinAcceptance rabinAcceptance, int n) {
        this._acceptance = rabinAcceptance;
        this._state_index = n;
    }

    public void addTo_L(int n) {
        this._acceptance.getAcceptance_L(n).set(this._state_index);
        this._acceptance.getAcceptance_U(n).set(this._state_index, false);
    }

    public void addTo_U(int n) {
        this._acceptance.getAcceptance_U(n).set(this._state_index);
        this._acceptance.getAcceptance_L(n).set(this._state_index, false);
    }

    public boolean isIn_L(int n) {
        return this._acceptance.isStateInAcceptance_L(n, this._state_index);
    }

    public boolean isIn_U(int n) {
        return this._acceptance.isStateInAcceptance_U(n, this._state_index);
    }

    public void setSignature(RabinSignature rabinSignature) {
        for (int i = 0; i < rabinSignature.size(); ++i) {
            if (rabinSignature.getL().get(i)) {
                this.addTo_L(i);
            }
            if (!rabinSignature.getU().get(i)) continue;
            this.addTo_U(i);
        }
    }

    public int size() throws PrismException {
        return this._acceptance.size();
    }

    RabinSignature getSignature() throws PrismException {
        return new RabinSignature(this._acceptance.getAcceptance_L_forState(this._state_index), this._acceptance.getAcceptance_U_forState(this._state_index), this._acceptance.size());
    }
}

