/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import jdd.DebugJDD;

public class JDDNode {
    private long ptr;

    private native boolean DDN_IsConstant(long var1);

    private native int DDN_GetIndex(long var1);

    private native double DDN_GetValue(long var1);

    private native long DDN_GetThen(long var1);

    private native long DDN_GetElse(long var1);

    public JDDNode(long l, boolean bl) {
        this.ptr = l;
    }

    public JDDNode(long l) {
        this(l, true);
    }

    public JDDNode(JDDNode jDDNode) {
        this(jDDNode.ptr());
    }

    public long ptr() {
        return this.ptr;
    }

    public boolean isConstant() {
        return this.DDN_IsConstant(this.ptr);
    }

    public int getIndex() {
        return this.DDN_GetIndex(this.ptr);
    }

    public double getValue() {
        return this.DDN_GetValue(this.ptr);
    }

    public JDDNode getThen() {
        assert (!this.isConstant());
        return new JDDNode(this.DDN_GetThen(this.ptr), false);
    }

    public JDDNode getElse() {
        assert (!this.isConstant());
        return new JDDNode(this.DDN_GetElse(this.ptr), false);
    }

    public boolean equals(Object object) {
        return object instanceof JDDNode && ((JDDNode)object).ptr == this.ptr;
    }

    public int hashCode() {
        return (int)this.ptr;
    }

    public String toString() {
        String string = "" + this.ptr;
        if (this.ptr != 0L) {
            if (this.isConstant()) {
                string = string + " value=" + this.getValue();
            }
            string = string + " references=" + DebugJDD.getRefCount(this);
        }
        return string;
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

