/*
 * Decompiled with CFR 0.152.
 */
package hybrid;

import dv.DoubleVector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import prism.PrismException;
import prism.PrismLog;

public class PrismHybrid {
    private static PrismLog mainLog;
    private static PrismLog techLog;

    public static void initialise(PrismLog prismLog, PrismLog prismLog2) {
        PrismHybrid.setCUDDManager();
        PrismHybrid.setMainLog(prismLog);
        PrismHybrid.setTechLog(prismLog2);
    }

    public static void closeDown() {
        PrismHybrid.PH_FreeGlobalRefs();
    }

    private static native void PH_FreeGlobalRefs();

    private static native void PH_SetCUDDManager(long var0);

    public static void setCUDDManager() {
        PrismHybrid.PH_SetCUDDManager(JDD.GetCUDDManager());
    }

    private static native void PH_SetMainLog(PrismLog var0);

    public static void setMainLog(PrismLog prismLog) {
        mainLog = prismLog;
        PrismHybrid.PH_SetMainLog(prismLog);
    }

    private static native void PH_SetTechLog(PrismLog var0);

    public static void setTechLog(PrismLog prismLog) {
        techLog = prismLog;
        PrismHybrid.PH_SetTechLog(prismLog);
    }

    private static native String PH_GetErrorMessage();

    public static String getErrorMessage() {
        return PrismHybrid.PH_GetErrorMessage();
    }

    private static native double PH_GetLastUnif();

    public static double getLastUnif() {
        return PrismHybrid.PH_GetLastUnif();
    }

    private static native long PH_ProbBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14);

    public static DoubleVector ProbBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, int n) throws PrismException {
        long l = PrismHybrid.PH_ProbBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), n);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_ProbUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12);

    public static DoubleVector ProbUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        long l = PrismHybrid.PH_ProbUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr());
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_ProbCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, int var14);

    public static DoubleVector ProbCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismHybrid.PH_ProbCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_ProbInstReward(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static DoubleVector ProbInstReward(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismHybrid.PH_ProbInstReward(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_ProbReachReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, long var16, long var18);

    public static DoubleVector ProbReachReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6) throws PrismException {
        long l = PrismHybrid.PH_ProbReachReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr());
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_ProbTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static DoubleVector ProbTransient(JDDNode jDDNode, ODDNode oDDNode, DoubleVector doubleVector, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismHybrid.PH_ProbTransient(jDDNode.ptr(), oDDNode.ptr(), doubleVector.getPtr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_NondetBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13, long var15, int var17, boolean var18);

    public static DoubleVector NondetBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode2, JDDNode jDDNode3, int n, boolean bl) throws PrismException {
        long l = PrismHybrid.PH_NondetBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode2.ptr(), jDDNode3.ptr(), n, bl);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_NondetUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13, long var15, boolean var17);

    public static DoubleVector NondetUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) throws PrismException {
        long l = PrismHybrid.PH_NondetUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode2.ptr(), jDDNode3.ptr(), bl);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_NondetReachReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, int var16, long var17, long var19, long var21, boolean var23);

    public static DoubleVector NondetReachReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6, boolean bl) throws PrismException {
        long l = PrismHybrid.PH_NondetReachReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr(), bl);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_StochBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, double var14, long var16);

    public static DoubleVector StochBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, double d, DoubleVector doubleVector) throws PrismException {
        long l = doubleVector == null ? 0L : doubleVector.getPtr();
        long l2 = PrismHybrid.PH_StochBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), d, l);
        if (l2 == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l2, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_StochCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, double var14);

    public static DoubleVector StochCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        long l = PrismHybrid.PH_StochCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_StochSteadyState(long var0, long var2, long var4, long var6, int var8, long var9, int var11);

    public static DoubleVector StochSteadyState(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        long l = PrismHybrid.PH_StochSteadyState(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n());
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_StochTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, double var12);

    public static DoubleVector StochTransient(JDDNode jDDNode, ODDNode oDDNode, DoubleVector doubleVector, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        long l = PrismHybrid.PH_StochTransient(jDDNode.ptr(), oDDNode.ptr(), doubleVector.getPtr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_Power(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14);

    public static DoubleVector Power(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) throws PrismException {
        long l = PrismHybrid.PH_Power(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_JOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, boolean var15, double var16);

    public static DoubleVector JOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, boolean bl2, double d) throws PrismException {
        long l = PrismHybrid.PH_JOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, bl2, d);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_SOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, boolean var15, double var16, boolean var18);

    public static DoubleVector SOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, boolean bl2, double d, boolean bl3) throws PrismException {
        long l = PrismHybrid.PH_SOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, bl2, d, bl3);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    private static native long PH_PSOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, boolean var15, double var16, boolean var18);

    public static DoubleVector PSOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, boolean bl2, double d, boolean bl3) throws PrismException {
        long l = PrismHybrid.PH_PSOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, bl2, d, bl3);
        if (l == 0L) {
            throw new PrismException(PrismHybrid.getErrorMessage());
        }
        return new DoubleVector(l, (int)(oDDNode.getEOff() + oDDNode.getTOff()));
    }

    static {
        try {
            System.loadLibrary("prismhybrid");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

