/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.rewards.MDPRewards;
import java.util.ArrayList;
import java.util.List;

public class MDPRewardsSimple
implements MDPRewards {
    protected int numStates;
    protected List<Double> stateRewards;
    protected List<List<Double>> transRewards;

    public MDPRewardsSimple(int n) {
        this.numStates = n;
        this.stateRewards = null;
        this.transRewards = null;
    }

    public MDPRewardsSimple(MDPRewardsSimple mDPRewardsSimple) {
        int n;
        this.numStates = mDPRewardsSimple.numStates;
        if (mDPRewardsSimple.stateRewards == null) {
            this.stateRewards = null;
        } else {
            this.stateRewards = new ArrayList<Double>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.stateRewards.add(mDPRewardsSimple.stateRewards.get(n));
            }
        }
        if (mDPRewardsSimple.transRewards == null) {
            this.transRewards = null;
        } else {
            this.transRewards = new ArrayList<List<Double>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                List<Double> list = mDPRewardsSimple.transRewards.get(n);
                if (list == null) {
                    this.transRewards.add(null);
                    continue;
                }
                int n2 = list.size();
                ArrayList<Double> arrayList = new ArrayList<Double>(n2);
                this.transRewards.add(arrayList);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
    }

    public void setStateReward(int n, double d) {
        if (this.stateRewards == null) {
            this.stateRewards = new ArrayList<Double>(this.numStates);
            for (int i = 0; i < this.numStates; ++i) {
                this.stateRewards.add(0.0);
            }
        }
        this.stateRewards.set(n, d);
    }

    public void addToStateReward(int n, double d) {
        this.setStateReward(n, this.getStateReward(n) + d);
    }

    public void setTransitionReward(int n, int n2, double d) {
        List<Object> list;
        int n3;
        if (this.transRewards == null) {
            this.transRewards = new ArrayList<List<Double>>(this.numStates);
            for (n3 = 0; n3 < this.numStates; ++n3) {
                this.transRewards.add(null);
            }
        }
        if (this.transRewards.get(n) == null) {
            list = new ArrayList();
            this.transRewards.set(n, list);
        } else {
            list = this.transRewards.get(n);
        }
        n3 = n2 - list.size() + 1;
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                list.add(0.0);
            }
        }
        list.set(n2, d);
    }

    public void addToTransitionReward(int n, int n2, double d) {
        this.setTransitionReward(n, n2, this.getTransitionReward(n, n2) + d);
    }

    public void clearRewards(int n) {
        this.setStateReward(n, 0.0);
        if (this.transRewards != null && this.transRewards.size() > n) {
            this.transRewards.set(n, null);
        }
    }

    @Override
    public double getStateReward(int n) {
        if (this.stateRewards == null) {
            return 0.0;
        }
        return this.stateRewards.get(n);
    }

    @Override
    public double getTransitionReward(int n, int n2) {
        List<Double> list;
        if (this.transRewards == null || (list = this.transRewards.get(n)) == null) {
            return 0.0;
        }
        if (list.size() <= n2) {
            return 0.0;
        }
        return list.get(n2);
    }

    public String toString() {
        return "st: " + this.stateRewards + "; tr:" + this.transRewards;
    }
}

