/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.ModelTransformation;
import explicit.StateValues;
import java.util.BitSet;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;
import prism.PrismNotSupportedException;

public abstract class Product<M extends Model>
implements ModelTransformation<M, M> {
    protected M originalModel = null;
    protected M productModel = null;

    public abstract int getModelState(int var1);

    public abstract int getAutomatonState(int var1);

    public Product(M m) {
        this.originalModel = m;
    }

    public Product(M m, M m2) {
        this.originalModel = m2;
        this.productModel = m;
    }

    public M getProductModel() {
        return this.productModel;
    }

    @Override
    public M getTransformedModel() {
        return this.getProductModel();
    }

    @Override
    public M getOriginalModel() {
        return this.originalModel;
    }

    public BitSet liftFromAutomaton(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.productModel.getNumStates(); ++i) {
            if (!bitSet.get(this.getAutomatonState(i))) continue;
            bitSet2.set(i, true);
        }
        return bitSet2;
    }

    public BitSet liftFromModel(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.productModel.getNumStates(); ++i) {
            if (!bitSet.get(this.getModelState(i))) continue;
            bitSet2.set(i, true);
        }
        return bitSet2;
    }

    @Override
    public StateValues projectToOriginalModel(StateValues stateValues) throws PrismException {
        StateValues stateValues2 = new StateValues(stateValues.type, this.getOriginalModel().getNumStates());
        for (Integer n : this.productModel.getInitialStates()) {
            int n2 = this.getModelState(n);
            if (stateValues.type instanceof TypeBool) {
                stateValues2.setBooleanValue(n2, (Boolean)stateValues.getValue(n));
                continue;
            }
            if (stateValues.type instanceof TypeInt) {
                stateValues2.setIntValue(n2, (Integer)stateValues.getValue(n));
                continue;
            }
            if (stateValues.type instanceof TypeDouble) {
                stateValues2.setDoubleValue(n2, (Double)stateValues.getValue(n));
                continue;
            }
            throw new PrismNotSupportedException("Handling for type " + stateValues.type + " not implemented.");
        }
        return stateValues2;
    }
}

