/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.PredecessorRelation;
import explicit.StateValues;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public abstract class ModelExplicit
implements Model {
    protected int numStates;
    protected List<Integer> initialStates;
    protected TreeSet<Integer> deadlocks;
    protected List<State> statesList;
    protected Values constantValues;
    protected Map<String, BitSet> labels = new TreeMap<String, BitSet>();
    protected PredecessorRelation predecessorRelation = null;

    public void copyFrom(ModelExplicit modelExplicit) {
        this.numStates = modelExplicit.numStates;
        for (int n : modelExplicit.initialStates) {
            this.addInitialState(n);
        }
        for (int n : modelExplicit.deadlocks) {
            this.addDeadlockState(n);
        }
        this.statesList = modelExplicit.statesList;
        this.constantValues = modelExplicit.constantValues;
        this.labels = modelExplicit.labels;
    }

    public void copyFrom(ModelExplicit modelExplicit, int[] nArray) {
        this.numStates = modelExplicit.numStates;
        for (int n : modelExplicit.initialStates) {
            this.addInitialState(nArray[n]);
        }
        for (int n : modelExplicit.deadlocks) {
            this.addDeadlockState(nArray[n]);
        }
        this.statesList = null;
        this.constantValues = modelExplicit.constantValues;
        this.labels.clear();
    }

    public void initialise(int n) {
        this.numStates = n;
        this.initialStates = new ArrayList<Integer>();
        this.deadlocks = new TreeSet();
        this.statesList = null;
        this.constantValues = null;
        this.labels = new TreeMap<String, BitSet>();
    }

    public void addInitialState(int n) {
        this.initialStates.add(n);
    }

    public void clearInitialStates() {
        this.initialStates.clear();
    }

    public void addDeadlockState(int n) {
        this.deadlocks.add(n);
    }

    public abstract void buildFromPrismExplicit(String var1) throws PrismException;

    public void setStatesList(List<State> list) {
        this.statesList = list;
    }

    public void setConstantValues(Values values) {
        this.constantValues = values;
    }

    public void addLabel(String string, BitSet bitSet) {
        this.labels.put(string, bitSet);
    }

    @Override
    public abstract ModelType getModelType();

    @Override
    public int getNumStates() {
        return this.numStates;
    }

    @Override
    public int getNumInitialStates() {
        return this.initialStates.size();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.initialStates;
    }

    @Override
    public int getFirstInitialState() {
        return this.initialStates.isEmpty() ? -1 : this.initialStates.get(0);
    }

    @Override
    public boolean isInitialState(int n) {
        return this.initialStates.contains(n);
    }

    @Override
    public int getNumDeadlockStates() {
        return this.deadlocks.size();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        return this.deadlocks;
    }

    @Override
    public StateValues getDeadlockStatesList() {
        BitSet bitSet = new BitSet();
        for (int n : this.deadlocks) {
            bitSet.set(n);
        }
        return StateValues.createFromBitSet(bitSet, this);
    }

    @Override
    public int getFirstDeadlockState() {
        return this.deadlocks.isEmpty() ? -1 : this.deadlocks.first();
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.deadlocks.contains(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.statesList;
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.labels.get(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.labels.keySet();
    }

    @Override
    public abstract int getNumTransitions();

    @Override
    public abstract boolean isSuccessor(int var1, int var2);

    @Override
    public void checkForDeadlocks() throws PrismException {
        this.checkForDeadlocks(null);
    }

    @Override
    public abstract void checkForDeadlocks(BitSet var1) throws PrismException;

    @Override
    public void exportToPrismExplicit(String string) throws PrismException {
        this.exportToPrismExplicitTra(string + ".tra");
    }

    @Override
    public void exportToPrismExplicitTra(String string) throws PrismException {
        this.exportToPrismExplicitTra(PrismFileLog.create(string));
    }

    @Override
    public void exportToPrismExplicitTra(File file) throws PrismException {
        this.exportToPrismExplicitTra(PrismFileLog.create(file.getPath()));
    }

    @Override
    public abstract void exportToPrismExplicitTra(PrismLog var1);

    @Override
    public void exportToDotFile(String string) throws PrismException {
        this.exportToDotFile(PrismFileLog.create(string), null);
    }

    @Override
    public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        this.exportToDotFile(PrismFileLog.create(string), bitSet);
    }

    @Override
    public void exportToDotFile(PrismLog prismLog) {
        this.exportToDotFile(prismLog, null, false);
    }

    @Override
    public void exportToDotFile(PrismLog prismLog, BitSet bitSet) {
        this.exportToDotFile(prismLog, bitSet, false);
    }

    @Override
    public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl) {
        List<State> list;
        int n;
        prismLog.print("digraph " + (Object)((Object)this.getModelType()) + " {\nsize=\"8,5\"\nnode [shape=box];\n");
        for (n = 0; n < this.numStates; ++n) {
            if (bitSet != null && bitSet.get(n)) {
                prismLog.print(n + " [style=filled  fillcolor=\"#cccccc\"]\n");
            }
            this.exportTransitionsToDotFile(n, prismLog);
        }
        if (bl && (list = this.getStatesList()) != null) {
            for (n = 0; n < this.numStates; ++n) {
                prismLog.print(n + " [label=\"" + n + "\\n" + list.get(n) + "\"]\n");
            }
        }
        prismLog.print("}\n");
    }

    protected abstract void exportTransitionsToDotFile(int var1, PrismLog var2);

    @Override
    public abstract void exportToPrismLanguage(String var1) throws PrismException;

    @Override
    public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        int n2;
        if (this.statesList == null) {
            return;
        }
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n3 = varList.getNumVars();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.print(varList.getName(n2));
            if (n2 >= n3 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        n2 = this.statesList.size();
        for (int i = 0; i < n2; ++i) {
            if (n != 2) {
                prismLog.println(i + ":" + this.statesList.get(i).toString());
                continue;
            }
            prismLog.println(this.statesList.get(i).toStringNoParentheses());
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }

    @Override
    public String infoString() {
        String string = "";
        string = string + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        string = string + ", " + this.getNumTransitions() + " transitions";
        return string;
    }

    @Override
    public String infoStringTable() {
        String string = "";
        string = string + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        string = string + "Transitions: " + this.getNumTransitions() + "\n";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ModelExplicit)) {
            return false;
        }
        ModelExplicit modelExplicit = (ModelExplicit)object;
        if (this.numStates != modelExplicit.numStates) {
            return false;
        }
        return this.initialStates.equals(modelExplicit.initialStates);
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }
}

