/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.MDPExplicit;
import explicit.MDPSparse;
import explicit.NondetModelSimple;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;
import prism.PrismUtils;

public class MDPSimple
extends MDPExplicit
implements NondetModelSimple {
    protected List<List<Distribution>> trans;
    protected List<List<Object>> actions;
    protected boolean allowDupes = false;
    protected int numDistrs;
    protected int numTransitions;
    protected int maxNumDistrs;
    protected boolean maxNumDistrsOk;

    public MDPSimple() {
        this.initialise(0);
    }

    public MDPSimple(int n) {
        this.initialise(n);
    }

    public MDPSimple(MDPSimple mDPSimple) {
        this(mDPSimple.numStates);
        int n;
        this.copyFrom(mDPSimple);
        for (n = 0; n < this.numStates; ++n) {
            List<Distribution> list = this.trans.get(n);
            for (Distribution distribution : mDPSimple.trans.get(n)) {
                list.add(new Distribution(distribution));
            }
        }
        if (mDPSimple.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.actions.add(null);
            }
            for (n = 0; n < this.numStates; ++n) {
                if (mDPSimple.actions.get(n) == null) continue;
                int n2 = mDPSimple.trans.get(n).size();
                ArrayList arrayList = new ArrayList(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(mDPSimple.actions.get(n).get(i));
                }
                this.actions.set(n, arrayList);
            }
        }
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(DTMCSimple dTMCSimple) {
        this(dTMCSimple.getNumStates());
        this.copyFrom(dTMCSimple);
        for (int i = 0; i < this.numStates; ++i) {
            this.addChoice(i, new Distribution(dTMCSimple.getTransitions(i)));
        }
    }

    public MDPSimple(MDPSimple mDPSimple, int[] nArray) {
        this(mDPSimple.numStates);
        int n;
        this.copyFrom(mDPSimple, nArray);
        for (n = 0; n < this.numStates; ++n) {
            List<Distribution> list = this.trans.get(nArray[n]);
            for (Distribution distribution : mDPSimple.trans.get(n)) {
                list.add(new Distribution(distribution, nArray));
            }
        }
        if (mDPSimple.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.actions.add(null);
            }
            for (n = 0; n < this.numStates; ++n) {
                if (mDPSimple.actions.get(n) == null) continue;
                int n2 = mDPSimple.trans.get(n).size();
                ArrayList arrayList = new ArrayList(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(mDPSimple.actions.get(n).get(i));
                }
                this.actions.set(nArray[n], arrayList);
            }
        }
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(MDPSparse mDPSparse) {
        this(mDPSparse.numStates);
        Iterable<Map.Entry<Integer, Double>> iterable;
        int n;
        int n2;
        this.copyFrom(mDPSparse);
        for (n2 = 0; n2 < this.numStates; ++n2) {
            for (n = 0; n < mDPSparse.getNumChoices(n2); ++n) {
                iterable = new Distribution();
                Iterator<Map.Entry<Integer, Double>> iterator = mDPSparse.getTransitionsIterator(n2, n);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    ((Distribution)iterable).add(entry.getKey(), entry.getValue());
                }
                this.addChoice(n2, (Distribution)iterable);
            }
        }
        if (mDPSparse.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n2 = 0; n2 < this.numStates; ++n2) {
                this.actions.add(null);
            }
            for (n2 = 0; n2 < this.numStates; ++n2) {
                n = mDPSparse.getNumChoices(n2);
                iterable = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    iterable.add(mDPSparse.getAction(n2, i));
                }
                this.actions.set(n2, (List<Object>)iterable);
            }
        }
        this.allowDupes = false;
        this.numDistrs = mDPSparse.numDistrs;
        this.numTransitions = mDPSparse.numTransitions;
        this.maxNumDistrs = mDPSparse.maxNumDistrs;
        this.maxNumDistrsOk = true;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.maxNumDistrs = 0;
        this.numTransitions = 0;
        this.numDistrs = 0;
        this.maxNumDistrsOk = true;
        this.trans = new ArrayList<List<Distribution>>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
        this.actions = null;
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        List<Distribution> list = this.trans.get(n);
        this.numDistrs -= list.size();
        for (Distribution distribution : list) {
            this.numTransitions -= distribution.size();
        }
        this.maxNumDistrsOk = false;
        this.trans.get(n).clear();
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).clear();
        }
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
            if (this.actions != null) {
                this.actions.add(null);
            }
            ++this.numStates;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                bufferedReader.close();
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            this.initialise(n2);
            int n3 = -1;
            int n4 = -1;
            Distribution distribution = null;
            string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(" ");
                    int n5 = Integer.parseInt(stringArray[0]);
                    int n6 = Integer.parseInt(stringArray[1]);
                    int n7 = Integer.parseInt(stringArray[2]);
                    double d = Double.parseDouble(stringArray[3]);
                    if (n5 != n3 || n6 != n4) {
                        if (distribution != null) {
                            this.addChoice(n3, distribution);
                        }
                        distribution = new Distribution();
                    }
                    distribution.add(n7, d);
                    n3 = n5;
                    n4 = n6;
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
            this.addChoice(n3, distribution);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + (Object)((Object)this.getModelType()));
        }
        this.initialStates.add(0);
    }

    public int addChoice(int n, Distribution distribution) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfChoice(n, distribution)) != -1) {
            return n2;
        }
        List<Distribution> list = this.trans.get(n);
        list.add(distribution);
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).add(null);
        }
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public int addActionLabelledChoice(int n, Distribution distribution, Object object) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfActionLabelledChoice(n, distribution, object)) != -1) {
            return n2;
        }
        List<Distribution> list = this.trans.get(n);
        list.add(distribution);
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).add(null);
        }
        this.setAction(n, list.size() - 1, object);
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public void setAction(int n, int n2, Object object) {
        int n3;
        if (object == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n3 = 0; n3 < this.numStates; ++n3) {
                this.actions.add(null);
            }
        }
        if (this.actions.get(n) == null) {
            n3 = this.trans.get(n).size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(null);
            }
            this.actions.set(n, arrayList);
        }
        this.actions.get(n).set(n2, object);
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Distribution distribution : this.trans.get(n)) {
            hashSet.addAll(distribution.getSupport());
        }
        return hashSet.iterator();
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        for (Distribution distribution : this.trans.get(n)) {
            if (!distribution.contains(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        for (Distribution distribution : this.trans.get(n)) {
            if (distribution.isSubsetOf(bitSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        for (Distribution distribution : this.trans.get(n)) {
            if (!distribution.containsOneOf(bitSet)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            Distribution distribution = new Distribution();
            distribution.add(i, 1.0);
            this.addChoice(i, distribution);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("MDP has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumChoices(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public int getMaxNumChoices() {
        if (!this.maxNumDistrsOk) {
            this.maxNumDistrs = 0;
            for (int i = 0; i < this.numStates; ++i) {
                this.maxNumDistrs = Math.max(this.maxNumDistrs, this.getNumChoices(i));
            }
        }
        return this.maxNumDistrs;
    }

    @Override
    public int getNumChoices() {
        return this.numDistrs;
    }

    @Override
    public Object getAction(int n, int n2) {
        List<Object> list;
        if (n2 < 0 || this.actions == null || (list = this.actions.get(n)) == null) {
            return null;
        }
        return list.get(n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).containsOneOf(bitSet);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).getSupport().iterator();
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.trans.get(n).get(n2).size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).iterator();
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, BitSet bitSet3) {
        for (int n : new IterableStateSet(bitSet, this.numStates)) {
            boolean bl2 = bl;
            for (Distribution distribution : this.trans.get(n)) {
                boolean bl3 = distribution.containsOneOf(bitSet2);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet3.set(n, bl2);
        }
    }

    @Override
    public void prob1Astep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        for (int n : new IterableStateSet(bitSet, this.numStates)) {
            boolean bl = true;
            for (Distribution distribution : this.trans.get(n)) {
                if (distribution.isSubsetOf(bitSet2) && distribution.containsOneOf(bitSet3)) continue;
                bl = false;
                break;
            }
            bitSet4.set(n, bl);
        }
    }

    @Override
    public void prob1Estep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, int[] nArray) {
        int n = -1;
        for (int n2 : new IterableStateSet(bitSet, this.numStates)) {
            int n3 = 0;
            boolean bl = false;
            for (Distribution distribution : this.trans.get(n2)) {
                if (distribution.isSubsetOf(bitSet2) && distribution.containsOneOf(bitSet3)) {
                    bl = true;
                    if (nArray == null) break;
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (nArray != null & bl & !bitSet4.get(n2)) {
                nArray[n2] = n;
            }
            bitSet4.set(n2, bl);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, BitSet bitSet4) {
        for (int n : new IterableStateSet(bitSet, this.numStates)) {
            boolean bl2 = bl;
            for (Distribution distribution : this.trans.get(n)) {
                boolean bl3;
                boolean bl4 = bl3 = distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet4.set(n, bl2);
        }
    }

    @Override
    public boolean prob1stepSingle(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        Distribution distribution = this.trans.get(n).get(n2);
        return distribution.containsOneOf(bitSet2) && distribution.isSubsetOf(bitSet);
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        int n3 = 0;
        double d = 0.0;
        boolean bl2 = true;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            double d2 = 0.0;
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n4 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n4];
            }
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
            ++n3;
        }
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = -1;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            ++n2;
            double d2 = 0.0;
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n3 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n3];
            }
            if (!PrismUtils.doublesAreClose(d, d2, 1.0E-12, false)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public double mvMultSingle(int n, int n2, double[] dArray) {
        Distribution distribution = this.trans.get(n).get(n2);
        double d = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n3 = entry.getKey();
            double d2 = entry.getValue();
            d += d2 * dArray[n3];
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        int n3 = 0;
        double d = 0.0;
        boolean bl2 = true;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            double d2 = 1.0;
            double d3 = 0.0;
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n4 = entry.getKey();
                double d4 = entry.getValue();
                if (n4 != n) {
                    d3 += d4 * dArray[n4];
                    continue;
                }
                d2 -= d4;
            }
            if (d2 > 0.0) {
                d3 /= d2;
            }
            if (bl2 || bl && d3 < d || !bl && d3 > d) {
                d = d3;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
            ++n3;
        }
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, int n2, double[] dArray) {
        Distribution distribution = this.trans.get(n).get(n2);
        double d = 1.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n3 = entry.getKey();
            double d3 = entry.getValue();
            if (n3 != n) {
                d2 += d3 * dArray[n3];
                continue;
            }
            d -= d3;
        }
        if (d > 0.0) {
            d2 /= d;
        }
        return d2;
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = -1;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            double d2 = mDPRewards.getTransitionReward(n, ++n3);
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n4 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n4];
            }
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
        }
        d += mDPRewards.getStateReward(n);
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public double mvMultRewSingle(int n, int n2, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.trans.get(n).get(n2);
        double d = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n3 = entry.getKey();
            double d2 = entry.getValue();
            d += d2 * dArray[n3];
        }
        return d += mCRewards.getStateReward(n);
    }

    @Override
    public double mvMultRewJacMinMaxSingle(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = -1;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            double d2 = 1.0;
            double d3 = mDPRewards.getTransitionReward(n, ++n3);
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n4 = entry.getKey();
                double d4 = entry.getValue();
                if (n4 != n) {
                    d3 += d4 * dArray[n4];
                    continue;
                }
                d2 -= d4;
            }
            if (d2 > 0.0) {
                d3 /= d2;
            }
            if (bl2 || bl && d3 < d || !bl && d3 > d) {
                d = d3;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
        }
        d += mDPRewards.getStateReward(n);
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = -1;
        List<Distribution> list = this.trans.get(n);
        for (Distribution distribution : list) {
            double d2 = mDPRewards.getTransitionReward(n, ++n2);
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n3 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n3];
            }
            if (!PrismUtils.doublesAreClose(d, d2 += mDPRewards.getStateReward(n), 1.0E-12, false)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public void mvMultRight(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        for (int n : nArray) {
            Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n, nArray2[n]);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                int n2 = entry.getKey();
                double d = entry.getValue();
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d * dArray[n];
            }
        }
    }

    public List<Distribution> getChoices(int n) {
        return this.trans.get(n);
    }

    public Distribution getChoice(int n, int n2) {
        return this.trans.get(n).get(n2);
    }

    public int indexOfChoice(int n, Distribution distribution) {
        return this.trans.get(n).indexOf(distribution);
    }

    public int indexOfActionLabelledChoice(int n, Distribution distribution, Object object) {
        List<Distribution> list = this.trans.get(n);
        int n2 = list.size();
        if (distribution == null) {
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) != null) continue;
                Object object2 = this.getAction(n, i);
                if (!(object == null ? object2 == null : object.equals(object2))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!distribution.equals(list.get(i))) continue;
                Object object3 = this.getAction(n, i);
                if (!(object == null ? object3 == null : object.equals(object3))) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        String string = "";
        string = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + i + ": ";
            string = string + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object;
                if (j > 0) {
                    string = string + ",";
                }
                if ((object = this.getAction(i, j)) != null) {
                    string = string + object + ":";
                }
                string = string + this.trans.get(i).get(j);
            }
            string = string + "]";
        }
        string = string + " ]\n";
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof MDPSimple)) {
            return false;
        }
        MDPSimple mDPSimple = (MDPSimple)object;
        if (this.numStates != mDPSimple.numStates) {
            return false;
        }
        if (!this.initialStates.equals(mDPSimple.initialStates)) {
            return false;
        }
        return this.trans.equals(mDPSimple.trans);
    }
}

