/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.DTMCFromMDPAndMDStrategy;
import explicit.MDP;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.rewards.MDPRewards;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import strat.MDStrategy;

public abstract class MDPExplicit
extends ModelExplicit
implements MDP {
    @Override
    public ModelType getModelType() {
        return ModelType.MDP;
    }

    @Override
    public String infoString() {
        String string = "";
        string = string + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        string = string + ", " + this.getNumTransitions() + " transitions";
        string = string + ", " + this.getNumChoices() + " choices";
        string = string + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.numStates);
        return string;
    }

    @Override
    public String infoStringTable() {
        String string = "";
        string = string + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        string = string + "Transitions: " + this.getNumTransitions() + "\n";
        string = string + "Choices:     " + this.getNumChoices() + "\n";
        string = string + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.numStates) + "\n";
        return string;
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        prismLog.print(this.numStates + " " + this.getNumChoices() + " " + this.getNumTransitions() + "\n");
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.numStates; ++i) {
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    prismLog.print(i + " " + j + " " + entry.getKey() + " " + PrismUtils.formatDouble((Double)entry.getValue()));
                    Object object = this.getAction(i, j);
                    prismLog.print(object == null ? "\n" : " " + object + "\n");
                }
                treeMap.clear();
            }
        }
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog) {
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            Object object = this.getAction(n, i);
            String string = "n" + n + "_" + i;
            prismLog.print(n + " -> " + string + " [ arrowhead=none,label=\"" + i);
            if (object != null) {
                prismLog.print(":" + object);
            }
            prismLog.print("\" ];\n");
            prismLog.print(string + " [ shape=point,width=0.1,height=0.1,label=\"\" ];\n");
            Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n, i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                prismLog.print(string + " -> " + entry.getKey() + " [ label=\"" + entry.getValue() + "\" ];\n");
            }
        }
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        prismLog.print("digraph " + (Object)((Object)this.getModelType()) + " {\nsize=\"8,5\"\nnode [shape=box];\n");
        for (int i = 0; i < this.numStates; ++i) {
            if (bitSet != null && bitSet.get(i)) {
                prismLog.print(i + " [style=filled  fillcolor=\"#cccccc\"]\n");
            }
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                String string = nArray[i] == j ? ",color=\"#ff0000\",fontcolor=\"#ff0000\"" : "";
                Object object = this.getAction(i, j);
                String string2 = "n" + i + "_" + j;
                prismLog.print(i + " -> " + string2 + " [ arrowhead=none,label=\"" + j);
                if (object != null) {
                    prismLog.print(":" + object);
                }
                prismLog.print("\"" + string + " ];\n");
                prismLog.print(string2 + " [ shape=point,height=0.1,label=\"\"" + string + " ];\n");
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    prismLog.print(string2 + " -> " + entry.getKey() + " [ label=\"" + entry.getValue() + "\"" + string + " ];\n");
                }
            }
        }
        prismLog.print("}\n");
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.numStates - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            for (int i = 0; i < this.numStates; ++i) {
                int n = this.getNumChoices(i);
                for (int j = 0; j < n; ++j) {
                    Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Double> entry = iterator.next();
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    Object object = this.getAction(i, j);
                    fileWriter.write(object != null ? "[" + object + "]" : "[]");
                    fileWriter.write("x=" + i + "->");
                    boolean bl = true;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        if (bl) {
                            bl = false;
                        } else {
                            fileWriter.write("+");
                        }
                        fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                    }
                    fileWriter.write(";\n");
                    treeMap.clear();
                }
            }
            fileWriter.write("endmodule\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + (Object)((Object)this.getModelType()) + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < this.numStates; ++i) {
            int n = this.getNumChoices(i);
            if (n <= 1) continue;
            hashSet.clear();
            for (int j = 0; j < n; ++j) {
                if (hashSet.add(this.getAction(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void mvMultMinMax(double[] dArray, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        for (int n : new IterableStateSet(bitSet, this.numStates, bl2)) {
            dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl, nArray);
        }
    }

    @Override
    public double mvMultGSMinMax(double[] dArray, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        double d = 0.0;
        for (int n : new IterableStateSet(bitSet, this.numStates, bl2)) {
            double d2 = this.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            double d3 = bl3 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        for (int n : new IterableStateSet(bitSet, this.numStates, bl2)) {
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
        }
    }

    @Override
    public double mvMultRewGSMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        double d = 0.0;
        for (int n : new IterableStateSet(bitSet, this.numStates, bl2)) {
            double d2 = this.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            double d3 = bl3 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    @Override
    public Model constructInducedModel(MDStrategy mDStrategy) {
        return new DTMCFromMDPAndMDStrategy(this, mDStrategy);
    }
}

