/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import common.IterableStateSet;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.ECComputer;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.NondetModel;
import explicit.ProbModelChecker;
import explicit.Product;
import explicit.SCCComputer;
import explicit.StateValues;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import parser.State;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;

public class LTLModelChecker
extends PrismComponent {
    public LTLModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public static boolean isSupportedLTLFormula(ModelType modelType, Expression expression) throws PrismLangException {
        if (!expression.isPathFormula(true)) {
            return false;
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (modelType.continuousTime()) {
                return false;
            }
            if (!expression.isSimplePathFormula()) {
                return false;
            }
        }
        return true;
    }

    public Expression checkMaximalStateFormulas(ProbModelChecker probModelChecker, Model model, Expression expression, Vector<BitSet> vector) throws PrismException {
        if (expression.getType() instanceof TypeBool) {
            StateValues stateValues = probModelChecker.checkExpression(model, expression, null);
            BitSet bitSet = stateValues.getBitSet();
            if (bitSet.isEmpty()) {
                return Expression.False();
            }
            if (bitSet.cardinality() == model.getNumStates()) {
                return Expression.True();
            }
            int n = vector.indexOf(bitSet);
            if (n != -1) {
                stateValues.clear();
                return new ExpressionLabel("L" + n);
            }
            BitSet bitSet2 = new BitSet(model.getNumStates());
            bitSet2.set(0, model.getNumStates());
            bitSet2.andNot(bitSet);
            n = vector.indexOf(bitSet2);
            if (n != -1) {
                stateValues.clear();
                return Expression.Not(new ExpressionLabel("L" + n));
            }
            vector.add(bitSet);
            return new ExpressionLabel("L" + (vector.size() - 1));
        }
        if (expression.getType() instanceof TypePathBool) {
            if (expression instanceof ExpressionBinaryOp) {
                ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
                expressionBinaryOp.setOperand1(this.checkMaximalStateFormulas(probModelChecker, model, expressionBinaryOp.getOperand1(), vector));
                expressionBinaryOp.setOperand2(this.checkMaximalStateFormulas(probModelChecker, model, expressionBinaryOp.getOperand2(), vector));
            } else if (expression instanceof ExpressionUnaryOp) {
                ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
                expressionUnaryOp.setOperand(this.checkMaximalStateFormulas(probModelChecker, model, expressionUnaryOp.getOperand(), vector));
            } else if (expression instanceof ExpressionTemporal) {
                ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
                if (expressionTemporal.getOperand1() != null) {
                    expressionTemporal.setOperand1(this.checkMaximalStateFormulas(probModelChecker, model, expressionTemporal.getOperand1(), vector));
                }
                if (expressionTemporal.getOperand2() != null) {
                    expressionTemporal.setOperand2(this.checkMaximalStateFormulas(probModelChecker, model, expressionTemporal.getOperand2(), vector));
                }
            }
        }
        return expression;
    }

    public DA<BitSet, ? extends AcceptanceOmega> constructDAForLTLFormula(ProbModelChecker probModelChecker, Model model, Expression expression, Vector<BitSet> vector, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (model.getModelType().continuousTime()) {
                throw new PrismException("Automaton construction for time-bounded operators not supported for " + (Object)((Object)model.getModelType()) + ".");
            }
            if (expression.isSimplePathFormula()) {
                expression = Expression.convertSimplePathFormulaToCanonicalForm(expression);
            } else {
                throw new PrismNotSupportedException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        Expression expression2 = this.checkMaximalStateFormulas(probModelChecker, model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + expression2 + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this);
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, probModelChecker.getConstantValues(), acceptanceTypeArray);
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        dA.checkForCanonicalAPs(vector.size());
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for " + dA.getAutomataType() + " translation: " + (double)l / 1000.0 + " seconds.");
        if (this.settings.getExportPropAut()) {
            this.mainLog.println("Exporting " + dA.getAutomataType() + " to file \"" + this.settings.getExportPropAutFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.settings.getExportPropAutFilename());
            dA.print(prismFileLog, this.settings.getExportPropAutType());
            ((PrismLog)prismFileLog).close();
        }
        return dA;
    }

    public LTLProduct<DTMC> constructProductMC(ProbModelChecker probModelChecker, DTMC dTMC, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(probModelChecker, dTMC, expression, vector, acceptanceTypeArray);
        this.mainLog.println("\nConstructing MC-" + dA.getAutomataType() + " product...");
        LTLProduct<DTMC> lTLProduct = this.constructProductMC(dA, dTMC, vector, bitSet);
        this.mainLog.print("\n" + ((DTMC)lTLProduct.getProductModel()).infoStringTable());
        return lTLProduct;
    }

    public LTLProduct<DTMC> constructProductMC(DA<BitSet, ? extends AcceptanceOmega> dA, DTMC dTMC, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        DTMCSimple dTMCSimple = new DTMCSimple();
        int n = dA.size();
        int n2 = dA.getAPList().size();
        int n3 = dTMC.getNumStates();
        int n4 = n3 * n;
        BitSet bitSet2 = new BitSet(n2);
        ArrayList<State> arrayList = null;
        ArrayList<State> arrayList2 = null;
        LinkedList<Point> linkedList = new LinkedList<Point>();
        int[] nArray = new int[n4];
        Arrays.fill(nArray, -1);
        if (dTMC.getStatesList() != null) {
            arrayList = new ArrayList<State>();
            arrayList2 = new ArrayList<State>(dA.size());
            for (int i = 0; i < dA.size(); ++i) {
                arrayList2.add(new State(1).setValue(0, i));
            }
        }
        Object object = new IterableStateSet(bitSet, dTMC.getNumStates()).iterator();
        while (object.hasNext()) {
            int n5;
            int n6 = object.next();
            for (n5 = 0; n5 < n2; ++n5) {
                bitSet2.set(n5, vector.get(Integer.parseInt(dA.getAPList().get(n5).substring(1))).get(n6));
            }
            n5 = dA.getEdgeDestByLabel(dA.getStartState(), bitSet2);
            if (n5 < 0) {
                throw new PrismException("The deterministic automaton is not complete (state " + dA.getStartState() + ")");
            }
            linkedList.add(new Point(n6, n5));
            dTMCSimple.addState();
            dTMCSimple.addInitialState(dTMCSimple.getNumStates() - 1);
            nArray[n6 * n + n5] = dTMCSimple.getNumStates() - 1;
            if (arrayList == null) continue;
            arrayList.add(new State((State)arrayList2.get(n5), dTMC.getStatesList().get(n6)));
        }
        object = new BitSet(n4);
        while (!linkedList.isEmpty()) {
            Point point = (Point)linkedList.pop();
            int n7 = point.x;
            int n8 = point.y;
            ((BitSet)object).set(n7 * n + n8);
            Iterator<Map.Entry<Integer, Double>> iterator = dTMC.getTransitionsIterator(n7);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                int n9 = entry.getKey();
                double d = entry.getValue();
                for (int i = 0; i < n2; ++i) {
                    bitSet2.set(i, vector.get(Integer.parseInt(dA.getAPList().get(i).substring(1))).get(n9));
                }
                int n10 = dA.getEdgeDestByLabel(n8, bitSet2);
                if (n10 < 0) {
                    throw new PrismException("The deterministic automaton is not complete (state " + n8 + ")");
                }
                if (!((BitSet)object).get(n9 * n + n10) && nArray[n9 * n + n10] == -1) {
                    linkedList.add(new Point(n9, n10));
                    dTMCSimple.addState();
                    nArray[n9 * n + n10] = dTMCSimple.getNumStates() - 1;
                    if (arrayList != null) {
                        arrayList.add(new State((State)arrayList2.get(n10), dTMC.getStatesList().get(n9)));
                    }
                }
                dTMCSimple.setProbability(nArray[n7 * n + n8], nArray[n9 * n + n10], d);
            }
        }
        int[] nArray2 = new int[dTMCSimple.getNumStates()];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[nArray[i]] = i;
        }
        dTMCSimple.findDeadlocks(false);
        if (arrayList != null) {
            dTMCSimple.setStatesList(arrayList);
        }
        LTLProduct lTLProduct = new LTLProduct(this, (Model)dTMCSimple, (Model)dTMC, null, n, nArray2);
        lTLProduct.setAcceptance(this.liftAcceptance(lTLProduct, dA.getAcceptance()));
        for (String string : dTMC.getLabels()) {
            BitSet bitSet3 = lTLProduct.liftFromModel(dTMC.getLabelStates(string));
            dTMCSimple.addLabel(string, bitSet3);
        }
        return lTLProduct;
    }

    public LTLProduct<MDP> constructProductMDP(ProbModelChecker probModelChecker, MDP mDP, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(probModelChecker, mDP, expression, vector, acceptanceTypeArray);
        this.mainLog.println("\nConstructing MDP-" + dA.getAutomataType() + " product...");
        LTLProduct<MDP> lTLProduct = this.constructProductMDP(dA, mDP, vector, bitSet);
        this.mainLog.print("\n" + ((MDP)lTLProduct.getProductModel()).infoStringTable());
        return lTLProduct;
    }

    public LTLProduct<MDP> constructProductMDP(DA<BitSet, ? extends AcceptanceOmega> dA, MDP mDP, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        Object object;
        int n;
        MDPSimple mDPSimple = new MDPSimple();
        int n2 = dA.size();
        int n3 = dA.getAPList().size();
        int n4 = mDP.getNumStates();
        int n5 = n4 * n2;
        BitSet bitSet2 = new BitSet(n3);
        ArrayList<State> arrayList = null;
        ArrayList<State> arrayList2 = null;
        LinkedList<Point> linkedList = new LinkedList<Point>();
        int[] nArray = new int[n5];
        Arrays.fill(nArray, -1);
        if (mDP.getStatesList() != null) {
            arrayList = new ArrayList<State>();
            arrayList2 = new ArrayList<State>(dA.size());
            for (int i = 0; i < dA.size(); ++i) {
                arrayList2.add(new State(1).setValue(0, i));
            }
        }
        Object object2 = new IterableStateSet(bitSet, mDP.getNumStates()).iterator();
        while (object2.hasNext()) {
            int n6 = object2.next();
            for (n = 0; n < n3; ++n) {
                bitSet2.set(n, vector.get(Integer.parseInt(dA.getAPList().get(n).substring(1))).get(n6));
            }
            n = dA.getEdgeDestByLabel(dA.getStartState(), bitSet2);
            if (n < 0) {
                throw new PrismException("The deterministic automaton is not complete (state " + dA.getStartState() + ")");
            }
            linkedList.add(new Point(n6, n));
            mDPSimple.addState();
            mDPSimple.addInitialState(mDPSimple.getNumStates() - 1);
            nArray[n6 * n2 + n] = mDPSimple.getNumStates() - 1;
            if (arrayList == null) continue;
            arrayList.add(new State((State)arrayList2.get(n), mDP.getStatesList().get(n6)));
        }
        object2 = new BitSet(n5);
        while (!linkedList.isEmpty()) {
            Point point = (Point)linkedList.pop();
            int n7 = point.x;
            int n8 = point.y;
            ((BitSet)object2).set(n7 * n2 + n8);
            n = mDP.getNumChoices(n7);
            for (int i = 0; i < n; ++i) {
                Distribution object3 = new Distribution();
                object = mDP.getTransitionsIterator(n7, i);
                while (object.hasNext()) {
                    Map.Entry<Integer, Double> entry = object.next();
                    int n9 = entry.getKey();
                    double d = entry.getValue();
                    for (int j = 0; j < n3; ++j) {
                        bitSet2.set(j, vector.get(Integer.parseInt(dA.getAPList().get(j).substring(1))).get(n9));
                    }
                    int n10 = dA.getEdgeDestByLabel(n8, bitSet2);
                    if (n10 < 0) {
                        throw new PrismException("The deterministic automaton is not complete (state " + n8 + ")");
                    }
                    if (!((BitSet)object2).get(n9 * n2 + n10) && nArray[n9 * n2 + n10] == -1) {
                        linkedList.add(new Point(n9, n10));
                        mDPSimple.addState();
                        nArray[n9 * n2 + n10] = mDPSimple.getNumStates() - 1;
                        if (arrayList != null) {
                            arrayList.add(new State((State)arrayList2.get(n10), mDP.getStatesList().get(n9)));
                        }
                    }
                    object3.set(nArray[n9 * n2 + n10], d);
                }
                mDPSimple.addActionLabelledChoice(nArray[n7 * n2 + n8], object3, mDP.getAction(n7, i));
            }
        }
        int[] nArray2 = new int[mDPSimple.getNumStates()];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == -1) continue;
            nArray2[nArray[n]] = n;
        }
        mDPSimple.findDeadlocks(false);
        if (arrayList != null) {
            mDPSimple.setStatesList(arrayList);
        }
        LTLProduct lTLProduct = new LTLProduct(this, (Model)mDPSimple, (Model)mDP, null, n2, nArray2);
        lTLProduct.setAcceptance(this.liftAcceptance(lTLProduct, dA.getAcceptance()));
        for (String string : mDP.getLabels()) {
            object = lTLProduct.liftFromModel(mDP.getLabelStates(string));
            mDPSimple.addLabel(string, (BitSet)object);
        }
        return lTLProduct;
    }

    public BitSet findAcceptingBSCCs(Model model, AcceptanceOmega acceptanceOmega) throws PrismException {
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, model);
        sCCComputer.computeBSCCs();
        List<BitSet> list = sCCComputer.getBSCCs();
        BitSet bitSet = new BitSet();
        for (BitSet bitSet2 : list) {
            if (!acceptanceOmega.isBSCCAccepting(bitSet2)) continue;
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public BitSet findAcceptingECStates(NondetModel nondetModel, AcceptanceOmega acceptanceOmega) throws PrismException {
        if (acceptanceOmega instanceof AcceptanceRabin) {
            return this.findAcceptingECStatesForRabin(nondetModel, (AcceptanceRabin)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceGenRabin) {
            return this.findAcceptingECStatesForGeneralizedRabin(nondetModel, (AcceptanceGenRabin)acceptanceOmega);
        }
        throw new PrismNotSupportedException("Computing end components for acceptance type '" + acceptanceOmega.getTypeName() + "' currently not supported (explicit engine).");
    }

    public BitSet findAcceptingECStatesForRabin(NondetModel nondetModel, AcceptanceRabin acceptanceRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3, ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getK());
            List<BitSet> list = eCComputer.getMECStates();
            for (BitSet bitSet4 : list) {
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForGeneralizedRabin(NondetModel nondetModel, AcceptanceGenRabin acceptanceGenRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceGenRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3);
            List<BitSet> list = eCComputer.getMECStates();
            int n2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getNumK();
            for (BitSet bitSet4 : list) {
                boolean bl = true;
                for (int j = 0; j < n2; ++j) {
                    if (bitSet4.intersects(((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getK(j))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    private AcceptanceOmega liftAcceptance(final LTLProduct<?> lTLProduct, AcceptanceOmega acceptanceOmega) {
        AcceptanceOmega acceptanceOmega2 = acceptanceOmega.clone();
        acceptanceOmega2.lift(new AcceptanceOmega.LiftBitSet(){

            @Override
            public BitSet lift(BitSet bitSet) {
                return lTLProduct.liftFromAutomaton(bitSet);
            }
        });
        return acceptanceOmega2;
    }

    public static class LTLProduct<M extends Model>
    extends Product<M> {
        private int daSize;
        private int[] invMap;
        private AcceptanceOmega acceptance;
        final /* synthetic */ LTLModelChecker this$0;

        public LTLProduct(M m, M m2, AcceptanceOmega acceptanceOmega, int n, int[] nArray) {
            this.this$0 = var1_1;
            super(m, m2);
            this.daSize = n;
            this.invMap = nArray;
            this.acceptance = acceptanceOmega;
        }

        @Override
        public int getModelState(int n) {
            return this.invMap[n] / this.daSize;
        }

        @Override
        public int getAutomatonState(int n) {
            return this.invMap[n] % this.daSize;
        }

        public AcceptanceOmega getAcceptance() {
            return this.acceptance;
        }

        public void setAcceptance(AcceptanceOmega acceptanceOmega) {
            this.acceptance = acceptanceOmega;
        }
    }
}

