/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.DTMC;
import explicit.ModelExplicit;
import explicit.rewards.MCRewards;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import prism.ModelType;
import prism.Pair;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public abstract class DTMCExplicit
extends ModelExplicit
implements DTMC {
    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        prismLog.print(this.numStates + " " + this.getNumTransitions() + "\n");
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.numStates; ++i) {
            Iterator<Map.Entry<Integer, Pair<Double, Object>>> iterator = this.getTransitionsAndActionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<Double, Object>> entry = iterator.next();
                treeMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                prismLog.print(i + " " + entry.getKey() + " " + PrismUtils.formatDouble((Double)((Pair)entry.getValue()).first));
                Object y = ((Pair)entry.getValue()).second;
                if (y != null && !"".equals(y)) {
                    prismLog.print(" " + y);
                }
                prismLog.print("\n");
            }
            treeMap.clear();
        }
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            prismLog.print(n + " -> " + entry.getKey() + " [ label=\"");
            prismLog.print(entry.getValue() + "\" ];\n");
        }
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.numStates - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            for (int i = 0; i < this.numStates; ++i) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                fileWriter.write("[]x=" + i + "->");
                boolean bl = true;
                for (Map.Entry entry : treeMap.entrySet()) {
                    if (bl) {
                        bl = false;
                    } else {
                        fileWriter.write("+");
                    }
                    fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                }
                fileWriter.write(";\n");
                treeMap.clear();
            }
            fileWriter.write("endmodule\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + (Object)((Object)this.getModelType()) + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Double, Object>>> getTransitionsAndActionsIterator(int n) {
        return new AddDefaultActionToTransitionsIterator(this.getTransitionsIterator(n), null);
    }

    @Override
    public void mvMult(double[] dArray, double[] dArray2, BitSet bitSet, boolean bl) {
        for (int n : new IterableStateSet(bitSet, this.numStates, bl)) {
            dArray2[n] = this.mvMultSingle(n, dArray);
        }
    }

    @Override
    public double mvMultGS(double[] dArray, BitSet bitSet, boolean bl, boolean bl2) {
        double d = 0.0;
        for (int n : new IterableStateSet(bitSet, this.numStates, bl)) {
            double d2 = this.mvMultJacSingle(n, dArray);
            double d3 = bl2 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    @Override
    public void mvMultRew(double[] dArray, MCRewards mCRewards, double[] dArray2, BitSet bitSet, boolean bl) {
        for (int n : new IterableStateSet(bitSet, this.numStates, bl)) {
            dArray2[n] = this.mvMultRewSingle(n, dArray, mCRewards);
        }
    }

    public class AddDefaultActionToTransitionsIterator
    implements Iterator<Map.Entry<Integer, Pair<Double, Object>>> {
        private Iterator<Map.Entry<Integer, Double>> transIter;
        private Object defaultAction;
        private Map.Entry<Integer, Double> next;

        public AddDefaultActionToTransitionsIterator(Iterator<Map.Entry<Integer, Double>> iterator, Object object) {
            this.transIter = iterator;
            this.defaultAction = object;
        }

        @Override
        public Map.Entry<Integer, Pair<Double, Object>> next() {
            this.next = this.transIter.next();
            Map.Entry<Integer, Pair<Double, Object>> entry = new Map.Entry<Integer, Pair<Double, Object>>(){

                @Override
                public Pair<Double, Object> setValue(Pair<Double, Object> pair) {
                    return null;
                }

                @Override
                public Pair<Double, Object> getValue() {
                    return new Pair<Double, Object>((Double)AddDefaultActionToTransitionsIterator.this.next.getValue(), AddDefaultActionToTransitionsIterator.this.defaultAction);
                }

                @Override
                public Integer getKey() {
                    return (Integer)AddDefaultActionToTransitionsIterator.this.next.getKey();
                }
            };
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.transIter.hasNext();
        }

        @Override
        public void remove() {
        }
    }
}

