/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.DTMC;
import explicit.DTMCEmbeddedSimple;
import explicit.DTMCSimple;
import explicit.DTMCUniformisedSimple;
import explicit.Distribution;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import prism.ModelType;

public class CTMCSimple
extends DTMCSimple
implements CTMC {
    private DTMCEmbeddedSimple cachedEmbeddedDTMC = null;

    public CTMCSimple() {
    }

    public CTMCSimple(int n) {
        super(n);
    }

    public CTMCSimple(CTMCSimple cTMCSimple) {
        super(cTMCSimple);
    }

    public CTMCSimple(CTMCSimple cTMCSimple, int[] nArray) {
        super(cTMCSimple, nArray);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.CTMC;
    }

    @Override
    public double getExitRate(int n) {
        return ((Distribution)this.trans.get(n)).sum();
    }

    @Override
    public double getMaxExitRate() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numStates; ++i) {
            double d2 = ((Distribution)this.trans.get(i)).sum();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getMaxExitRate(BitSet bitSet) {
        double d = Double.NEGATIVE_INFINITY;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            double d2 = ((Distribution)this.trans.get(n)).sum();
            if (d2 > d) {
                d = d2;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return d;
    }

    @Override
    public double getDefaultUniformisationRate() {
        return 1.02 * this.getMaxExitRate();
    }

    @Override
    public double getDefaultUniformisationRate(BitSet bitSet) {
        return 1.02 * this.getMaxExitRate(bitSet);
    }

    @Override
    public DTMC buildImplicitEmbeddedDTMC() {
        DTMCEmbeddedSimple dTMCEmbeddedSimple = new DTMCEmbeddedSimple(this);
        if (this.cachedEmbeddedDTMC != null) {
            this.cachedEmbeddedDTMC = dTMCEmbeddedSimple;
        }
        return dTMCEmbeddedSimple;
    }

    @Override
    public DTMC getImplicitEmbeddedDTMC() {
        if (this.cachedEmbeddedDTMC == null) {
            this.cachedEmbeddedDTMC = new DTMCEmbeddedSimple(this);
        }
        return this.cachedEmbeddedDTMC;
    }

    @Override
    public DTMCSimple buildEmbeddedDTMC() {
        DTMCSimple dTMCSimple = new DTMCSimple(this.numStates);
        Iterator<Object> iterator = this.getInitialStates().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            dTMCSimple.addInitialState(n);
        }
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = (Distribution)this.trans.get(i);
            double d = distribution.sum();
            if (d == 0.0) {
                dTMCSimple.setProbability(i, i, 1.0);
                continue;
            }
            for (Map.Entry entry : distribution) {
                dTMCSimple.setProbability(i, (Integer)entry.getKey(), (Double)entry.getValue() / d);
            }
        }
        return dTMCSimple;
    }

    @Override
    public void uniformise(double d) {
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = (Distribution)this.trans.get(i);
            distribution.set(i, d - distribution.sumAllBut(i));
        }
    }

    @Override
    public DTMC buildImplicitUniformisedDTMC(double d) {
        return new DTMCUniformisedSimple(this, d);
    }

    @Override
    public DTMCSimple buildUniformisedDTMC(double d) {
        DTMCSimple dTMCSimple = new DTMCSimple(this.numStates);
        Iterator<Object> iterator = this.getInitialStates().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            dTMCSimple.addInitialState(n);
        }
        for (int i = 0; i < this.numStates; ++i) {
            Distribution distribution = (Distribution)this.trans.get(i);
            for (Map.Entry entry : distribution) {
                dTMCSimple.setProbability(i, (Integer)entry.getKey(), (Double)entry.getValue() / d);
            }
            double d2 = distribution.sumAllBut(i);
            if (!(d2 < d)) continue;
            dTMCSimple.setProbability(i, i, 1.0 - d2 / d);
        }
        return dTMCSimple;
    }
}

