/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IterableBitSet
implements Iterable<Integer> {
    private BitSet set;
    private boolean clearBits = false;
    private Integer maxIndex = null;

    public IterableBitSet(BitSet bitSet) {
        this.set = bitSet;
        this.clearBits = false;
    }

    public IterableBitSet(BitSet bitSet, int n, boolean bl) {
        this.set = bitSet;
        this.maxIndex = n;
        this.clearBits = bl;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (!this.clearBits) {
            return new SetBitsIterator();
        }
        return new ClearBitsIterator();
    }

    public static IterableBitSet getSetBits(BitSet bitSet) {
        return new IterableBitSet(bitSet);
    }

    public static IterableBitSet getClearBits(BitSet bitSet, int n) {
        return new IterableBitSet(bitSet, n, true);
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet();
        bitSet.set(1);
        bitSet.set(2);
        bitSet.set(3);
        bitSet.set(5);
        bitSet.set(8);
        bitSet.set(13);
        bitSet.set(21);
        System.out.println("\n" + bitSet + " - set bits:");
        for (Integer n : IterableBitSet.getSetBits(bitSet)) {
            System.out.println(n);
        }
        bitSet.clear();
        Iterator<Integer> iterator = IterableBitSet.getSetBits(bitSet).iterator();
        if (iterator.hasNext()) {
            Integer n;
            n = iterator.next();
            throw new RuntimeException("BitSet should be empty!");
        }
    }

    private class ClearBitsIterator
    implements Iterator<Integer> {
        private int index;

        private ClearBitsIterator() {
            this.index = IterableBitSet.this.set.nextClearBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.index <= IterableBitSet.this.maxIndex;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                Integer n = this.index;
                this.index = IterableBitSet.this.set.nextClearBit(this.index + 1);
                return n;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SetBitsIterator
    implements Iterator<Integer> {
        private int index;

        private SetBitsIterator() {
            this.index = IterableBitSet.this.set.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            if (IterableBitSet.this.maxIndex != null && this.index > IterableBitSet.this.maxIndex) {
                return false;
            }
            return this.index >= 0;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                Integer n = this.index;
                this.index = IterableBitSet.this.set.nextSetBit(this.index + 1);
                return n;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

