/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class analyseCTMC {
    public String modelFile;
    private int stateMin;
    private int stateMax;
    public String property;
    private String prop_pre;
    private String prop_x;
    private String prop_y;
    public Config config;
    public Hashtable<Integer, State> htStates = new Hashtable();

    public analyseCTMC(int _min, int _max, Config c) {
        this.config = c;
        this.stateMin = _min;
        this.stateMax = _max;
        int i = _min;
        while (i <= _max) {
            State s = new State();
            s.ID = i;
            this.htStates.put(i, s);
            ++i;
        }
        for (String key : this.config.termStates.keySet()) {
            State s = this.htStates.get(this.config.termStates.get(key));
            s.terminal = true;
        }
    }

    public void breakProperty() {
        int pos = this.property.indexOf("[");
        this.prop_pre = this.property.substring(0, pos);
        int pos2 = this.property.indexOf(" U", pos);
        this.prop_x = this.property.substring(pos + 1, pos2);
        pos = this.property.indexOf("T ");
        pos2 = this.property.indexOf("]");
        this.prop_y = this.property.substring(pos + 2, pos2);
    }

    public void testVisited() {
        int i = this.stateMin;
        while (i <= this.stateMax) {
            this.testVisited(i);
            ++i;
        }
    }

    public void testVisited(Integer state) {
        String newProp = String.valueOf(this.prop_pre) + " [" + this.prop_x + " U " + this.prop_y + "]";
        this.WriteProps(newProp);
        PrismInterface api = this.getAPI(this.modelFile, "temp/_temp.props");
        List<Double> resultList = api.runPrism();
        Double p_Norm = resultList.get(0);
        newProp = String.valueOf(this.prop_pre) + " [(!s=" + state + " & " + this.prop_x + ")" + " U " + this.prop_y + "]";
        this.WriteProps(newProp);
        api.reloadProps();
        resultList = api.runPrism();
        Double p_New = resultList.get(0);
        Double result = (p_Norm - p_New) / p_Norm;
        if (result == 0.0) {
            State sCurrent = this.htStates.get(state);
            sCurrent.init();
            sCurrent.ignore = true;
            sCurrent.preDelay = false;
        } else if (result == 1.0) {
            State sCurrent = this.htStates.get(state);
            sCurrent.init();
            sCurrent.alwaysVisited = true;
            sCurrent.ignore = false;
        } else {
            State sCurrent = this.htStates.get(state);
            sCurrent.init();
            sCurrent.ignore = false;
            sCurrent.preDelay = false;
        }
    }

    private PrismInterface getAPI(String model, String props) {
        PrismInterface api = PrismInterface.getInstance(props);
        api.loadModel(model);
        return api;
    }

    private void WriteProps(String p) {
        try {
            PrintWriter out = new PrintWriter("temp/_temp.props");
            out.println(p);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void DisplayStates() {
        int i = this.stateMin;
        while (i <= this.stateMax) {
            System.out.println("------- Display States -------------");
            State s = this.htStates.get(i);
            System.out.println("State : " + s.ID);
            System.out.println("  ignore :" + s.ignore);
            System.out.println("  always :" + s.alwaysVisited);
            System.out.println("  preDelay :" + s.preDelay);
            if (s.terminal.booleanValue()) {
                System.out.println("  Is a terminal state");
            }
            if (s.Combine != null) {
                System.out.println("  Combine delay with : " + s.Combine.ID);
            }
            System.out.println("-----------------------------------");
            ++i;
        }
    }

    public void getTrans() {
        Integer to;
        String sLine;
        BufferedReader br;
        FileReader fr;
        String fName = "_tmp";
        PrismInterface api = this.getAPI(this.modelFile, "temp/_temp.props");
        api.getTrans(fName);
        HashMap<Integer, Integer> stateMap = new HashMap<Integer, Integer>();
        ArrayList<int[]> transMap = new ArrayList<int[]>();
        try {
            fr = new FileReader("temp/" + fName + ".sta");
            br = new BufferedReader(fr);
            sLine = br.readLine();
            while ((sLine = br.readLine()) != null) {
                String[] parts = sLine.split(":");
                Integer from = Integer.parseInt(parts[0]);
                String becomes = parts[1].substring(1, parts[1].length() - 1);
                to = Integer.parseInt(becomes);
                stateMap.put(from, to);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fr = new FileReader("temp/" + fName + ".tra");
            br = new BufferedReader(fr);
            sLine = br.readLine();
            int i = 0;
            while ((sLine = br.readLine()) != null) {
                String[] parts = sLine.split(" ");
                Integer from = (Integer)stateMap.get(Integer.parseInt(parts[0]));
                to = (Integer)stateMap.get(Integer.parseInt(parts[1]));
                State sFrom = this.htStates.get(from);
                State sTo = this.htStates.get(to);
                if ((sFrom.ignore.booleanValue() || sTo.ignore.booleanValue()) && !sTo.terminal.booleanValue()) continue;
                int[] mapping = new int[]{from, to};
                transMap.add(i, mapping);
                ++i;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.preDelay(transMap);
        this.combineDelays(transMap);
    }

    private void combineDelays(ArrayList<int[]> transMap) {
        int[] r;
        HashMap<Integer, Integer> sinks = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> sources = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < transMap.size()) {
            r = transMap.get(i);
            if (!sources.containsKey(r[0])) {
                sources.put(r[0], 1);
            } else {
                sources.put(r[0], (Integer)sources.get(r[0]) + 1);
            }
            if (!sinks.containsKey(r[1])) {
                sinks.put(r[1], 1);
            } else {
                sinks.put(r[1], (Integer)sinks.get(r[1]) + 1);
            }
            ++i;
        }
        i = 0;
        while (i < transMap.size()) {
            r = transMap.get(i);
            Integer scFrom = (Integer)sources.get(r[0]);
            Integer scTo = (Integer)sinks.get(r[1]);
            if (scFrom != null && scTo != null && scFrom == 1 && scTo == 1 && !this.htStates.get((Object)Integer.valueOf((int)r[0])).preDelay.booleanValue() && !this.htStates.get((Object)Integer.valueOf((int)r[1])).preDelay.booleanValue()) {
                this.htStates.get((Object)Integer.valueOf((int)r[1])).Combine = this.htStates.get(r[0]);
            }
            ++i;
        }
    }

    private void preDelay(ArrayList<int[]> transMap) {
        String ExStates = "";
        int i = this.stateMin;
        while (i <= this.stateMax) {
            State s = this.htStates.get(i);
            if (s.ignore.booleanValue()) {
                ExStates = ExStates == "" ? "!s=" + i : String.valueOf(ExStates) + " & !s=" + i;
            }
            ++i;
        }
        i = 0;
        while (i < transMap.size()) {
            int[] r = transMap.get(i);
            State sFrom = this.htStates.get(r[0]);
            if (sFrom.alwaysVisited.booleanValue()) {
                String newProp = "filter(min, P=?[" + ExStates + " U s=" + r[0] + "], s=" + r[1] + ")";
                this.WriteProps(newProp);
                PrismInterface api = this.getAPI(this.modelFile, "temp/_temp.props");
                List<Double> resultList = api.runPrism();
                if (resultList.get(0) > 0.0) {
                    sFrom.preDelay = false;
                }
            }
            ++i;
        }
    }
}

