/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;

public class AcceptanceStreettDD
extends ArrayList<StreettPair>
implements AcceptanceOmegaDD {
    public AcceptanceStreettDD(AcceptanceStreett acceptanceStreett, JDDVars jDDVars) {
        for (AcceptanceStreett.StreettPair streettPair : acceptanceStreett) {
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(streettPair.getR()).iterator();
            while (object.hasNext()) {
                int n = object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = JDD.Constant(0.0);
            Object object2 = IterableBitSet.getSetBits(streettPair.getG()).iterator();
            while (object2.hasNext()) {
                int n = object2.next();
                object = JDD.SetVectorElement((JDDNode)object, jDDVars, n, 1.0);
            }
            object2 = new StreettPair(jDDNode, (JDDNode)object);
            this.add(object2);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (StreettPair streettPair : this) {
            if (streettPair.isBSCCAccepting(jDDNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        for (StreettPair streettPair : this) {
            streettPair.clear();
        }
        super.clear();
    }

    @Override
    public String toString() {
        String string = "";
        for (StreettPair streettPair : this) {
            string = string + streettPair.toString();
        }
        return string;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Streett pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.STREETT;
    }

    @Override
    public String getTypeAbbreviated() {
        return "S";
    }

    @Override
    public String getTypeName() {
        return "Streett";
    }

    public static class StreettPair {
        private JDDNode R;
        private JDDNode G;

        public StreettPair(JDDNode jDDNode, JDDNode jDDNode2) {
            this.R = jDDNode;
            this.G = jDDNode2;
        }

        public void clear() {
            if (this.R != null) {
                JDD.Deref(this.R);
            }
            if (this.G != null) {
                JDD.Deref(this.G);
            }
        }

        public JDDNode getR() {
            JDD.Ref(this.R);
            return this.R;
        }

        public JDDNode getG() {
            JDD.Ref(this.G);
            return this.G;
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.R, jDDNode)) {
                return JDD.AreIntersecting(this.G, jDDNode);
            }
            return true;
        }

        public String toString() {
            return "(" + this.R + "->" + this.G + ")";
        }
    }
}

