/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreettDD;
import acceptance.AcceptanceType;
import java.util.ArrayList;
import java.util.BitSet;
import jdd.JDDVars;

public class AcceptanceStreett
extends ArrayList<StreettPair>
implements AcceptanceOmega {
    @Override
    public AcceptanceStreett clone() {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        for (StreettPair streettPair : this) {
            acceptanceStreett.add(streettPair.clone());
        }
        return acceptanceStreett;
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        for (StreettPair streettPair : this) {
            if (streettPair.isBSCCAccepting(bitSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        for (StreettPair streettPair : this) {
            streettPair.R = liftBitSet.lift(streettPair.R);
            streettPair.G = liftBitSet.lift(streettPair.G);
        }
    }

    public AcceptanceRabin complement() {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        for (StreettPair streettPair : this) {
            BitSet bitSet = (BitSet)streettPair.getG().clone();
            BitSet bitSet2 = (BitSet)streettPair.getR().clone();
            AcceptanceRabin.RabinPair rabinPair = new AcceptanceRabin.RabinPair(bitSet, bitSet2);
            acceptanceRabin.add(rabinPair);
        }
        return acceptanceRabin;
    }

    public AcceptanceStreett and(AcceptanceStreett acceptanceStreett) {
        AcceptanceStreett acceptanceStreett2 = new AcceptanceStreett();
        for (StreettPair streettPair : this) {
            acceptanceStreett2.add(streettPair.clone());
        }
        for (StreettPair streettPair : acceptanceStreett) {
            acceptanceStreett2.add(streettPair.clone());
        }
        return acceptanceStreett2;
    }

    @Override
    public AcceptanceStreettDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceStreettDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGeneric(true);
        }
        AcceptanceGeneric acceptanceGeneric = null;
        for (StreettPair streettPair : this) {
            AcceptanceGeneric acceptanceGeneric2 = streettPair.toAcceptanceGeneric();
            if (acceptanceGeneric == null) {
                acceptanceGeneric = acceptanceGeneric2;
                continue;
            }
            acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.AND, acceptanceGeneric, acceptanceGeneric2);
        }
        return acceptanceGeneric;
    }

    @Override
    public String getSignatureForState(int n) {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            StreettPair streettPair = (StreettPair)this.get(i);
            string = string + streettPair.getSignatureForState(n, i);
        }
        return string;
    }

    @Override
    public String toString() {
        String string = "";
        for (StreettPair streettPair : this) {
            string = string + streettPair.toString();
        }
        return string;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Streett pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.STREETT;
    }

    @Override
    public String getTypeAbbreviated() {
        return "S";
    }

    @Override
    public String getTypeName() {
        return "Streett";
    }

    public static class StreettPair {
        private BitSet R;
        private BitSet G;

        public StreettPair(BitSet bitSet, BitSet bitSet2) {
            this.R = bitSet;
            this.G = bitSet2;
        }

        public BitSet getR() {
            return this.R;
        }

        public BitSet getG() {
            return this.G;
        }

        public boolean isBSCCAccepting(BitSet bitSet) {
            if (this.R.intersects(bitSet)) {
                return this.G.intersects(bitSet);
            }
            return true;
        }

        public AcceptanceGeneric toAcceptanceGeneric() {
            AcceptanceGeneric acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.FIN, (BitSet)this.R.clone());
            AcceptanceGeneric acceptanceGeneric2 = new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)this.G.clone());
            return new AcceptanceGeneric(AcceptanceGeneric.ElementType.OR, acceptanceGeneric, acceptanceGeneric2);
        }

        public String getSignatureForState(int n, int n2) {
            if (this.G.get(n)) {
                return "+" + n2;
            }
            if (this.R.get(n)) {
                return "-" + n2;
            }
            return "";
        }

        public StreettPair clone() {
            return new StreettPair((BitSet)this.R.clone(), (BitSet)this.G.clone());
        }

        public String toString() {
            return "(" + this.R + "->" + this.G + ")";
        }
    }
}

