/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;

public class AcceptanceGenericDD
implements AcceptanceOmegaDD {
    private AcceptanceGeneric.ElementType kind;
    private AcceptanceGenericDD left = null;
    private AcceptanceGenericDD right = null;
    private JDDNode states = null;

    public AcceptanceGenericDD(AcceptanceGeneric acceptanceGeneric, JDDVars jDDVars) {
        switch (acceptanceGeneric.getKind()) {
            case AND: 
            case OR: {
                this.kind = acceptanceGeneric.getKind();
                this.left = (AcceptanceGenericDD)acceptanceGeneric.getLeft().toAcceptanceDD(jDDVars);
                this.right = (AcceptanceGenericDD)acceptanceGeneric.getRight().toAcceptanceDD(jDDVars);
                return;
            }
            case TRUE: {
                this.kind = AcceptanceGeneric.ElementType.TRUE;
                return;
            }
            case FALSE: {
                this.kind = AcceptanceGeneric.ElementType.FALSE;
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                this.kind = acceptanceGeneric.getKind();
                this.states = JDD.Constant(0.0);
                for (int n : IterableBitSet.getSetBits(acceptanceGeneric.getStates())) {
                    this.states = JDD.SetVectorElement(this.states, jDDVars, n, 1.0);
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operatator in generic acceptance condition");
    }

    public AcceptanceGeneric.ElementType getKind() {
        return this.kind;
    }

    public AcceptanceGenericDD getLeft() {
        return this.left;
    }

    public AcceptanceGenericDD getRight() {
        return this.right;
    }

    public JDDNode getStates() {
        if (this.states != null) {
            JDD.Ref(this.states);
        }
        return this.states;
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        switch (this.kind) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case AND: {
                return this.left.isBSCCAccepting(jDDNode) && this.right.isBSCCAccepting(jDDNode);
            }
            case OR: {
                return this.left.isBSCCAccepting(jDDNode) || this.right.isBSCCAccepting(jDDNode);
            }
            case INF: {
                return JDD.AreIntersecting(this.states, jDDNode);
            }
            case INF_NOT: {
                JDD.Ref(this.states);
                return JDD.AreIntersecting(JDD.Not(this.states), jDDNode);
            }
            case FIN: {
                return !JDD.AreIntersecting(this.states, jDDNode);
            }
            case FIN_NOT: {
                JDD.Ref(this.states);
                return !JDD.AreIntersecting(JDD.Not(this.states), jDDNode);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }

    @Override
    public String getSizeStatistics() {
        return "generic acceptance with " + this.countAcceptanceSets() + " acceptance sets";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERIC;
    }

    @Override
    public String getTypeAbbreviated() {
        return "";
    }

    @Override
    public String getTypeName() {
        return "generic";
    }

    @Override
    public void clear() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return;
            }
            case AND: 
            case OR: {
                this.left.clear();
                this.right.clear();
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                if (this.states != null) {
                    JDD.Deref(this.states);
                }
                this.states = null;
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }

    public int countAcceptanceSets() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return 0;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return 1;
            }
            case AND: 
            case OR: {
                return this.left.countAcceptanceSets() + this.right.countAcceptanceSets();
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }
}

