/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class Refine {
    private Config config;
    private Double[] results;
    private Integer resultCount = 0;
    private ExecuteHS ex = new ExecuteHS();
    private Integer currentSize;

    public Refine(Config c) {
        this.config = c;
        this.results = new Double[this.config.staticStepCount.intValue()];
        this.currentSize = 0;
    }

    public void start(Boolean diag) {
        this.ex.HSLocation = this.config.HSLocation;
        for (String shortname : this.config.components.keySet()) {
            Component component = this.config.components.get(shortname);
            if (component.ignore) continue;
            String outFile = "temp/" + component.shortName + "_fit.txt";
            File oF = new File(outFile);
            if (!oF.exists()) {
                this.ex.trainingFile = String.valueOf(component.shortName) + "Data.csv";
                this.resultCount = 0;
                this.ex.initTmingData();
                this.currentSize = this.config.kStart;
                while (this.currentSize <= this.config.bLengthLimit) {
                    this.ex.branches = this.min(this.currentSize, this.config.bCountLimit);
                    this.ex.length = this.min(this.currentSize, this.config.bLengthLimit);
                    try {
                        this.ex.run(false, outFile);
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.resultCount < this.config.staticStepCount) {
                        this.results[this.resultCount.intValue()] = this.ex.CDF;
                        this.resultCount = this.resultCount + 1;
                    } else if (this.checkTermination(this.ex.CDF).booleanValue()) {
                        if (!diag.booleanValue()) break;
                        System.out.println("Termination Found @ k=" + this.currentSize);
                        break;
                    }
                    if (diag.booleanValue()) {
                        System.out.println("k: " + this.currentSize + ", CDF: " + this.ex.CDF);
                    }
                    this.currentSize = this.currentSize + this.config.kInc;
                }
                System.out.println("Resultant model constraint(" + component.shortName + "): " + (this.currentSize - this.config.staticStepCount * this.config.kInc));
                this.buildFinal(this.currentSize - this.config.staticStepCount * this.config.kInc, outFile);
                continue;
            }
            System.out.println("Using existing fit file " + outFile);
        }
    }

    private void buildFinal(Integer kSize, String fileName) {
        this.ex.branches = this.min(kSize, this.config.bCountLimit);
        this.ex.length = this.min(kSize, this.config.bLengthLimit);
        try {
            this.ex.run(false, fileName);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Integer min(Integer i1, Integer i2) {
        if (i1 <= i2) {
            return i1;
        }
        return i2;
    }

    private Boolean checkTermination(Double newVal) {
        Double MaxValue = 0.0;
        int i = 1;
        while (i < this.config.staticStepCount) {
            if (Math.abs(this.results[i] - this.results[0]) > MaxValue) {
                MaxValue = Math.abs(this.results[i] - this.results[0]);
            }
            ++i;
        }
        if (Math.abs(newVal - this.results[0]) > MaxValue) {
            MaxValue = Math.abs(newVal - this.results[0]);
        }
        if (MaxValue < this.config.epsilon) {
            return true;
        }
        i = 0;
        while (i < this.config.staticStepCount - 1) {
            this.results[i] = this.results[i + 1];
            ++i;
        }
        this.results[this.config.staticStepCount.intValue() - 1] = newVal;
        return false;
    }
}

