/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;

public class ParseModel {
    int stateCount = 0;
    int componentCount = 0;
    HashMap<String, Integer> ncStates = new HashMap();
    public int totalStateCount = -1;
    Config config;

    public ParseModel(Config c) {
        this.config = c;
        this.componentCount = this.config.components.size();
    }

    /*
     * WARNING - void declaration
     */
    public String Process(String delayBlock) {
        void var12_35;
        void var12_29;
        void var12_26;
        String sIn = this.config.ModelLocation;
        String delay_fragment = "delay_mod.frag";
        String delay_modules = "";
        String header = "";
        for (String shortname : this.config.components.keySet()) {
            Component c = this.config.components.get(shortname);
            if (c.ignore) continue;
            if (c.hasDelay) {
                try {
                    byte[] encoded = Files.readAllBytes(Paths.get(delay_fragment, new String[0]));
                    String dmod = new String(encoded, Charset.defaultCharset());
                    delay_modules = String.valueOf(delay_modules) + dmod.replaceAll("<#shortName>", shortname) + "\r\n";
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                header = String.valueOf(header) + "[d_" + c.shortName + "Start] s=" + c.state + " -> (s'=" + c.state + ");\r\n";
                header = String.valueOf(header) + "[d_" + c.shortName + "Fin] s=" + c.state + " -> (s'=" + (c.state + 1) + ");\r\n";
                header = String.valueOf(header) + "[" + c.shortName + "Start] s=" + (c.state + 1) + "->(s'=" + (c.state + 1) + ");\r\n\r\n";
                continue;
            }
            header = String.valueOf(header) + "[" + c.shortName + "Start] s=" + c.state + "->(s'=" + c.state + ");\r\n\r\n";
        }
        this.stateCount = this.config.totalStates;
        String model = "";
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(sIn, new String[0]));
            model = new String(encoded, Charset.defaultCharset());
            int pos = 0;
            int found = model.indexOf("<!", pos);
            while (found > 0) {
                int lastChar = model.indexOf(">", found);
                String tag = model.substring(found, lastChar + 1);
                if (!this.ncStates.containsKey(tag)) {
                    this.ncStates.put(tag, this.stateCount + this.ncStates.size() + 1);
                }
                pos = lastChar;
                found = model.indexOf("<!", pos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        model = model.replaceAll("#statecount", "1.." + (this.stateCount + this.ncStates.size()));
        for (String key : this.ncStates.keySet()) {
            model = model.replaceAll(key, this.ncStates.get(key).toString());
        }
        String outModel = "";
        BufferedReader bufReader = new BufferedReader(new StringReader(model));
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                String[] elements = line.split("->");
                if (elements.length == 2) {
                    for (String string : this.config.components.keySet()) {
                        Component c = this.config.components.get(string);
                        Integer state = c.state;
                        Integer stateInc = c.state + 1;
                        if (!c.hasDelay) {
                            stateInc = c.state;
                        }
                        elements[0] = elements[0].replaceAll("<\\?" + string + ">", stateInc.toString());
                        elements[1] = elements[1].replaceAll("<\\?" + string + ">", state.toString());
                        line = String.valueOf(elements[0]) + "->" + elements[1];
                    }
                }
                outModel = String.valueOf(outModel) + line + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        model = outModel;
        for (String key : this.config.components.keySet()) {
            Integer state = this.config.components.get((Object)key).state;
            model = model.replaceAll("<\\?" + key + ">", state.toString());
        }
        Integer pos1 = model.indexOf("ctmc");
        String string = "ctmc\r\n\r\n";
        if (this.config.useDelay.booleanValue()) {
            String string2 = String.valueOf(string) + "const int kSize;\r\n\r\n";
        }
        String string3 = String.valueOf(var12_26) + "const double instant=9999;\r\n\r\n";
        if (this.config.useDelay.booleanValue()) {
            String string4 = String.valueOf(string3) + delayBlock + "\r\n\r\n";
        }
        Integer pos2 = model.indexOf("<#");
        String string7 = String.valueOf(var12_29) + model.substring(pos1 + 4, pos2);
        string7 = String.valueOf(string7) + header + "\r\n\r\n";
        string7 = String.valueOf(string7) + model.substring(pos2);
        if (this.config.useDelay.booleanValue()) {
            String string8 = String.valueOf(string7) + delay_modules;
        }
        for (String key : this.config.components.keySet()) {
            Component c = this.config.components.get(key);
            if (!c.ignore) continue;
            String string9 = var12_35.replaceAll("<#" + c.shortName + ">", "[]");
        }
        return var12_35;
    }

    public void makeTemplate(String delayBlock) {
        String template = this.Process(delayBlock);
        try {
            PrintWriter out = new PrintWriter(this.config.TemplateLocation);
            out.println(template);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String makeCTMC() {
        this.stateCount = this.config.components.size();
        String sIn = this.config.ModelLocation;
        String model = "";
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(sIn, new String[0]));
            model = new String(encoded, Charset.defaultCharset());
            int pos = 0;
            int found = model.indexOf("<!", pos);
            while (found > 0) {
                int lastChar = model.indexOf(">", found);
                String tag = model.substring(found, lastChar + 1);
                if (!this.ncStates.containsKey(tag)) {
                    this.ncStates.put(tag, this.stateCount + this.ncStates.size() + 1);
                }
                pos = lastChar;
                found = model.indexOf("<!", pos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("State Count : " + this.stateCount);
        System.out.println("ncStates.size : " + this.ncStates.size());
        model = model.replaceAll("#statecount", "1.." + (this.stateCount + this.ncStates.size()));
        for (String key : this.ncStates.keySet()) {
            model = model.replaceAll(key, this.ncStates.get(key).toString());
            String trimmedKey = key.trim();
            if (!this.config.termStates.containsKey(trimmedKey = trimmedKey.substring(1, trimmedKey.length() - 1))) continue;
            this.config.termStates.put(trimmedKey, this.ncStates.get(key));
        }
        this.totalStateCount = this.stateCount + this.ncStates.size();
        for (String key : this.config.components.keySet()) {
            Integer state = this.config.components.get((Object)key).ordinal;
            model = model.replaceAll("<\\?" + key + ">", state.toString());
            if (!this.config.termStates.containsKey("?" + key)) continue;
            this.config.termStates.put("?" + key, state);
        }
        BufferedReader bufReader = new BufferedReader(new StringReader(model));
        String outModel = "";
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                if ((line = line.trim()).startsWith("<#")) {
                    int pos = line.indexOf(">");
                    line = "[] " + line.substring(pos + 1);
                }
                outModel = String.valueOf(outModel) + line + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ncStates.clear();
        for (String key : this.config.termStates.keySet()) {
            outModel = "// termState : " + key + " : " + this.config.termStates.get(key) + "\n" + outModel;
        }
        outModel = "//Property for analysis : " + this.config.property + "\n" + outModel;
        return outModel;
    }

    public void clearNCStates() {
        this.ncStates.clear();
    }
}

