/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ModelBuilder {
    private Config config;
    private Boolean initialPass;

    public ModelBuilder(Config c) {
        this.config = c;
        this.initialPass = true;
    }

    public void Build(String outName) {
        for (String shortname : this.config.components.keySet()) {
            Component c = this.config.components.get(shortname);
            if (c.ignore) continue;
            try {
                this.run(false, "temp/" + c.shortName + "_fit.txt", c.Name, c.shortName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Utility u = new Utility();
        u.concatenate("temp/stem.tmpl", "temp/module.prism", outName);
    }

    public void run(final Boolean diag, String fitFile, String longName, String shortName) throws IOException, InterruptedException {
        String cmd = this.initialPass != false ? "java -jar " + this.config.H2PLocation + "  " + fitFile + " temp/module.prism " + longName + "  " + shortName + " false " + this.config.TemplateLocation + " temp/stem.tmpl > temp/BranchDump.txt" : "java -jar " + this.config.H2PLocation + "  " + fitFile + " temp/module.prism " + longName + "  " + shortName + " true temp/stem.tmpl temp/stem.tmpl > temp/BranchDump.txt";
        final Process p = Runtime.getRuntime().exec(cmd);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                try {
                    while ((line = input.readLine()) != null) {
                        if (!diag.booleanValue()) continue;
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        p.waitFor();
        this.initialPass = false;
    }
}

