/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import prism.Prism;
import prism.PrismLangException;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class ExpressionProperty
extends SingleProperty {
    protected Prism pr;
    private boolean valid;
    JTextArea area;

    public ExpressionProperty(PropertyOwner propertyOwner, String string, String string2, Prism prism) {
        this(propertyOwner, string, string2, "", prism);
    }

    public ExpressionProperty(PropertyOwner propertyOwner, String string, String string2, String string3, Prism prism) {
        super(propertyOwner, string, "", "", true, string3);
        this.pr = prism;
        this.valid = true;
        this.area = new JTextArea();
        this.area.setLineWrap(false);
        this.area.setOpaque(true);
        try {
            this.setProperty(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExpression() {
        return (String)this.getProperty();
    }

    @Override
    public void setProperty(Object object) throws PropertyException {
        String string = object.toString();
        try {
            if (this.pr == null) {
                throw new PrismLangException("");
            }
            if (!string.equals("")) {
                this.pr.parseSingleExpressionString(string);
            }
            this.valid = true;
        }
        catch (PrismLangException prismLangException) {
            this.valid = false;
        }
        super.setProperty(object);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.area != null) {
            this.area.setEnabled(bl);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.area.setForeground(jTable.getSelectionForeground());
            this.area.setBackground(jTable.getSelectionBackground());
        } else {
            this.area.setForeground(jTable.getForeground());
            this.area.setBackground(jTable.getBackground());
        }
        this.area.setFont(jTable.getFont());
        if (bl2) {
            this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                this.area.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.area.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.area.setBorder(new EmptyBorder(0, 2, 2, 1));
        }
        this.area.setMargin(new Insets(0, 2, 4, 2));
        this.area.setText(object == null ? "" : this.toString());
        if (!this.valid) {
            this.area.setForeground(Color.red);
        }
        return this.area;
    }
}

