/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import parser.State;
import parser.ast.ModulesFile;
import prism.PrismException;
import simulator.GenerateSimulationPath;
import simulator.SimulatorEngine;
import userinterface.GUIComputationThread;
import userinterface.graph.Graph;
import userinterface.simulator.GUISimulator;

public class SimPathPlotThread
extends GUIComputationThread {
    private SimulatorEngine engine;
    private ModulesFile modulesFile;
    private State initialState;
    private String simPathDetails;
    private long maxPathLength;
    private Graph graphModel;

    public SimPathPlotThread(GUISimulator gUISimulator, SimulatorEngine simulatorEngine, ModulesFile modulesFile, State state, String string, long l, Graph graph) {
        super(gUISimulator);
        this.engine = simulatorEngine;
        this.modulesFile = modulesFile;
        this.initialState = state;
        this.simPathDetails = string;
        this.maxPathLength = l;
        this.graphModel = graph;
    }

    @Override
    public void run() {
        try {
            GenerateSimulationPath generateSimulationPath = new GenerateSimulationPath(this.engine, this.prism.getMainLog());
            generateSimulationPath.generateAndPlotSimulationPath(this.modulesFile, this.initialState, this.simPathDetails, this.maxPathLength, this.graphModel);
            if (generateSimulationPath.getNumWarnings() > 0) {
                for (String string : generateSimulationPath.getWarnings()) {
                    this.plug.warning(string);
                }
            }
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
        }
    }
}

