/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import parser.ast.ModulesFile;
import userinterface.CheckBoxList;
import userinterface.GUIPrism;

public class GUIPathPlotDialog
extends JDialog {
    private static GUIPathPlotDialog instance = null;
    private GUIPrism gui;
    private ModulesFile modulesFile;
    private boolean cancelled;
    private String simPathString;
    private long maxPathLength;
    private final JPanel topPanel = new JPanel();
    private JTextField textFieldTime;
    private JTextField textFieldInterval;
    private JLabel lblInterval;
    private JComboBox comboBoxShow;
    private JComboBox comboBoxSimulate;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane tabbedPane;
    private JPanel varsPanel;
    private CheckBoxList varsCheckList;
    private Vector<JCheckBox> varsCheckBoxes;
    private JPanel varsRadios;
    private JRadioButton rdbtnVarsAll;
    private JRadioButton rdbtnVarsSelected;
    private final ButtonGroup buttonGroupVars = new ButtonGroup();
    private JPanel rewardsPanel;
    private JLabel lblVarsShow;
    private JRadioButton rdbtnVarsNone;
    private JPanel bottomPanel;
    private JPanel mainPanel;
    private JCheckBox chckbxChanges;
    private JPanel rewardsRadios;
    private JLabel lblRewardsShow;
    private JRadioButton rdbtnRewardsAll;
    private JRadioButton rdbtnRewardsNone;
    private final ButtonGroup buttonGroupRewards = new ButtonGroup();
    private JLabel lblMaximumPathLength;
    private JTextField textFieldMaxLen;

    public static GUIPathPlotDialog showDialog(GUIPrism gUIPrism, ModulesFile modulesFile) {
        GUIPathPlotDialog gUIPathPlotDialog = GUIPathPlotDialog.getInstance(gUIPrism, modulesFile);
        gUIPathPlotDialog.setVisible(true);
        return gUIPathPlotDialog.wasCancelled() ? null : gUIPathPlotDialog;
    }

    public static String getPathPlotSettings(GUIPrism gUIPrism, ModulesFile modulesFile) {
        GUIPathPlotDialog gUIPathPlotDialog = GUIPathPlotDialog.getInstance(gUIPrism, modulesFile);
        gUIPathPlotDialog.setVisible(true);
        return gUIPathPlotDialog.wasCancelled() ? null : gUIPathPlotDialog.getSimPathString();
    }

    private static GUIPathPlotDialog getInstance(GUIPrism gUIPrism, ModulesFile modulesFile) {
        if (instance != null && GUIPathPlotDialog.instance.gui == gUIPrism && GUIPathPlotDialog.instance.modulesFile == modulesFile) {
            return instance;
        }
        instance = new GUIPathPlotDialog(gUIPrism, modulesFile);
        return instance;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public String getSimPathString() {
        return this.simPathString;
    }

    public long getMaxPathLength() {
        return this.maxPathLength;
    }

    public GUIPathPlotDialog(GUIPrism gUIPrism, ModulesFile modulesFile) {
        super(gUIPrism, "Path Plot Details", true);
        this.gui = gUIPrism;
        this.modulesFile = modulesFile;
        this.setBounds(100, 100, 361, 401);
        this.getContentPane().setLayout(new BorderLayout());
        Serializable serializable = new JPanel();
        serializable.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)serializable, "South");
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        serializable.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        serializable.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.mainPanel = new JPanel();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        serializable = new GridBagLayout();
        ((GridBagLayout)serializable).columnWidths = new int[]{329, 0};
        ((GridBagLayout)serializable).rowHeights = new int[]{103, 0, 0};
        ((GridBagLayout)serializable).columnWeights = new double[]{0.0, Double.MIN_VALUE};
        ((GridBagLayout)serializable).rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout((LayoutManager)((Object)serializable));
        this.mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mainPanel.add((Component)this.topPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{50, 0, 0, 60, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.topPanel.setLayout(gridBagLayout);
        Serializable serializable2 = new JLabel("Simulate:");
        Serializable serializable3 = new GridBagConstraints();
        serializable3.insets = new Insets(0, 0, 5, 5);
        serializable3.anchor = 17;
        serializable3.gridx = 0;
        serializable3.gridy = 0;
        this.topPanel.add((Component)serializable2, serializable3);
        this.comboBoxSimulate = new JComboBox();
        this.comboBoxSimulate.setModel(new DefaultComboBoxModel<SimulateChoice>(SimulateChoice.values()));
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 0;
        this.topPanel.add((Component)this.comboBoxSimulate, serializable2);
        this.textFieldTime = new JTextField();
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 2;
        ((GridBagConstraints)serializable2).gridy = 0;
        this.topPanel.add((Component)this.textFieldTime, serializable2);
        this.textFieldTime.setColumns(5);
        serializable2 = new JLabel("Sample:");
        serializable3 = new GridBagConstraints();
        serializable3.anchor = 17;
        serializable3.insets = new Insets(0, 0, 5, 5);
        serializable3.gridx = 0;
        serializable3.gridy = 1;
        this.topPanel.add((Component)serializable2, serializable3);
        this.comboBoxShow = new JComboBox();
        this.comboBoxShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.comboBoxShowActionPerformed(actionEvent);
            }
        });
        this.comboBoxShow.setModel(new DefaultComboBoxModel<ShowChoice>(ShowChoice.values()));
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.topPanel.add((Component)this.comboBoxShow, serializable2);
        this.lblInterval = new JLabel("of interval");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 2;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.topPanel.add((Component)this.lblInterval, serializable2);
        this.textFieldInterval = new JTextField();
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable2).gridx = 3;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.topPanel.add((Component)this.textFieldInterval, serializable2);
        this.textFieldInterval.setColumns(5);
        this.chckbxChanges = new JCheckBox("Plot changes only");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).gridwidth = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 2;
        this.topPanel.add((Component)this.chckbxChanges, serializable2);
        this.lblMaximumPathLength = new JLabel("Maximum path length:");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).gridwidth = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 3;
        this.topPanel.add((Component)this.lblMaximumPathLength, serializable2);
        this.textFieldMaxLen = new JTextField();
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).gridwidth = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable2).gridx = 2;
        ((GridBagConstraints)serializable2).gridy = 3;
        this.topPanel.add((Component)this.textFieldMaxLen, serializable2);
        this.textFieldMaxLen.setColumns(8);
        this.bottomPanel = new JPanel();
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).fill = 3;
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.mainPanel.add((Component)this.bottomPanel, serializable2);
        serializable3 = new GridBagLayout();
        ((GridBagLayout)serializable3).columnWidths = new int[]{20, 0};
        ((GridBagLayout)serializable3).rowHeights = new int[]{120, 0};
        ((GridBagLayout)serializable3).columnWeights = new double[]{0.0, Double.MIN_VALUE};
        ((GridBagLayout)serializable3).rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.bottomPanel.setLayout((LayoutManager)((Object)serializable3));
        this.tabbedPane = new JTabbedPane(1);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.bottomPanel.add((Component)this.tabbedPane, gridBagConstraints2);
        this.varsPanel = new JPanel();
        this.tabbedPane.addTab("Variables", null, this.varsPanel, null);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{260, 0};
        gridBagLayout2.rowHeights = new int[]{33, 10, 0};
        gridBagLayout2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.varsPanel.setLayout(gridBagLayout2);
        this.varsRadios = new JPanel();
        Serializable serializable4 = (FlowLayout)this.varsRadios.getLayout();
        ((FlowLayout)serializable4).setAlignment(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        this.varsPanel.add((Component)this.varsRadios, gridBagConstraints3);
        this.lblVarsShow = new JLabel("Show:");
        this.varsRadios.add(this.lblVarsShow);
        this.rdbtnVarsAll = new JRadioButton("All");
        this.buttonGroupVars.add(this.rdbtnVarsAll);
        this.rdbtnVarsAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.doEnables();
            }
        });
        this.varsRadios.add(this.rdbtnVarsAll);
        this.rdbtnVarsNone = new JRadioButton("None");
        this.buttonGroupVars.add(this.rdbtnVarsNone);
        this.rdbtnVarsNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.doEnables();
            }
        });
        this.varsRadios.add(this.rdbtnVarsNone);
        this.rdbtnVarsSelected = new JRadioButton("Selected");
        this.buttonGroupVars.add(this.rdbtnVarsSelected);
        this.rdbtnVarsSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.doEnables();
            }
        });
        this.varsRadios.add(this.rdbtnVarsSelected);
        serializable4 = new JScrollPane();
        this.varsCheckList = new CheckBoxList();
        ((JScrollPane)serializable4).setViewportView(this.varsCheckList);
        this.varsCheckBoxes = new Vector();
        this.varsCheckList.setListData(this.varsCheckBoxes);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        this.varsPanel.add((Component)serializable4, gridBagConstraints3);
        this.rewardsPanel = new JPanel();
        this.tabbedPane.addTab("Rewards", null, this.rewardsPanel, null);
        this.rewardsRadios = new JPanel();
        this.rewardsPanel.add(this.rewardsRadios);
        this.rewardsRadios.setLayout(new FlowLayout(1, 5, 5));
        this.lblRewardsShow = new JLabel("Show:");
        this.rewardsRadios.add(this.lblRewardsShow);
        this.rdbtnRewardsAll = new JRadioButton("All");
        this.buttonGroupRewards.add(this.rdbtnRewardsAll);
        this.rewardsRadios.add(this.rdbtnRewardsAll);
        this.rdbtnRewardsNone = new JRadioButton("None");
        this.buttonGroupRewards.add(this.rdbtnRewardsNone);
        this.rewardsRadios.add(this.rdbtnRewardsNone);
        this.initComponents();
    }

    private void initComponents() {
        if (this.modulesFile.getModelType().continuousTime()) {
            this.comboBoxSimulate.setSelectedItem((Object)SimulateChoice.TIME);
            this.comboBoxShow.setSelectedItem((Object)ShowChoice.SNAPSHOTS);
            this.textFieldTime.setText("10.0");
            this.textFieldInterval.setText("0.1");
        } else {
            this.comboBoxSimulate.setSelectedItem((Object)SimulateChoice.STEP);
            this.comboBoxShow.setSelectedItem((Object)ShowChoice.ALL_STEPS);
            this.textFieldTime.setText("100");
            this.textFieldInterval.setText("");
        }
        this.chckbxChanges.setSelected(true);
        this.textFieldMaxLen.setText("" + this.gui.getPrism().getSettings().getLong("simulator.defaultMaxPath"));
        this.rdbtnVarsAll.setSelected(true);
        for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
            this.varsCheckBoxes.add(new JCheckBox(this.modulesFile.getVarName(i)));
        }
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getParent());
        this.pack();
        this.doEnables();
        this.cancelled = true;
    }

    private void doEnables() {
        if ((ShowChoice)((Object)this.comboBoxShow.getSelectedItem()) == ShowChoice.SNAPSHOTS) {
            this.lblInterval.setEnabled(true);
            this.textFieldInterval.setEnabled(true);
        } else {
            this.lblInterval.setEnabled(false);
            this.textFieldInterval.setEnabled(false);
        }
        if (this.rdbtnVarsSelected.isSelected()) {
            this.varsCheckList.setEnabled(true);
            for (JCheckBox jCheckBox : this.varsCheckBoxes) {
                jCheckBox.setEnabled(true);
            }
        } else {
            this.varsCheckList.setEnabled(false);
            for (JCheckBox jCheckBox : this.varsCheckBoxes) {
                jCheckBox.setEnabled(false);
            }
        }
    }

    public void comboBoxShowActionPerformed(ActionEvent actionEvent) {
        this.doEnables();
    }

    public void okButtonActionPerformed(ActionEvent actionEvent) {
        this.simPathString = "";
        switch ((SimulateChoice)((Object)this.comboBoxSimulate.getSelectedItem())) {
            case STEP: {
                try {
                    int n = Integer.parseInt(this.textFieldTime.getText());
                    if (n < 0) {
                        throw new NumberFormatException();
                    }
                    this.simPathString = this.simPathString + n;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.gui.errorDialog("Invalid number of steps \"" + this.textFieldTime.getText() + "\"");
                    return;
                }
            }
            case TIME: {
                try {
                    double d = Double.parseDouble(this.textFieldTime.getText());
                    if (d < 0.0) {
                        throw new NumberFormatException();
                    }
                    this.simPathString = this.simPathString + "time=" + d;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.gui.errorDialog("Invalid time \"" + this.textFieldTime.getText() + "\"");
                    return;
                }
            }
        }
        if ((ShowChoice)((Object)this.comboBoxShow.getSelectedItem()) == ShowChoice.SNAPSHOTS) {
            try {
                double d = Double.parseDouble(this.textFieldInterval.getText());
                if (d < 0.0) {
                    throw new NumberFormatException();
                }
                this.simPathString = this.simPathString + ",snapshot=" + d;
            }
            catch (NumberFormatException numberFormatException) {
                this.gui.errorDialog("Invalid time interval \"" + this.textFieldInterval.getText() + "\"");
                return;
            }
        }
        if (this.chckbxChanges.isSelected()) {
            this.simPathString = this.simPathString + ",changes=true";
        }
        if (this.rdbtnVarsNone.isSelected()) {
            this.simPathString = this.simPathString + ",vars=()";
        } else if (this.rdbtnVarsSelected.isSelected()) {
            String string = "";
            for (JCheckBox jCheckBox : this.varsCheckBoxes) {
                if (!jCheckBox.isSelected()) continue;
                string = string + "," + jCheckBox.getText();
            }
            this.simPathString = this.simPathString + ",vars=(" + string + ")";
        }
        this.simPathString = this.simPathString + ",rewards=" + this.rdbtnRewardsAll.isSelected();
        try {
            long l = Long.parseLong(this.textFieldMaxLen.getText());
            if (l < 0L) {
                throw new NumberFormatException();
            }
            this.maxPathLength = l;
        }
        catch (NumberFormatException numberFormatException) {
            this.gui.errorDialog("Invalid maximum path length \"" + this.textFieldMaxLen.getText() + "\"");
            return;
        }
        this.cancelled = false;
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPathPlotDialog.this.cancelled = true;
                GUIPathPlotDialog.this.dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane jRootPane = new JRootPane();
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public static enum ShowChoice {
        ALL_STEPS,
        SNAPSHOTS;


        public String toString() {
            switch (this) {
                case ALL_STEPS: {
                    return "All steps";
                }
                case SNAPSHOTS: {
                    return "Snapshots";
                }
            }
            return this.toString();
        }
    }

    public static enum SimulateChoice {
        STEP,
        TIME;


        public String toString() {
            switch (this) {
                case STEP: {
                    return "Up to step";
                }
                case TIME: {
                    return "Up to time";
                }
            }
            return this.toString();
        }
    }
}

