/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import parser.Values;
import parser.ast.Declaration;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import userinterface.GUIPrism;

public class GUIInitialStatePicker
extends JDialog
implements KeyListener {
    public static final int NO_VALUES = 0;
    public static final int VALUES_DONE = 1;
    public static final int CANCELLED = 2;
    private boolean cancelled = true;
    private JTable initValuesTable;
    private DefineValuesTable initValuesModel;
    Values initialState;
    private GUIPrism gui;
    private ModulesFile mf;
    private JPanel allPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel innerPanel;
    private JButton okayButton;
    private JCheckBox optionCheckBox;
    private JPanel topPanel;

    public GUIInitialStatePicker(GUIPrism gUIPrism, Values values, ModulesFile modulesFile) {
        super(gUIPrism, "Initial State for Simulation", true);
        this.gui = gUIPrism;
        this.mf = modulesFile;
        this.initValuesModel = new DefineValuesTable();
        this.initValuesTable = new JTable();
        this.initValuesTable.setModel(this.initValuesModel);
        this.initValuesTable.setSelectionMode(1);
        this.initValuesTable.setCellSelectionEnabled(true);
        this.initValuesTable.setRowHeight(this.getFontMetrics(this.initValuesTable.getFont()).getHeight() + 4);
        this.initialState = values;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.initTable();
        this.initValues();
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.optionCheckBox = new JCheckBox();
        this.topPanel = new JPanel();
        this.innerPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIInitialStatePicker.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.bottomPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.optionCheckBox.setText("Always prompt for initial state on path creation");
        this.optionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIInitialStatePicker.this.optionCheckBoxActionPerformed(actionEvent);
            }
        });
        this.optionCheckBox.getAccessibleContext().setAccessibleName("optionCheckBox");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(new TitledBorder("Initial state"));
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.topPanel.add((Component)this.innerPanel, "Center");
        this.allPanel.add((Component)this.topPanel, "Center");
        this.getContentPane().add((Component)this.allPanel, "Center");
    }

    private void optionCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    public static double log(double d, double d2) {
        return Math.log(d2) / Math.log(d);
    }

    private void initTable() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.initValuesTable);
        this.innerPanel.add(jScrollPane);
        this.innerPanel.setPreferredSize(new Dimension(300, 300));
    }

    private void initValues() {
        if (this.initialState == null) {
            Value value;
            Declaration declaration;
            int n;
            int n2 = this.mf.getNumGlobals();
            for (n = 0; n < n2; ++n) {
                declaration = this.mf.getGlobal(n);
                value = new Value(declaration.getName(), declaration.getType(), "");
                this.initValuesModel.addValue(value);
            }
            n2 = this.mf.getNumModules();
            for (n = 0; n < n2; ++n) {
                Module module = this.mf.getModule(n);
                int n3 = module.getNumDeclarations();
                for (int i = 0; i < n3; ++i) {
                    declaration = module.getDeclaration(i);
                    value = new Value(declaration.getName(), declaration.getType(), "");
                    this.initValuesModel.addValue(value);
                }
            }
        } else {
            for (int i = 0; i < this.initialState.getNumValues(); ++i) {
                Value value = new Value(this.initialState.getName(i), this.initialState.getType(i), this.initialState.getValue(i));
                this.initValuesModel.addValue(value);
            }
        }
    }

    public static Values defineInitalValuesWithDialog(GUIPrism gUIPrism, Values values, ModulesFile modulesFile) {
        return new GUIInitialStatePicker(gUIPrism, values, modulesFile).defineValues();
    }

    public Values defineValues() {
        this.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        return this.initialState;
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        if (this.initValuesTable.getCellEditor() != null) {
            this.initValuesTable.getCellEditor().stopCellEditing();
        }
        String string = "";
        try {
            Values values = new Values();
            for (int i = 0; i < this.initValuesModel.getNumValues(); ++i) {
                string = this.initValuesModel.getValue((int)i).name;
                Comparable<Boolean> comparable = null;
                if (this.initValuesModel.getValue((int)i).type instanceof TypeBool) {
                    String string2 = this.initValuesModel.getValue((int)i).value.toString();
                    if (!string2.equals("true") && !string2.equals("false")) {
                        throw new NumberFormatException();
                    }
                    comparable = new Boolean(string2);
                } else if (this.initValuesModel.getValue((int)i).type instanceof TypeInt) {
                    comparable = new Integer(this.initValuesModel.getValue((int)i).value.toString());
                } else {
                    throw new NumberFormatException();
                }
                values.addValue(string, comparable);
            }
            this.initialState = values;
            this.cancelled = false;
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            this.gui.errorDialog("Invalid number value entered for " + string + " parameter");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class Value {
        String name;
        Type type;
        Object value;

        public Value(String string, Type type, Object object) {
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public String toString() {
            return this.name + "=" + this.value.toString();
        }
    }

    class DefineValuesTable
    extends AbstractTableModel {
        ArrayList<Value> values = new ArrayList();

        public void addValue(Value value) {
            this.values.add(value);
            this.fireTableRowsInserted(this.values.size() - 1, this.values.size() - 1);
        }

        public int getNumValues() {
            return this.values.size();
        }

        public Value getValue(int n) {
            return this.values.get(n);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Value value = this.values.get(n);
            switch (n2) {
                case 0: {
                    return value.name;
                }
                case 1: {
                    return value.type.getTypeString();
                }
                case 2: {
                    return value.value.toString();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                Value value = this.values.get(n);
                String string = (String)object;
                value.value = string;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.values.size(); ++i) {
                Value value = this.values.get(i);
                string = string + value.toString();
                if (i == this.values.size() - 1) continue;
                string = string + ",";
            }
            return string;
        }
    }
}

