/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.PrismException;
import userinterface.GUIPrism;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIProperty;

public class GUIPropertyEditor
extends JDialog
implements ActionListener,
KeyListener {
    private static final int START = 0;
    private static final int CURSOR = 1;
    private static final int END = 2;
    private static int noOpen = 0;
    private GUIPrism parent;
    private GUIMultiProperties props;
    private ModulesFile parsedModel;
    private boolean dispose = false;
    private String id;
    private int propertyInvalidStrategy = 1;
    private JButton andButton;
    private JButton boundedUntilButton;
    private JButton cancelButton;
    private JTextArea commentTextArea;
    private JButton copy;
    private JButton cut;
    private JButton falseButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JButton nextButton;
    private JButton notButton;
    private JButton okayButton;
    private JButton orButton;
    private JButton paste;
    private JTextField propertyText;
    private JButton steadyStateButton;
    private JButton trueButton;
    private JButton untilButton;

    public GUIPropertyEditor(GUIMultiProperties gUIMultiProperties, ModulesFile modulesFile, int n) {
        this(gUIMultiProperties, modulesFile, null, n);
    }

    public GUIPropertyEditor(GUIMultiProperties gUIMultiProperties, ModulesFile modulesFile, GUIProperty gUIProperty, int n) {
        super((Frame)gUIMultiProperties.getGUI(), false);
        this.props = gUIMultiProperties;
        this.parent = gUIMultiProperties.getGUI();
        this.parsedModel = modulesFile;
        this.propertyInvalidStrategy = n;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(this.getParent());
        if (gUIProperty == null) {
            this.id = "new";
            this.propertyText.setText("");
            this.commentTextArea.setText("");
        } else {
            this.id = gUIProperty.getID();
            String string = gUIProperty.getName() != null ? "\"" + gUIProperty.getName() + "\" : " : "";
            this.propertyText.setText(string + gUIProperty.getPropString());
            this.commentTextArea.setText(gUIProperty.getComment());
        }
        this.addActionListeners();
        this.propertyText.setFont(new Font("Monospaced", 0, 12));
        this.setTitle("Property Editor");
    }

    @Override
    public void show() {
        this.setLocation(this.getX() + ++noOpen * 50, this.getY() + noOpen * 50);
        super.show();
    }

    @Override
    public void dispose() {
        --noOpen;
        super.dispose();
    }

    private void addString(String string, int n) {
        if (n == 0) {
            this.propertyText.setText(string + this.propertyText.getText());
            this.propertyText.setCaretPosition(string.length());
        } else if (n == 2) {
            this.propertyText.setText(this.propertyText.getText() + string);
        } else {
            int n2 = this.propertyText.getCaretPosition();
            int n3 = this.propertyText.getText().length();
            String string2 = this.propertyText.getText().substring(0, n2);
            String string3 = this.propertyText.getText().substring(n2, n3);
            this.propertyText.setText(string2 + string + string3);
            this.propertyText.setCaretPosition(string2.length() + string.length());
        }
        this.propertyText.requestFocus();
    }

    private void addString(String string, int n, int n2) {
        int n3 = n == 0 ? 0 : (n == 2 ? this.propertyText.getText().length() : this.propertyText.getCaretPosition());
        this.addString(string, n);
        this.propertyText.setCaretPosition(n3 + n2);
        this.propertyText.requestFocus();
    }

    private void removeCharAt(int n) {
        String string = this.propertyText.getText();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        this.propertyText.setText(string2 + string3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.trueButton) {
            int n = this.propertyText.getCaretPosition();
            if (n > 0 && this.propertyText.getText().charAt(n - 1) == '(') {
                if (this.propertyText.getText().charAt(n) == ')') {
                    this.removeCharAt(n - 1);
                    this.removeCharAt(n - 1);
                    this.propertyText.setCaretPosition(n - 1);
                    this.addString("true", 1);
                    this.propertyText.setCaretPosition(n + 3);
                }
            } else {
                this.propertyText.setCaretPosition(n);
                this.addString("true", 1);
                this.propertyText.setCaretPosition(n + 4);
            }
        } else if (actionEvent.getSource() == this.falseButton) {
            int n = this.propertyText.getCaretPosition();
            if (n > 0 && this.propertyText.getText().charAt(n - 1) == '(') {
                if (this.propertyText.getText().charAt(n) == ')') {
                    this.removeCharAt(n - 1);
                    this.removeCharAt(n - 1);
                    this.propertyText.setCaretPosition(n - 1);
                    this.addString("false", 1);
                    this.propertyText.setCaretPosition(n + 4);
                }
            } else {
                this.propertyText.setCaretPosition(n);
                this.addString("false", 1);
                this.propertyText.setCaretPosition(n + 5);
            }
        } else if (actionEvent.getSource() == this.andButton) {
            if (this.propertyText.getSelectedText() == null) {
                this.addString("() & ()", 1, 1);
            } else {
                int n;
                int n2 = this.propertyText.getSelectionStart();
                int n3 = this.propertyText.getSelectionEnd();
                int n4 = this.propertyText.getSelectedText().length();
                boolean bl = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                for (n = 0; n < n3 - n2; ++n) {
                    if (this.propertyText.getSelectedText().charAt(n) == '(') {
                        ++n5;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) == ')') {
                        ++n6;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) == '[') {
                        ++n7;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) != ']') continue;
                    ++n8;
                }
                if (n5 == n6 && n7 == n8) {
                    bl = true;
                }
                if (bl) {
                    this.propertyText.setCaretPosition(n2);
                    this.addString("(", 1, 0);
                    this.propertyText.setCaretPosition(n3 + 1);
                    this.addString(") & ()", 1, 0);
                    n = this.propertyText.getCaretPosition();
                    boolean bl2 = false;
                    int n9 = n;
                    for (n9 = n; n9 < this.propertyText.getText().length(); ++n9) {
                        if (this.propertyText.getText().charAt(n9) != '(') continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        this.propertyText.setCaretPosition(n9 + 1);
                    }
                }
            }
        } else if (actionEvent.getSource() == this.orButton) {
            if (this.propertyText.getSelectedText() == null) {
                this.addString("() | ()", 1, 1);
            } else {
                int n;
                int n10 = this.propertyText.getSelectionStart();
                int n11 = this.propertyText.getSelectionEnd();
                int n12 = this.propertyText.getSelectedText().length();
                boolean bl = false;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                for (n = 0; n < n11 - n10; ++n) {
                    if (this.propertyText.getSelectedText().charAt(n) == '(') {
                        ++n13;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) == ')') {
                        ++n14;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) == '[') {
                        ++n15;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(n) != ']') continue;
                    ++n16;
                }
                if (n13 == n14 && n15 == n16) {
                    bl = true;
                }
                if (bl) {
                    this.propertyText.setCaretPosition(n10);
                    this.addString("(", 1, 0);
                    this.propertyText.setCaretPosition(n11 + 1);
                    this.addString(") | ()", 1, 0);
                    n = this.propertyText.getCaretPosition();
                    boolean bl3 = false;
                    int n17 = n;
                    for (n17 = n; n17 < this.propertyText.getText().length(); ++n17) {
                        if (this.propertyText.getText().charAt(n17) != '(') continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) {
                        this.propertyText.setCaretPosition(n17 + 1);
                    }
                }
            }
        } else if (actionEvent.getSource() == this.notButton) {
            if (this.propertyText.getSelectedText() == null) {
                this.addString("!()", 1, 2);
            } else {
                int n = this.propertyText.getSelectionStart();
                int n18 = this.propertyText.getSelectionEnd();
                int n19 = this.propertyText.getSelectedText().length();
                boolean bl = false;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                for (int i = 0; i < n18 - n; ++i) {
                    if (this.propertyText.getSelectedText().charAt(i) == '(') {
                        ++n20;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(i) == ')') {
                        ++n21;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(i) == '[') {
                        ++n22;
                        continue;
                    }
                    if (this.propertyText.getSelectedText().charAt(i) != ']') continue;
                    ++n23;
                }
                if (n20 == n21 && n22 == n23) {
                    bl = true;
                }
                if (bl) {
                    this.propertyText.setCaretPosition(n);
                    this.addString("!(", 1, 0);
                    this.propertyText.setCaretPosition(n18 + 2);
                    this.addString(")", 1, 0);
                }
            }
        } else if (actionEvent.getSource() == this.nextButton) {
            int n = this.propertyText.getCaretPosition();
            this.addString("P><p [ X () ]", 1, 1);
            this.propertyText.select(n + 1, n + 4);
        } else if (actionEvent.getSource() == this.untilButton) {
            int n = this.propertyText.getCaretPosition();
            this.addString("P><p [ () U () ]", 1, 1);
            this.propertyText.select(n + 1, n + 4);
        } else if (actionEvent.getSource() == this.boundedUntilButton) {
            int n = this.propertyText.getCaretPosition();
            this.addString("P><p [ () U<=k () ]", 1, 1);
            this.propertyText.select(n + 1, n + 4);
        } else if (actionEvent.getSource() == this.steadyStateButton) {
            int n = this.propertyText.getCaretPosition();
            this.addString("S><p [ () ]", 1, 1);
            this.propertyText.select(n + 1, n + 4);
        } else if (actionEvent.getSource() == this.cut) {
            if (this.propertyText.getSelectedText() != null) {
                this.propertyText.cut();
                this.propertyText.requestFocus();
            }
        } else if (actionEvent.getSource() == this.copy) {
            if (this.propertyText.getSelectedText() != null) {
                this.propertyText.copy();
                this.propertyText.requestFocus();
            }
        } else if (actionEvent.getSource() == this.paste) {
            this.propertyText.paste();
            this.propertyText.requestFocus();
        }
        if (actionEvent.getSource() != this.okayButton && actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.props.cancelProperty(this.id);
            this.dispose();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            int n = this.propertyText.getCaretPosition();
            boolean bl = false;
            boolean bl2 = false;
            int n2 = n;
            for (n2 = n; n2 < this.propertyText.getText().length(); ++n2) {
                if (this.propertyText.getText().charAt(n2) == '(') {
                    bl = true;
                    break;
                }
                if (this.propertyText.getText().charAt(n2) != 'k') continue;
                bl = true;
                bl2 = true;
                break;
            }
            if (bl) {
                if (bl2) {
                    this.propertyText.setCaretPosition(n2);
                    this.propertyText.select(n2, n2 + 1);
                } else {
                    this.propertyText.setCaretPosition(n2 + 1);
                }
            }
        }
        if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
            this.props.cancelProperty(this.id);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void addActionListeners() {
        this.trueButton.addActionListener(this);
        this.falseButton.addActionListener(this);
        this.andButton.addActionListener(this);
        this.orButton.addActionListener(this);
        this.notButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.boundedUntilButton.addActionListener(this);
        this.untilButton.addActionListener(this);
        this.steadyStateButton.addActionListener(this);
        this.propertyText.addKeyListener(this);
        this.addKeyListener(this);
        this.cut.addActionListener(this);
        this.copy.addActionListener(this);
        this.paste.addActionListener(this);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.cut = new JButton();
        this.copy = new JButton();
        this.paste = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.propertyText = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.trueButton = new JButton();
        this.andButton = new JButton();
        this.notButton = new JButton();
        this.untilButton = new JButton();
        this.steadyStateButton = new JButton();
        this.falseButton = new JButton();
        this.orButton = new JButton();
        this.nextButton = new JButton();
        this.boundedUntilButton = new JButton();
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        this.jPanel15 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.commentTextArea = new JTextArea();
        this.jPanel2 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIPropertyEditor.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.cut.setIcon(GUIPrism.getIconFromImage("smallCut.png"));
        this.jToolBar1.add(this.cut);
        this.copy.setIcon(GUIPrism.getIconFromImage("smallCopy.png"));
        this.jToolBar1.add(this.copy);
        this.paste.setIcon(GUIPrism.getIconFromImage("smallPaste.png"));
        this.jToolBar1.add(this.paste);
        this.jPanel6.add((Component)this.jToolBar1, "North");
        this.jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.jPanel7.add((Component)this.jPanel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel7.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.propertyText, gridBagConstraints);
        this.jLabel1.setLabelFor(this.propertyText);
        this.jLabel1.setText("Property:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel7.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.jPanel7.add((Component)this.jPanel8, gridBagConstraints);
        this.trueButton.setText("true");
        this.trueButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.trueButton, gridBagConstraints);
        this.andButton.setText("And");
        this.andButton.setPreferredSize(new Dimension(123, 25));
        this.andButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPropertyEditor.this.andButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.andButton, gridBagConstraints);
        this.notButton.setText("Not");
        this.notButton.setPreferredSize(new Dimension(123, 25));
        this.notButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPropertyEditor.this.notButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.notButton, gridBagConstraints);
        this.untilButton.setText("Until");
        this.untilButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.untilButton, gridBagConstraints);
        this.steadyStateButton.setText("Steady-state");
        this.steadyStateButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.steadyStateButton, gridBagConstraints);
        this.falseButton.setText("false");
        this.falseButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.falseButton, gridBagConstraints);
        this.orButton.setText("Or");
        this.orButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.orButton, gridBagConstraints);
        this.nextButton.setText("Next");
        this.nextButton.setPreferredSize(new Dimension(123, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.nextButton, gridBagConstraints);
        this.boundedUntilButton.setText("Bounded Until");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.jPanel7.add((Component)this.boundedUntilButton, gridBagConstraints);
        this.jPanel7.add((Component)this.jPanel11, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel7.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.jPanel7.add((Component)this.jPanel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        this.jPanel7.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanel15.setPreferredSize(new Dimension(10, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel7.add((Component)this.jPanel15, gridBagConstraints);
        this.jPanel16.setPreferredSize(new Dimension(10, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.jPanel7.add((Component)this.jPanel16, gridBagConstraints);
        this.jLabel2.setText("Comment:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 11;
        this.jPanel7.add((Component)this.jLabel2, gridBagConstraints);
        this.commentTextArea.setRows(3);
        this.jScrollPane1.setViewportView(this.commentTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel6.add((Component)this.jPanel7, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.okayButton.setMnemonic('O');
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIPropertyEditor.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.okayButton);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void andButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void notButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            PropertiesFile propertiesFile = this.props.getPrism().parsePropertiesString(this.parsedModel, this.props.getLabelsString() + "\n" + this.props.getConstantsString());
            n2 = propertiesFile.getConstantList().size();
            n = propertiesFile.getLabelList().size();
            String string = "";
            int n3 = 0;
            for (GUIProperty object2 : this.props.getPropList().getAllNamedProperties()) {
                if (!object2.isValid() || this.id == null || this.id.equals(object2.getID())) continue;
                ++n3;
                string = string + "\"" + object2.getName() + "\" : " + object2.getPropString() + "\n";
            }
            String string2 = this.props.getConstantsString() + "\n" + this.props.getLabelsString() + string + this.propertyText.getText();
            PropertiesFile propertiesFile2 = this.props.getPrism().parsePropertiesString(this.parsedModel, string2);
            if (propertiesFile2.getNumProperties() <= n3) {
                throw new PrismException("Empty property");
            }
            if (propertiesFile2.getNumProperties() > n3 + 1) {
                throw new PrismException("Contains multiple properties");
            }
            if (propertiesFile2.getConstantList().size() != n2) {
                throw new PrismException("Contains constants");
            }
            if (propertiesFile2.getLabelList().size() != n) {
                throw new PrismException("Contains labels");
            }
            bl = true;
        }
        catch (PrismException prismException) {
            switch (this.propertyInvalidStrategy) {
                case 1: {
                    String[] stringArray = new String[]{"Yes", "No"};
                    int n4 = -1;
                    n4 = this.props.optionPane("Error: " + prismException.getMessage() + "\nAre you sure you want to continue?", "Question", 0, 3, stringArray, stringArray[0]);
                    bl = n4 == 0;
                    break;
                }
                case 2: {
                    this.parent.errorDialog("Error: " + prismException.getMessage());
                    bl = false;
                }
            }
        }
        if (bl) {
            this.setVisible(false);
            this.props.changeProperty(this.propertyText.getText(), this.commentTextArea.getText(), this.id);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.props.cancelProperty(this.id);
        this.dispose();
    }
}

