/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.util.Vector;
import javax.swing.ImageIcon;
import param.BigRational;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Interval;
import prism.Prism;
import prism.PrismException;
import prism.Result;
import prism.TileList;
import userinterface.GUIPrism;
import userinterface.properties.GUIPropertiesList;

public class GUIProperty {
    public static final ImageIcon IMAGE_NOT_DONE = GUIPrism.getIconFromImage("smallFilePrism.png");
    public static final ImageIcon IMAGE_DOING = GUIPrism.getIconFromImage("smallClockAnim1.png");
    public static final ImageIcon IMAGE_TICK = GUIPrism.getIconFromImage("smallTick.png");
    public static final ImageIcon IMAGE_CROSS = GUIPrism.getIconFromImage("smallCross.png");
    public static final ImageIcon IMAGE_ERROR = GUIPrism.getIconFromImage("smallError.png");
    public static final ImageIcon IMAGE_INVALID = GUIPrism.getIconFromImage("smallWarning.png");
    public static final ImageIcon IMAGE_NUMBER = GUIPrism.getIconFromImage("smallCompute.png");
    public static final ImageIcon IMAGE_PARETO = GUIPrism.getIconFromImage("smallPareto.png");
    public static final int STATUS_NOT_DONE = 0;
    public static final int STATUS_DOING = 1;
    public static final int STATUS_PARSE_ERROR = 2;
    public static final int STATUS_RESULT_ERROR = 3;
    public static final int STATUS_RESULT_TRUE = 4;
    public static final int STATUS_RESULT_FALSE = 5;
    public static final int STATUS_RESULT_NUMBER = 6;
    public static final int STATUS_RESULT_PARETO = 7;
    private Prism prism;
    private String id;
    private int status;
    private ImageIcon doingImage;
    private boolean beingEdited;
    private String propString;
    private Expression expr;
    private String comment;
    private Result result;
    private int numberOfWarnings;
    private String parseError;
    private String method;
    private String constantsString;
    private String name;
    private Vector<String> referencedNames;
    private GUIPropertiesList propList;

    public GUIProperty(Prism prism, GUIPropertiesList gUIPropertiesList, String string, String string2, String string3, String string4) {
        this.prism = prism;
        this.propList = gUIPropertiesList;
        this.id = string;
        this.status = 0;
        this.doingImage = IMAGE_DOING;
        this.beingEdited = false;
        this.propString = string2;
        this.expr = null;
        this.comment = string4;
        this.name = string3;
        this.result = null;
        this.parseError = "";
        this.method = "<none>";
        this.constantsString = "<none>";
    }

    public String getID() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public ImageIcon getImage() {
        switch (this.status) {
            case 0: {
                return IMAGE_NOT_DONE;
            }
            case 1: {
                return this.doingImage;
            }
            case 2: {
                return IMAGE_INVALID;
            }
            case 3: {
                return IMAGE_ERROR;
            }
            case 4: {
                return IMAGE_TICK;
            }
            case 5: {
                return IMAGE_CROSS;
            }
            case 6: {
                return IMAGE_NUMBER;
            }
            case 7: {
                return IMAGE_PARETO;
            }
        }
        return IMAGE_NOT_DONE;
    }

    public boolean isBeingEdited() {
        return this.beingEdited;
    }

    public String getPropString() {
        return this.propString;
    }

    public String getName() {
        return this.name;
    }

    public Vector<String> getReferencedNames() {
        return this.referencedNames;
    }

    public Expression getProperty() {
        return this.expr;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isValid() {
        return this.expr != null;
    }

    public void makeInvalid() {
        this.expr = null;
        this.referencedNames = null;
    }

    public boolean isValidForSimulation() {
        return this.isValid() && this.prism.isPropertyOKForSimulation(this.expr);
    }

    public Result getResult() {
        return this.result;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public String getResultString() {
        return this.result == null ? "Unknown" : this.result.getResultString();
    }

    public String getToolTipText() {
        switch (this.status) {
            case 1: {
                return "In progress...";
            }
            case 2: {
                return "Invalid property: " + this.parseError;
            }
            case 3: {
                return this.getResultString();
            }
        }
        return "<html>Result: " + this.getResultString().replaceAll("\n", "<br/>") + "</html>";
    }

    public String getConstantsString() {
        return this.constantsString;
    }

    public String getMethodString() {
        return this.method;
    }

    public String toString() {
        return (this.name != null ? "\"" + this.name + "\" : " : "") + this.propString;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setDoingImage(ImageIcon imageIcon) {
        this.doingImage = imageIcon;
    }

    public void setPropStringAndName(String string, String string2, ModulesFile modulesFile, String string3, String string4) {
        this.propString = string;
        this.name = string2;
        this.setStatus(0);
        this.propList.validateProperties();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setBeingEdited(boolean bl) {
        this.beingEdited = bl;
    }

    public void setResult(Result result) {
        this.result = result;
        if (this.result.getResult() instanceof Boolean) {
            if (((Boolean)this.result.getResult()).booleanValue()) {
                this.setStatus(4);
            } else {
                this.setStatus(5);
            }
        } else if (this.result.getResult() instanceof Integer) {
            this.setStatus(6);
        } else if (this.result.getResult() instanceof Double) {
            this.setStatus(6);
        } else if (this.result.getResult() instanceof BigRational) {
            this.setStatus(6);
        } else if (this.result.getResult() instanceof Interval) {
            this.setStatus(6);
        } else if (this.result.getResult() instanceof Exception) {
            this.setStatus(3);
        } else if (this.result.getResult() instanceof TileList) {
            this.setStatus(7);
        } else {
            this.setStatus(0);
            this.result = null;
        }
    }

    public void setNumberOfWarnings(int n) {
        this.numberOfWarnings = n;
    }

    public void setMethodString(String string) {
        this.method = string == null ? "<none>" : string;
    }

    public void setConstants(Values values, Values values2) {
        if (values != null && values.getNumValues() > 0) {
            this.constantsString = values.toString();
            if (values2 != null && values2.getNumValues() > 0) {
                this.constantsString = this.constantsString + ", " + values2.toString();
            }
        } else {
            this.constantsString = values2 != null && values2.getNumValues() > 0 ? values2.toString() : "<none>";
        }
    }

    public void parse(ModulesFile modulesFile, String string, String string2) {
        if (this.propString == null || string == null || string2 == null) {
            this.expr = null;
            this.setStatus(2);
            this.parseError = "(Unexpected) Properties, constants or labels are null";
            return;
        }
        try {
            boolean bl = false;
            PropertiesFile propertiesFile = null;
            try {
                propertiesFile = this.prism.parsePropertiesString(modulesFile, string + "\n" + string2);
            }
            catch (PrismException prismException) {
                bl = true;
            }
            String string3 = "";
            int n = 0;
            for (GUIProperty object2 : this.propList.getAllNamedProperties()) {
                if (!object2.isValid() || this.name != null && this.name.equals(object2.getName())) continue;
                ++n;
                string3 = string3 + "\"" + object2.getName() + "\" : " + object2.getPropString() + "\n";
            }
            String string4 = string + "\n" + string2 + "\n" + string3 + this.propString;
            PropertiesFile propertiesFile2 = this.prism.parsePropertiesString(modulesFile, string4);
            if (propertiesFile2.getNumProperties() <= n) {
                throw new PrismException("Empty Property");
            }
            if (propertiesFile2.getNumProperties() > n + 1) {
                throw new PrismException("Contains Multiple Properties");
            }
            if (!bl) {
                if (propertiesFile2.getConstantList().size() != propertiesFile.getConstantList().size()) {
                    throw new PrismException("Contains constants");
                }
                if (propertiesFile2.getLabelList().size() != propertiesFile.getLabelList().size()) {
                    throw new PrismException("Contains labels");
                }
            } else {
                if (propertiesFile2.getConstantList().size() != 0) {
                    throw new PrismException("Contains constants");
                }
                if (propertiesFile2.getLabelList().size() != 0) {
                    throw new PrismException("Contains labels");
                }
            }
            this.expr = propertiesFile2.getProperty(n);
            this.parseError = "(Unexpected) no error!";
            if (this.getStatus() == 2) {
                this.setStatus(0);
            }
            this.referencedNames = propertiesFile2.getPropertyObject(n).getAllPropRefsRecursively(propertiesFile2);
        }
        catch (PrismException prismException) {
            this.expr = null;
            this.referencedNames = null;
            this.setStatus(2);
            this.parseError = prismException.getMessage();
        }
    }

    public int hashCode() {
        return this.propString != null ? this.propString.length() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GUIProperty)) {
            return false;
        }
        return this.id.equals(((GUIProperty)object).id);
    }
}

