/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.PropertiesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;
import userinterface.properties.GUIConstant;
import userinterface.properties.GUIMultiProperties;

public class GUIPropConstantList
extends JTable {
    private PropConstantModel theModel;
    private GUIMultiProperties parent;

    public GUIPropConstantList(GUIMultiProperties gUIMultiProperties) {
        this.parent = gUIMultiProperties;
        this.theModel = new PropConstantModel();
        this.setModel(this.theModel);
        this.setEditorAndRenderer();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
    }

    protected void setEditorAndRenderer() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(new String("int"));
        jComboBox.addItem(new String("double"));
        jComboBox.addItem(new String("bool"));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(defaultCellEditor);
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), new TheCellRenderer());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void correctEditors() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void newList() {
        this.theModel.newList();
        this.setEditorAndRenderer();
    }

    public int getNumConstants() {
        return this.theModel.getNumConstants();
    }

    public void addNewConstant() {
        this.theModel.addConstant();
        this.theModel.validateConstants();
    }

    public void removeConstant(int n) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        this.theModel.removeConstant(n);
        this.theModel.validateConstants();
    }

    public void addPropertiesFile(PropertiesFile propertiesFile) {
        ConstantList constantList = propertiesFile.getConstantList();
        int n = constantList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = constantList.getConstant(i);
            this.theModel.addConstant(new GUIConstant(this.parent, constantList.getConstantName(i), expression == null ? "" : expression.toString(), constantList.getConstantType(i)));
        }
        this.theModel.validateConstants();
    }

    public void validateConstants() {
        this.theModel.validateConstants();
    }

    public boolean isConstantListValid() {
        if (this.theModel.error != null) {
            return false;
        }
        int n = this.theModel.getNumConstants();
        for (int i = 0; i < n; ++i) {
            if (this.theModel.getConstant(i).isParseable()) continue;
            return false;
        }
        return true;
    }

    public String getConstantsString() {
        return this.theModel.toString();
    }

    public String getValidConstantsString() {
        return this.theModel.validToString();
    }

    class TheCellRenderer
    extends DefaultTableCellRenderer {
        TheCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GUIConstant gUIConstant = GUIPropConstantList.this.theModel.getConstant(n);
            if (!gUIConstant.isParseable()) {
                this.setBackground(bl ? GUIPropConstantList.this.parent.getSelectionColor() : GUIPropConstantList.this.parent.getWarningColor());
                this.setForeground(Color.red);
                this.setToolTipText(gUIConstant.parseError.toString());
            } else if (((GUIPropConstantList)GUIPropConstantList.this).theModel.error != null) {
                this.setBackground(bl ? GUIPropConstantList.this.parent.getSelectionColor() : GUIPropConstantList.this.parent.getWarningColor());
                this.setForeground(Color.red);
                this.setToolTipText(((GUIPropConstantList)GUIPropConstantList.this).theModel.error.toString());
            } else {
                this.setBackground(bl ? GUIPropConstantList.this.parent.getSelectionColor() : Color.white);
                this.setForeground(Color.black);
                this.setToolTipText(gUIConstant.toString());
            }
            return component;
        }
    }

    class PropConstantModel
    extends AbstractTableModel {
        ArrayList constants = new ArrayList();
        int conCount = 0;
        Exception error = null;

        public int getNumConstants() {
            return this.constants.size();
        }

        public GUIConstant getConstant(int n) {
            return (GUIConstant)this.constants.get(n);
        }

        public Exception getError() {
            return this.error;
        }

        @Override
        public int getRowCount() {
            return this.constants.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GUIConstant gUIConstant = this.getConstant(n);
            switch (n2) {
                case 0: {
                    return gUIConstant.name;
                }
                case 1: {
                    return gUIConstant.type.getTypeString();
                }
                case 2: {
                    return gUIConstant.constant;
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.getNumConstants(); ++i) {
                GUIConstant gUIConstant = this.getConstant(i);
                string = string + gUIConstant.toString() + "\n";
            }
            return string;
        }

        public String validToString() {
            if (this.error != null) {
                return "";
            }
            return this.parseableToString();
        }

        public String parseableToString() {
            String string = "";
            int n = this.getNumConstants();
            for (int i = 0; i < n; ++i) {
                GUIConstant gUIConstant = this.getConstant(i);
                if (!gUIConstant.isParseable()) continue;
                string = string + gUIConstant.toString() + "\n";
            }
            return string;
        }

        public void newList() {
            this.constants = new ArrayList();
            this.fireTableStructureChanged();
            GUIPropConstantList.this.parent.constantListChanged();
        }

        public void addConstant() {
            this.addConstant(new GUIConstant(GUIPropConstantList.this.parent, "C" + this.conCount, "", TypeInt.getInstance()));
            ++this.conCount;
        }

        public void addConstant(GUIConstant gUIConstant) {
            gUIConstant.parse();
            this.constants.add(gUIConstant);
            this.fireTableRowsInserted(this.constants.size() - 1, this.constants.size() - 1);
            GUIPropConstantList.this.parent.constantListChanged();
        }

        public void removeConstant(int n) {
            this.constants.remove(n);
            this.fireTableRowsDeleted(n, n);
            GUIPropConstantList.this.parent.constantListChanged();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            GUIConstant gUIConstant = this.getConstant(n);
            switch (n2) {
                case 0: {
                    if (gUIConstant.name.equals((String)object)) break;
                    gUIConstant.name = (String)object;
                    gUIConstant.parse();
                    this.validateConstants();
                    GUIPropConstantList.this.parent.constantListChanged();
                    break;
                }
                case 1: {
                    Type type = TypeInt.getInstance();
                    if (((String)object).equals("double")) {
                        type = TypeDouble.getInstance();
                    } else if (((String)object).equals("bool")) {
                        type = TypeBool.getInstance();
                    }
                    if (type == gUIConstant.type) break;
                    gUIConstant.type = type;
                    gUIConstant.parse();
                    this.validateConstants();
                    GUIPropConstantList.this.parent.constantListChanged();
                    break;
                }
                case 2: {
                    if (gUIConstant.constant.equals((String)object)) break;
                    gUIConstant.constant = (String)object;
                    gUIConstant.parse();
                    this.validateConstants();
                    GUIPropConstantList.this.parent.constantListChanged();
                }
            }
        }

        public void validateConstants() {
            try {
                this.error = null;
                GUIPropConstantList.this.parent.getPrism().parsePropertiesString(GUIPropConstantList.this.parent.getParsedModel(), this.parseableToString());
            }
            catch (PrismException prismException) {
                this.error = prismException;
            }
            this.fireTableDataChanged();
        }
    }
}

