/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.data.xy.XYDataItem;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.Type;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeInterval;
import prism.Point;
import prism.PrismException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import prism.TileList;
import prism.UndefinedConstants;
import simulator.PathFullInfo;
import userinterface.GUIClipboardEvent;
import userinterface.GUIConstantsPicker;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.GUISimulationPicker;
import userinterface.OptionsPanel;
import userinterface.SimulationInformation;
import userinterface.graph.Graph;
import userinterface.model.GUIModelEvent;
import userinterface.model.computation.ExportBuiltModelThread;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIExperimentPicker;
import userinterface.properties.GUIExperimentTable;
import userinterface.properties.GUIGraphHandler;
import userinterface.properties.GUIGraphPicker;
import userinterface.properties.GUIPropConstantList;
import userinterface.properties.GUIPropLabelList;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.properties.GUIPropertiesList;
import userinterface.properties.GUIProperty;
import userinterface.properties.GUIPropertyEditor;
import userinterface.properties.GUIPropertyResultDialog;
import userinterface.properties.GUIResultsTable;
import userinterface.properties.computation.ExportResultsThread;
import userinterface.properties.computation.LoadPropertiesThread;
import userinterface.properties.computation.ModelCheckThread;
import userinterface.properties.computation.SimulateModelCheckThread;
import userinterface.simulator.GUISimulator;
import userinterface.util.GUIComputationEvent;
import userinterface.util.GUIEvent;
import userinterface.util.GUIExitEvent;
import userinterface.util.GUIPrismFileFilter;

public class GUIMultiProperties
extends GUIPlugin
implements MouseListener,
ListSelectionListener,
PrismSettingsListener,
ContainerListener {
    public static final int CONTINUE = 0;
    public static final int CANCEL = 1;
    public static final int WARN_INVALID_PROPS = 1;
    public static final int NEVER_INVALID_PROPS = 2;
    private ModulesFile parsedModel;
    private Values mfConstants;
    private boolean modified;
    private boolean computing;
    private boolean verifyAfterReceiveParseNotification;
    private boolean experimentAfterReceiveParseNotification;
    private boolean simulateAfterReceiveParseNotification;
    private boolean exportLabelsAfterReceiveParseNotification;
    private PropertiesFile parsedProperties;
    private ArrayList<GUIProperty> propertiesToBeVerified;
    private File activeFile;
    private Values pfConstants;
    private String argsPropertiesFile;
    private int exportType = 1;
    private File exportFile = null;
    private GUIPrismFileFilter[] propsFilter;
    private GUIPrismFileFilter[] resultsFilter;
    private GUIPrismFileFilter[] textFilter;
    private GUIPrismFileFilter[] matlabFilter;
    private JMenu propMenu;
    private JPopupMenu propertiesPopup;
    private JPopupMenu constantsPopup;
    private JPopupMenu labelsPopup;
    private JPopupMenu experimentPopup;
    private GUIExperimentTable experiments;
    private GUIGraphHandler graphHandler;
    private JScrollPane expScroller;
    private JTextField fileTextField;
    private Action newProps;
    private Action openProps;
    private Action saveProps;
    private Action savePropsAs;
    private Action insertProps;
    private Action verifySelected;
    private Action newProperty;
    private Action editProperty;
    private Action newConstant;
    private Action removeConstant;
    private Action newLabel;
    private Action removeLabel;
    private Action newExperiment;
    private Action deleteExperiment;
    private Action stopExperiment;
    private Action parametric;
    private Action viewResults;
    private Action plotResults;
    private Action exportResultsListText;
    private Action exportResultsListCSV;
    private Action exportResultsMatrixText;
    private Action exportResultsMatrixCSV;
    private Action simulate;
    private Action details;
    private Action exportLabelsPlain;
    private Action exportLabelsMatlab;
    private GUIPropertiesList propList;
    private GUIPropConstantList consTable;
    private GUIPropLabelList labTable;
    private Font displayFontFast;
    private Color backgroundFast;
    private Color warningFast;
    private GUISimulator simulator;
    JScrollPane constantsScroll;
    JScrollPane labelsScroll;
    JTextArea comLabel;

    public GUIMultiProperties(GUIPrism gUIPrism, GUISimulator gUISimulator) {
        super(gUIPrism);
        this.simulator = gUISimulator;
        gUISimulator.setGUIProb(this);
        this.initComponents();
        this.a_newList();
        this.setParsedModel(null);
        this.doEnables();
    }

    @Override
    public void takeCLArgs(String[] stringArray) {
        if (stringArray.length > 1) {
            this.argsPropertiesFile = stringArray[1];
        }
    }

    public ModulesFile getParsedModel() {
        return this.parsedModel;
    }

    public String getConstantsString() {
        return this.consTable.getValidConstantsString();
    }

    public String getLabelsString() {
        return this.labTable.getValidLabelsString();
    }

    public int getNumConstants() {
        return this.consTable.getRowCount();
    }

    public int getNumLabels() {
        return this.labTable.getRowCount();
    }

    public Font getListFont() {
        return this.displayFontFast;
    }

    public Color getWarningColor() {
        return this.warningFast;
    }

    public Color getSelectionColor() {
        return this.backgroundFast;
    }

    public int getInvalidPropertyStrategy() {
        return this.getPrism().getSettings().getInteger("properties.additionStategy") + 1;
    }

    public GUIGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    public void repaintList() {
        this.propList.repaint();
    }

    protected void verifyAfterParse() {
        this.verifyAfterReceiveParseNotification = false;
        try {
            int n;
            String string = this.getLabelsString() + "\n" + this.getConstantsString() + "\n" + this.propList.getValidSelectedAndReferencedString();
            this.parsedProperties = this.getPrism().parsePropertiesString(this.parsedModel, string);
            ArrayList<GUIProperty> arrayList = this.propList.getValidSelectedProperties();
            int n2 = this.parsedProperties.getNumProperties();
            ArrayList<Property> arrayList2 = new ArrayList<Property>(n2);
            for (n = 0; n < n2; ++n) {
                arrayList2.add(this.parsedProperties.getPropertyObject(n));
            }
            UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, this.parsedProperties, arrayList2);
            if (undefinedConstants.getMFNumUndefined() + undefinedConstants.getPFNumUndefined() > 0 && (n = GUIConstantsPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, this.mfConstants, this.pfConstants)) != 1) {
                return;
            }
            this.mfConstants = undefinedConstants.getMFConstantValues();
            this.pfConstants = undefinedConstants.getPFConstantValues();
            this.getPrism().setPRISMModelConstants(this.mfConstants);
            this.parsedProperties.setSomeUndefinedConstants(this.pfConstants);
            this.propertiesToBeVerified = arrayList;
            for (GUIProperty gUIProperty : this.propertiesToBeVerified) {
                gUIProperty.setConstants(this.mfConstants, this.pfConstants);
            }
            ModelCheckThread modelCheckThread = new ModelCheckThread(this, this.parsedProperties, this.propertiesToBeVerified);
            modelCheckThread.setPriority(5);
            modelCheckThread.start();
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            return;
        }
    }

    public void simulateAfterParse() {
        int n;
        ArrayList<GUIProperty> arrayList;
        this.simulateAfterReceiveParseNotification = false;
        try {
            this.parsedProperties = this.getPrism().parsePropertiesString(this.parsedModel, this.getLabelsString() + "\n" + this.getConstantsString() + "\n" + this.propList.getValidSelectedAndReferencedString());
            arrayList = this.propList.getValidSelectedProperties();
            if (arrayList.size() == 0) {
                this.error("None of the selected properties are suitable for simulation");
                return;
            }
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            return;
        }
        ArrayList<GUIProperty> arrayList2 = new ArrayList<GUIProperty>();
        ArrayList<Property> arrayList3 = new ArrayList<Property>();
        ArrayList<Expression> arrayList4 = new ArrayList<Expression>();
        for (n = 0; n < arrayList.size(); ++n) {
            GUIProperty object2 = arrayList.get(n);
            if (!this.getPrism().isPropertyOKForSimulation(object2.getProperty())) continue;
            arrayList2.add(object2);
            arrayList3.add(this.parsedProperties.getPropertyObject(n));
            arrayList4.add(object2.getProperty());
        }
        if (arrayList2.size() == 0) {
            this.error("None of the selected properties are suitable for simulation");
            return;
        }
        if (arrayList2.size() < arrayList.size() && (n = this.questionYesNo("Warning", "Warning: Some of the selected properties are not suitable for simulation. Continue?")) != 0) {
            return;
        }
        try {
            UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, this.parsedProperties, arrayList3);
            if (undefinedConstants.getMFNumUndefined() + undefinedConstants.getPFNumUndefined() > 0 && (n = GUIConstantsPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, this.mfConstants, this.pfConstants)) != 1) {
                return;
            }
            this.mfConstants = undefinedConstants.getMFConstantValues();
            this.pfConstants = undefinedConstants.getPFConstantValues();
            this.getPrism().setPRISMModelConstants(this.mfConstants);
            this.parsedProperties.setSomeUndefinedConstants(this.pfConstants);
            for (GUIProperty gUIProperty : arrayList2) {
                gUIProperty.setConstants(this.mfConstants, this.pfConstants);
            }
            this.propertiesToBeVerified = arrayList;
            for (GUIProperty gUIProperty : this.propertiesToBeVerified) {
                gUIProperty.setConstants(this.mfConstants, this.pfConstants);
            }
            SimulationInformation simulationInformation = GUISimulationPicker.defineSimulationWithDialog(this.getGUI(), arrayList4, this.parsedModel, null);
            if (simulationInformation == null) {
                return;
            }
            if (this.parsedModel != null && this.parsedProperties != null) {
                SimulateModelCheckThread simulateModelCheckThread = new SimulateModelCheckThread(this, this.parsedProperties, arrayList2, this.pfConstants, simulationInformation);
                simulateModelCheckThread.setPriority(5);
                simulateModelCheckThread.start();
            }
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            return;
        }
    }

    public void experimentAfterParse() {
        GUIGraphPicker gUIGraphPicker;
        Type type;
        this.experimentAfterReceiveParseNotification = false;
        GUIProperty gUIProperty = this.propList.getProperty(this.propList.getSelectedIndex());
        try {
            this.parsedProperties = this.getPrism().parsePropertiesString(this.parsedModel, this.getLabelsString() + "\n" + this.getConstantsString() + "\n" + this.propList.getValidSelectedAndReferencedString());
            if (this.parsedProperties.getNumProperties() <= 0) {
                this.error("There are no properties selected");
                return;
            }
            if (this.propList.getNumSelectedProperties() > 1) {
                this.error("Experiments can only be created for a single property");
                return;
            }
            int n = this.parsedProperties.getNumProperties() - 1;
            type = this.parsedProperties.getProperty(n).getType();
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < this.parsedProperties.getNumProperties(); ++i) {
            arrayList.add(this.parsedProperties.getPropertyObject(i));
        }
        UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, this.parsedProperties, arrayList);
        boolean bl = false;
        boolean bl2 = false;
        if (undefinedConstants.getMFNumUndefined() + undefinedConstants.getPFNumUndefined() == 0) {
            this.error("Cannot create an experiment because there are no constants with undefined values");
            return;
        }
        boolean bl3 = type instanceof TypeInt || type instanceof TypeDouble || type instanceof TypeInterval;
        int n = GUIExperimentPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, bl3, gUIProperty.isValidForSimulation());
        if (n == 3 || n == 4) {
            bl = true;
        } else if (n == 2) {
            return;
        }
        if (n == 5 || n == 4) {
            bl2 = true;
        }
        if (bl2) {
            try {
                this.getPrism().checkPropertyForSimulation(gUIProperty.getProperty());
            }
            catch (PrismException prismException) {
                this.error("Property is not suitable for simulation: " + prismException.getMessage());
                return;
            }
        }
        if (bl && undefinedConstants.getRangingConstants().size() == 0) {
            this.message("Cannot create a graph since there is only a single result.");
            bl = false;
        }
        int n2 = this.experiments.newExperiment(this.parsedProperties, undefinedConstants, bl2);
        boolean bl4 = true;
        if (bl && (gUIGraphPicker = new GUIGraphPicker(this.getGUI(), this, this.experiments.getExperiment(n2), this.graphHandler, false)).isGraphCancelled() && this.questionYesNo((Object)"Do you want to cancel the experiment completely?", 0) == 0) {
            bl4 = false;
        }
        if (bl4) {
            this.experiments.startExperiment(n2);
        }
    }

    public void propertyLoadSuccessful(PropertiesFile propertiesFile, File file) {
        this.consTable.newList();
        this.consTable.addPropertiesFile(propertiesFile);
        this.labTable.newList();
        this.labTable.addPropertiesFile(propertiesFile);
        this.propList.deleteAll();
        this.propList.addPropertiesFile(propertiesFile);
        this.tabToFront();
        this.setModified(false);
        this.setActiveFile(file);
        this.notifyEventListeners(new GUIPropertiesEvent(5));
    }

    public void propertyInsertSuccessful(PropertiesFile propertiesFile) {
        this.propList.addPropertiesFile(propertiesFile);
        this.consTable.addPropertiesFile(propertiesFile);
        this.labTable.addPropertiesFile(propertiesFile);
        this.tabToFront();
        this.setModified(true);
    }

    public void propertySaveSuccessful(File file) {
        this.setActiveFile(file);
        this.setModified(false);
    }

    public void changeProperty(String string, String string2, String string3) {
        int n = this.propList.getIndexOf(string3);
        if (n < 0) {
            if (string != null) {
                this.propList.addProperty(string, string2);
                this.setModified(true);
            }
        } else {
            GUIProperty gUIProperty = this.propList.getProperty(n);
            gUIProperty.setBeingEdited(false);
            if (string != null) {
                if (string.matches("\"[^\"]*\"[ ]*:.*")) {
                    int n2 = string.indexOf(34) + 1;
                    int n3 = string.indexOf(34, n2);
                    String string4 = string.substring(n2, n3);
                    int n4 = string.indexOf(58) + 1;
                    string = string.substring(n4).trim();
                    gUIProperty.setPropStringAndName(string, string4, this.parsedModel, this.getConstantsString(), this.getLabelsString());
                } else {
                    gUIProperty.setPropStringAndName(string, null, this.parsedModel, this.getConstantsString(), this.getLabelsString());
                }
                gUIProperty.setComment(string2);
                this.setModified(true);
            }
            this.repaintList();
        }
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
        this.updateCommentLabel();
    }

    public void cancelProperty(String string) {
        int n = this.propList.getIndexOf(string);
        if (n >= 0) {
            GUIProperty gUIProperty = this.propList.getProperty(n);
            gUIProperty.setBeingEdited(false);
            this.repaintList();
        }
    }

    public void constantListChanged() {
        this.labTable.validateLabels();
        this.consTable.validateConstants();
        this.propList.validateProperties();
        this.setModified(true);
    }

    public void labelListChanged() {
        this.propList.validateProperties();
        this.setModified(true);
    }

    protected void setModified(boolean bl) {
        this.modified = bl;
        this.setActiveFileLabel();
        if (this.modified) {
            this.doEnables();
            this.notifyEventListeners(new GUIPropertiesEvent(5));
        }
    }

    protected void setComputing(boolean bl) {
        this.computing = bl;
        this.doEnables();
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
    }

    protected void setActiveFile(File file) {
        this.activeFile = file;
        this.setActiveFileLabel();
    }

    protected void setActiveFileLabel() {
        this.fileTextField.setText("Properties list: " + (this.activeFile == null ? "<Untitled>" : this.activeFile.getPath()) + (this.modified ? "*" : ""));
    }

    protected void setParsedModel(ModulesFile modulesFile) {
        this.parsedModel = modulesFile;
        this.consTable.validateConstants();
        this.propList.validateProperties();
        this.doEnables();
    }

    protected void doEnables() {
        this.setEnabled(true);
        this.setTabEnabled(true);
        this.newProps.setEnabled(!this.computing);
        this.openProps.setEnabled(!this.computing);
        this.insertProps.setEnabled(!this.computing);
        this.saveProps.setEnabled(!this.computing);
        this.savePropsAs.setEnabled(!this.computing);
        this.simulate.setEnabled(!this.computing && this.parsedModel != null && this.propList.existsValidSimulatableSelectedProperties());
        this.verifySelected.setEnabled(!this.computing && this.parsedModel != null && this.propList.existsValidSelectedProperties());
        this.exportLabelsPlain.setEnabled(!this.computing && this.parsedModel != null);
        this.exportLabelsMatlab.setEnabled(!this.computing && this.parsedModel != null);
        this.details.setEnabled(!this.computing && this.parsedModel != null && this.propList.existsValidSelectedProperties());
        this.propList.setEnabled(!this.computing);
        this.newProperty.setEnabled(!this.computing);
        this.editProperty.setEnabled(!this.computing && this.propList.getSelectedProperties().size() > 0);
        this.consTable.setEnabled(!this.computing);
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.labTable.setEnabled(!this.computing);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
        this.newExperiment.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
        this.parametric.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
        this.deleteExperiment.setEnabled(this.experiments.getSelectedRowCount() > 0);
        this.viewResults.setEnabled(this.experiments.getSelectedRowCount() > 0);
        if (this.experiments.getSelectedRowCount() == 1) {
            GUIExperiment gUIExperiment = this.experiments.getExperiment(this.experiments.getSelectedRow());
            Type type = gUIExperiment.getPropertyType();
            this.plotResults.setEnabled(type instanceof TypeInt || type instanceof TypeDouble || type instanceof TypeInterval);
        } else {
            this.plotResults.setEnabled(false);
        }
        this.exportResultsListText.setEnabled(this.experiments.getSelectedRowCount() > 0);
        this.exportResultsListCSV.setEnabled(this.experiments.getSelectedRowCount() > 0);
        this.exportResultsMatrixText.setEnabled(this.experiments.getSelectedRowCount() > 0);
        this.exportResultsMatrixCSV.setEnabled(this.experiments.getSelectedRowCount() > 0);
    }

    public int doModificationCheck() {
        if (this.modified) {
            if (this.activeFile == null) {
                String[] stringArray = new String[]{"Yes", "No", "Cancel"};
                int n = -1;
                n = this.optionPane("Properties list has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
                switch (n) {
                    case 0: {
                        return this.a_save();
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 1;
            }
            String[] stringArray = new String[]{"Yes", "No", "Save As...", "Cancel"};
            int n = -1;
            n = this.optionPane("Properties list has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
            switch (n) {
                case 0: {
                    return this.a_save();
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return this.a_saveAs();
                }
                case 3: {
                    return 1;
                }
            }
            return 1;
        }
        return 0;
    }

    private void updateCommentLabel() {
        ArrayList<GUIProperty> arrayList = this.propList.getSelectedProperties();
        if (arrayList.size() == 1) {
            GUIProperty gUIProperty = arrayList.get(0);
            this.comLabel.setText(gUIProperty.getComment());
        } else {
            this.comLabel.setText("");
        }
    }

    public void a_newList() {
        if (this.doModificationCheck() != 0) {
            return;
        }
        this.propList.deleteAll();
        this.consTable.newList();
        this.labTable.newList();
        this.setModified(false);
        this.setActiveFile(null);
        this.doEnables();
        this.notifyEventListeners(new GUIPropertiesEvent(5));
    }

    public void a_open() {
        if (this.doModificationCheck() != 0) {
            return;
        }
        if (this.showOpenFileDialog(this.propsFilter, this.propsFilter[0]) == 0) {
            File file = this.getChooserFile();
            if (file == null) {
                this.error("No file selected");
                return;
            }
            LoadPropertiesThread loadPropertiesThread = new LoadPropertiesThread(this, this.parsedModel, file);
            loadPropertiesThread.setPriority(5);
            loadPropertiesThread.start();
        }
    }

    public int a_save() {
        if (this.activeFile == null) {
            return this.a_saveAs();
        }
        if (!this.propList.allPropertiesAreValid()) {
            this.message("Cannot save properties list: some properties are invalid");
            return 1;
        }
        try {
            this.setTaskBarText("Saving properties...");
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.activeFile));
            printWriter.print(this.propList.toFileString(this.activeFile, this.consTable, this.labTable));
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.setTaskBarText("Saving properties... error.");
            this.error("Could not save to file \"" + this.activeFile + "\"");
            return 1;
        }
        this.setTaskBarText("Saving properties... done.");
        this.propertySaveSuccessful(this.activeFile);
        return 0;
    }

    public int a_saveAs() {
        if (!this.propList.allPropertiesAreValid()) {
            this.message("Cannot save properties list: some properties are invalid");
            return 1;
        }
        if (!this.consTable.isConstantListValid()) {
            this.message("Cannot save properties list: some constants are invalid");
            return 1;
        }
        if (this.showSaveFileDialog(this.propsFilter, this.propsFilter[0]) == 0) {
            File file = this.getChooserFile();
            try {
                this.setTaskBarText("Saving properties...");
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                printWriter.print(this.propList.toFileString(file, this.consTable, this.labTable));
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                this.setTaskBarText("Saving properties... error.");
                this.error("Could not save to file \"" + file + "\"");
                return 1;
            }
            this.setTaskBarText("Saving properties... done.");
            this.propertySaveSuccessful(file);
            return 0;
        }
        return 1;
    }

    public void a_insert() {
        File file;
        if (this.showOpenFileDialog(this.propsFilter, this.propsFilter[0]) == 0) {
            file = this.getChooserFile();
            if (file == null) {
                this.error("No file selected");
                return;
            }
        } else {
            return;
        }
        LoadPropertiesThread loadPropertiesThread = new LoadPropertiesThread(this, this.parsedModel, file, true);
        loadPropertiesThread.setPriority(5);
        loadPropertiesThread.start();
    }

    public void a_simulateSelected() {
        this.consTable.correctEditors();
        this.labTable.correctEditors();
        if (!this.propList.existsValidSimulatableSelectedProperties()) {
            this.error("None of the selected properties are suitable for simulation");
            return;
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.simulateAfterReceiveParseNotification = true;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    public void a_detailSelected() {
        int[] nArray = this.propList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            GUIProperty gUIProperty = this.propList.getProperty(nArray[i]);
            if (gUIProperty.isBeingEdited()) continue;
            gUIProperty.setBeingEdited(true);
            this.repaintList();
            new GUIPropertyResultDialog((Frame)this.getGUI(), this, gUIProperty).display();
        }
    }

    public void a_verifySelected() {
        this.consTable.correctEditors();
        this.labTable.correctEditors();
        if (!this.propList.existsValidSelectedProperties()) {
            this.error("None of the selected properties are suitable for verification. The model was not built");
            return;
        }
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.verifyAfterReceiveParseNotification = true;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a_verifyDone() {
        Object object;
        GUIProperty gUIProperty;
        Object object2;
        int[] nArray = this.propList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            object2 = this.propList.getProperty(nArray[i]);
            if (((GUIProperty)object2).isBeingEdited()) continue;
            ((GUIProperty)object2).setBeingEdited(true);
            this.repaintList();
            new GUIPropertyResultDialog((Frame)this.getGUI(), this, (GUIProperty)object2).display();
        }
        if (nArray.length == 1 && (object2 = (gUIProperty = this.propList.getProperty(nArray[0])).getResult().getCounterexample()) != null && object2 instanceof PathFullInfo && this.questionYesNo("Question", object = "Do you want to view a witness/counterexample for the property in the simulator?", 0) == 0) {
            this.simulator.a_loadPath((PathFullInfo)object2);
            this.simulator.tabToFront();
        }
        List<TileList> list = TileList.getStoredTileLists();
        synchronized (list) {
            for (int i = 0; i < TileList.getStoredTileLists().size(); ++i) {
                object = TileList.getStoredTileLists().get(i);
                if (object == null || ((TileList)object).getDimension() != 2) continue;
                Graph graph = new Graph(TileList.getStoredFormulas().get(i).toString());
                graph.getXAxisSettings().setHeading(TileList.getStoredFormulasX().get(i).toString());
                graph.getYAxisSettings().setHeading(TileList.getStoredFormulasY().get(i).toString());
                Graph.SeriesKey seriesKey = graph.addSeries("Pareto curve");
                List<Point> list2 = ((TileList)object).getPoints();
                Comparator<Point> comparator = new Comparator<Point>(){

                    @Override
                    public int compare(Point point, Point point2) {
                        if (point.getCoord(0) == point2.getCoord(0)) {
                            return Double.compare(point.getCoord(1), point2.getCoord(1));
                        }
                        return Double.compare(point.getCoord(0), point2.getCoord(0));
                    }
                };
                Collections.sort(list2, comparator);
                for (Point point : list2) {
                    Point point2 = point.toRealProperties(((TileList)object).getOpsAndBoundsList());
                    XYDataItem xYDataItem = new XYDataItem(point2.getCoord(0), point2.getCoord(1));
                    graph.addPointToSeries(seriesKey, xYDataItem);
                }
                this.getGraphHandler().addGraph(graph);
            }
            TileList.clearStoredTileLists();
        }
    }

    public void a_cut() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new GUIClipboardProperties(this.propList.getSelectedProperties()), null);
        this.a_delete();
    }

    public void a_copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new GUIClipboardProperties(this.propList.getSelectedProperties()), null);
    }

    public void a_paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            if (transferable.isDataFlavorSupported(GUIMultiProperties.getGUIClipboardPropertiesDataFlavor())) {
                try {
                    GUIClipboardProperties gUIClipboardProperties = (GUIClipboardProperties)transferable.getTransferData(GUIMultiProperties.getGUIClipboardPropertiesDataFlavor());
                    ArrayList<GUIProperty> arrayList = gUIClipboardProperties.getProperties();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        GUIProperty gUIProperty = arrayList.get(i);
                        this.propList.addProperty(gUIProperty.getName(), gUIProperty.getPropString(), gUIProperty.getComment());
                        this.setModified(true);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {}
            } else {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.propList.pastePropertiesString(string);
                    this.setModified(true);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void a_delete() {
        this.propList.deleteSelected();
        this.setModified(true);
    }

    public void a_deleteAll() {
        this.propList.deleteAll();
        this.setModified(true);
    }

    public void a_newProperty() {
        GUIPropertyEditor gUIPropertyEditor = new GUIPropertyEditor(this, this.parsedModel, this.getInvalidPropertyStrategy());
        gUIPropertyEditor.show();
    }

    public void a_editProperty() {
        int[] nArray = this.propList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            GUIProperty gUIProperty = this.propList.getProperty(nArray[i]);
            if (gUIProperty.isBeingEdited()) continue;
            gUIProperty.setBeingEdited(true);
            this.repaintList();
            GUIPropertyEditor gUIPropertyEditor = new GUIPropertyEditor(this, this.parsedModel, gUIProperty, this.getInvalidPropertyStrategy());
            gUIPropertyEditor.show();
        }
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
    }

    public void a_selectAll() {
        this.propList.selectAll();
    }

    public void a_addConstant() {
        this.consTable.addNewConstant();
    }

    public void a_removeSelectedConstants() {
        while (this.consTable.getSelectedRowCount() > 0) {
            this.consTable.removeConstant(this.consTable.getSelectedRow());
        }
    }

    public void a_addLabel() {
        this.labTable.addNewLabel();
    }

    public void a_removeSelectedLabels() {
        while (this.labTable.getSelectedRowCount() > 0) {
            this.labTable.removeLabel(this.labTable.getSelectedRow());
        }
    }

    public void a_exportLabels(int n) {
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = this.showSaveFileDialog(this.matlabFilter, this.matlabFilter[0]);
                break;
            }
            default: {
                n2 = this.showSaveFileDialog(this.textFilter, this.textFilter[1]);
            }
        }
        if (n2 != 0) {
            return;
        }
        this.consTable.correctEditors();
        this.labTable.correctEditors();
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.exportLabelsAfterReceiveParseNotification = true;
        this.exportType = n;
        this.exportFile = this.getChooserFile();
        this.exportLabelsAfterReceiveParseNotification = true;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    public void exportLabelsAfterParse() {
        this.exportLabelsAfterReceiveParseNotification = false;
        try {
            int n;
            this.parsedProperties = this.getPrism().parsePropertiesString(this.parsedModel, this.getLabelsString() + "\n" + this.getConstantsString());
            UndefinedConstants undefinedConstants = new UndefinedConstants(this.parsedModel, this.parsedProperties, true);
            if (undefinedConstants.getMFNumUndefined() + undefinedConstants.getPFNumUndefined() > 0 && (n = GUIConstantsPicker.defineConstantsWithDialog(this.getGUI(), undefinedConstants, this.mfConstants, this.pfConstants)) != 1) {
                return;
            }
            this.mfConstants = undefinedConstants.getMFConstantValues();
            this.pfConstants = undefinedConstants.getPFConstantValues();
            this.getPrism().setPRISMModelConstants(this.mfConstants);
            this.parsedProperties.setSomeUndefinedConstants(this.pfConstants);
            if (this.exportFile == null) {
                this.logToFront();
            }
            ExportBuiltModelThread exportBuiltModelThread = new ExportBuiltModelThread(this, 5, this.exportType, this.exportFile);
            exportBuiltModelThread.setPropertiesFile(this.parsedProperties);
            exportBuiltModelThread.start();
        }
        catch (PrismException prismException) {
            this.error(prismException.getMessage());
            return;
        }
    }

    public void a_newExperiment() {
        this.getPrism().getMainLog().resetNumberOfWarnings();
        this.experimentAfterReceiveParseNotification = true;
        this.notifyEventListeners(new GUIPropertiesEvent(1));
    }

    public void a_stopExperiment() {
        this.experiments.stop();
    }

    public void a_deleteExperiment() {
        this.experiments.deleteSelected();
    }

    public void a_viewResults() {
        int n = this.experiments.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this.experiments.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            GUIExperiment gUIExperiment = this.experiments.getExperiment(nArray[i]);
            new GUIResultsTable(this.getGUI(), this, gUIExperiment).show();
        }
    }

    public void a_plotResults() {
        if (this.experiments.getSelectedRowCount() != 1) {
            return;
        }
        GUIExperiment gUIExperiment = this.experiments.getExperiment(this.experiments.getSelectedRow());
        Type type = gUIExperiment.getPropertyType();
        if (!(type instanceof TypeInt || type instanceof TypeDouble || type instanceof TypeInterval)) {
            this.message("Can only plot results if the property is of type int or double");
            return;
        }
        if (gUIExperiment.getRangingConstants().size() == 0) {
            this.message("Cannot create a graph since there is only a single result.");
            return;
        }
        new GUIGraphPicker(this.getGUI(), this, gUIExperiment, this.graphHandler, true);
    }

    public void a_exportResults(boolean bl, String string) {
        int n = this.experiments.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        GUIExperiment[] gUIExperimentArray = new GUIExperiment[n];
        int[] nArray = this.experiments.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            gUIExperimentArray[i] = this.experiments.getExperiment(nArray[i]);
        }
        if (this.showSaveFileDialog(this.resultsFilter, string.equals(", ") ? this.resultsFilter[1] : this.resultsFilter[0]) == 0) {
            File file = this.getChooserFile();
            ExportResultsThread exportResultsThread = new ExportResultsThread(this, gUIExperimentArray, file, bl, string);
            exportResultsThread.setPriority(5);
            exportResultsThread.start();
        }
    }

    @Override
    public boolean displaysTab() {
        return true;
    }

    @Override
    public JMenu getMenu() {
        return this.propMenu;
    }

    @Override
    public OptionsPanel getOptions() {
        return null;
    }

    @Override
    public String getTabText() {
        return "Properties";
    }

    @Override
    public JToolBar getToolBar() {
        return null;
    }

    @Override
    public String getXMLIDTag() {
        return "";
    }

    @Override
    public Object getXMLSaveTree() {
        return null;
    }

    @Override
    public void loadXML(Object object) {
    }

    @Override
    public boolean processGUIEvent(GUIEvent gUIEvent) {
        if (gUIEvent instanceof GUIModelEvent) {
            GUIModelEvent gUIModelEvent = (GUIModelEvent)gUIEvent;
            if (gUIModelEvent.getID() == 0) {
                this.setParsedModel(null);
                this.doEnables();
            } else if (gUIModelEvent.getID() == 6) {
                if (gUIModelEvent.getBuildValues() != null) {
                    this.mfConstants = gUIModelEvent.getBuildValues();
                }
                this.doEnables();
            } else if (gUIModelEvent.getID() == 3) {
                this.setParsedModel(gUIModelEvent.getModulesFile());
                this.checkForPropertiesToLoad();
                if (this.verifyAfterReceiveParseNotification) {
                    this.verifyAfterParse();
                }
                if (this.experimentAfterReceiveParseNotification) {
                    this.experimentAfterParse();
                }
                if (this.simulateAfterReceiveParseNotification) {
                    this.simulateAfterParse();
                }
                if (this.exportLabelsAfterReceiveParseNotification) {
                    this.exportLabelsAfterParse();
                }
            } else if (gUIModelEvent.getID() == 7) {
                this.argsPropertiesFile = null;
                this.verifyAfterReceiveParseNotification = false;
                this.experimentAfterReceiveParseNotification = false;
                this.simulateAfterReceiveParseNotification = false;
                this.exportLabelsAfterReceiveParseNotification = false;
            } else if (gUIModelEvent.getID() == 9 && this.getPrism().getSettings().getBoolean("properties.clearListOnLoad")) {
                this.a_newList();
            }
        } else if (gUIEvent instanceof GUIComputationEvent) {
            if (gUIEvent.getID() == 0) {
                this.setComputing(true);
            } else if (gUIEvent.getID() == 1) {
                this.setComputing(false);
            } else if (gUIEvent.getID() == 2) {
                this.setComputing(false);
            }
        } else if (gUIEvent instanceof GUIClipboardEvent && super.getGUI().getFocussedPlugin() == this) {
            GUIClipboardEvent gUIClipboardEvent = (GUIClipboardEvent)gUIEvent;
            if (!(gUIClipboardEvent.getComponent() != this && gUIClipboardEvent.getComponent() != this.propList || this.computing)) {
                if (gUIClipboardEvent.getID() == 1) {
                    this.a_cut();
                } else if (gUIClipboardEvent.getID() == 0) {
                    this.a_copy();
                } else if (gUIClipboardEvent.getID() == 2) {
                    this.a_paste();
                } else if (gUIClipboardEvent.getID() == 3) {
                    this.a_delete();
                } else if (gUIClipboardEvent.getID() == 4) {
                    this.a_selectAll();
                }
            }
        } else if (gUIEvent instanceof GUIPropertiesEvent) {
            GUIPropertiesEvent gUIPropertiesEvent = (GUIPropertiesEvent)gUIEvent;
            if (gUIPropertiesEvent.getID() == 3) {
                this.stopExperiment.setEnabled(true);
            } else if (gUIPropertiesEvent.getID() == 4) {
                this.stopExperiment.setEnabled(false);
            } else if (gUIPropertiesEvent.getID() == 6) {
                this.a_verifyDone();
            }
        } else if (gUIEvent instanceof GUIExitEvent && gUIEvent.getID() == 0 && this.doModificationCheck() != 0) {
            this.notifyEventListeners(new GUIExitEvent(1));
            return true;
        }
        return false;
    }

    private void checkForPropertiesToLoad() {
        if (this.argsPropertiesFile != null) {
            LoadPropertiesThread loadPropertiesThread = new LoadPropertiesThread(this, this.parsedModel, new File(this.argsPropertiesFile));
            loadPropertiesThread.setPriority(5);
            loadPropertiesThread.start();
            this.argsPropertiesFile = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
        if (!this.computing && mouseEvent.getClickCount() >= 2 && mouseEvent.getSource() == this.propList) {
            int n = this.propList.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                this.propList.setSelectedIndex(n);
            }
            this.a_editProperty();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
        if (!this.computing) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == this.propList) {
                int n;
                boolean bl;
                int[] nArray;
                int n2 = this.propList.locationToIndex(mouseEvent.getPoint());
                if (this.propList.isSelectionEmpty()) {
                    if (n2 != -1) {
                        this.propList.setSelectedIndex(n2);
                    }
                } else {
                    nArray = this.propList.getSelectedIndices();
                    bl = false;
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] != n2) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.propList.setSelectedIndex(n2);
                    }
                }
                nArray = this.propList.getSelectedIndices();
                bl = true;
                for (n = 0; n < nArray.length; ++n) {
                    if (!this.propList.getProperty(nArray[n]).isBeingEdited()) continue;
                    bl = false;
                    break;
                }
                this.verifySelected.setEnabled(this.propList.existsValidSelectedProperties());
                this.simulate.setEnabled(this.propList.existsValidSimulatableSelectedProperties());
                this.details.setEnabled(this.propList.existsValidSelectedProperties());
                this.editProperty.setEnabled(this.propList.getSelectedProperties().size() > 0);
                this.newExperiment.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
                this.parametric.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
                if (!bl) {
                    this.simulate.setEnabled(false);
                    this.verifySelected.setEnabled(false);
                    this.details.setEnabled(false);
                    this.editProperty.setEnabled(false);
                    this.newExperiment.setEnabled(false);
                    this.parametric.setEnabled(false);
                }
                this.propertiesPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.consTable || mouseEvent.getSource() == this.constantsScroll)) {
                this.constantsPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.labTable || mouseEvent.getSource() == this.labelsScroll)) {
                this.labelsPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.experiments || mouseEvent.getSource() == this.expScroller)) {
                this.doEnables();
                this.experimentPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public boolean canDoClipBoardAction(Action action) {
        if (this.computing) {
            return false;
        }
        int[] nArray = this.propList.getSelectedIndices();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.propList.getProperty(nArray[i]).isBeingEdited()) continue;
            bl = false;
            break;
        }
        if (action == GUIPrism.getClipboardPlugin().getPasteAction()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.getContents(null) != null;
        }
        if (action == GUIPrism.getClipboardPlugin().getCutAction() || action == GUIPrism.getClipboardPlugin().getDeleteAction()) {
            if (!bl) {
                return false;
            }
            return this.propList.getSelectedProperties().size() > 0;
        }
        if (action == GUIPrism.getClipboardPlugin().getCopyAction()) {
            return this.propList.getSelectedProperties().size() > 0;
        }
        return action == GUIPrism.getClipboardPlugin().getSelectAllAction();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
        if (!this.computing) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == this.propList) {
                int n;
                boolean bl;
                int[] nArray;
                int n2 = this.propList.locationToIndex(mouseEvent.getPoint());
                if (this.propList.isSelectionEmpty()) {
                    if (n2 != -1) {
                        this.propList.setSelectedIndex(n2);
                    }
                } else {
                    nArray = this.propList.getSelectedIndices();
                    bl = false;
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] != n2) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.propList.setSelectedIndex(n2);
                    }
                }
                nArray = this.propList.getSelectedIndices();
                bl = true;
                for (n = 0; n < nArray.length; ++n) {
                    if (!this.propList.getProperty(nArray[n]).isBeingEdited()) continue;
                    bl = false;
                    break;
                }
                this.verifySelected.setEnabled(this.propList.existsValidSelectedProperties());
                this.simulate.setEnabled(this.propList.existsValidSimulatableSelectedProperties());
                this.details.setEnabled(this.propList.existsValidSelectedProperties());
                this.editProperty.setEnabled(this.propList.getSelectedProperties().size() > 0);
                this.newExperiment.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
                this.parametric.setEnabled(this.propList.getNumSelectedProperties() == 1 && this.propList.getValidSelectedProperties().size() == 1);
                if (!bl) {
                    this.simulate.setEnabled(false);
                    this.verifySelected.setEnabled(false);
                    this.details.setEnabled(false);
                    this.editProperty.setEnabled(false);
                    this.newExperiment.setEnabled(false);
                    this.parametric.setEnabled(false);
                }
                this.propertiesPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.consTable || mouseEvent.getSource() == this.constantsScroll)) {
                this.constantsPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.labTable || mouseEvent.getSource() == this.labelsScroll)) {
                this.labelsPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == this.experiments || mouseEvent.getSource() == this.expScroller)) {
                this.doEnables();
                this.experimentPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ArrayList<GUIProperty> arrayList = this.propList.getSelectedProperties();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isBeingEdited()) continue;
            bl = false;
            break;
        }
        this.verifySelected.setEnabled(this.propList.existsValidSelectedProperties());
        this.simulate.setEnabled(this.propList.existsValidSimulatableSelectedProperties());
        this.details.setEnabled(this.propList.existsValidSelectedProperties());
        this.editProperty.setEnabled(this.propList.getSelectedProperties().size() > 0);
        if (!bl) {
            this.simulate.setEnabled(false);
            this.verifySelected.setEnabled(false);
            this.details.setEnabled(false);
            this.editProperty.setEnabled(false);
        }
        this.updateCommentLabel();
        this.removeConstant.setEnabled(this.consTable.getSelectedRowCount() > 0);
        this.removeLabel.setEnabled(this.labTable.getSelectedRowCount() > 0);
        this.selectionChangeHandler.notifyListeners(new GUIEvent(1));
    }

    private void initComponents() {
        this.setupActions();
        JSplitPane jSplitPane = new JSplitPane();
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(10, 10));
        JComponent jComponent = new JSplitPane();
        JComponent jComponent2 = new JPanel();
        JComponent jComponent3 = new JScrollPane();
        this.propList = new GUIPropertiesList(this.getPrism(), this);
        this.propList.addListSelectionListener(this);
        this.propList.addContainerListener(this);
        ((JScrollPane)jComponent3).setViewportView(this.propList);
        JComponent jComponent4 = new JScrollPane();
        this.comLabel = new JTextArea();
        this.comLabel.setRows(2);
        this.comLabel.setEditable(false);
        ((JScrollPane)jComponent4).setViewportView(this.comLabel);
        jComponent2.setLayout(new BorderLayout());
        jComponent2.add((Component)jComponent3, "Center");
        jComponent2.add((Component)jComponent4, "South");
        jComponent2.setBorder(new TitledBorder("Properties"));
        jComponent3 = new JSplitPane();
        this.constantsScroll = new JScrollPane();
        this.consTable = new GUIPropConstantList(this);
        this.consTable.setBackground(Color.white);
        this.consTable.addMouseListener(this);
        this.constantsScroll.setViewportView(this.consTable);
        this.constantsScroll.addMouseListener(this);
        this.constantsScroll.setBorder(new TitledBorder("Constants"));
        this.labelsScroll = new JScrollPane();
        this.labTable = new GUIPropLabelList(this);
        this.labTable.setBackground(Color.white);
        this.labTable.addMouseListener(this);
        this.labelsScroll.setViewportView(this.labTable);
        this.labelsScroll.addMouseListener(this);
        this.labelsScroll.setBorder(new TitledBorder("Labels"));
        ((JSplitPane)jComponent3).setOrientation(0);
        ((JSplitPane)jComponent3).setTopComponent(this.constantsScroll);
        ((JSplitPane)jComponent3).setBottomComponent(this.labelsScroll);
        ((JSplitPane)jComponent3).setDividerLocation(0.5);
        ((JSplitPane)jComponent3).setDividerSize(5);
        ((JSplitPane)jComponent3).setResizeWeight(0.5);
        ((JSplitPane)jComponent).setOrientation(0);
        ((JSplitPane)jComponent).setTopComponent(jComponent2);
        ((JSplitPane)jComponent).setBottomComponent(jComponent3);
        ((JSplitPane)jComponent).setDividerLocation(0.5);
        ((JSplitPane)jComponent).setDividerSize(5);
        ((JSplitPane)jComponent).setResizeWeight(0.5);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        jComponent = new JPanel();
        jComponent2 = new JSplitPane();
        jComponent3 = new JPanel();
        jComponent4 = new JToolBar();
        JButton jButton = new JButton(this.stopExperiment);
        jButton.setToolTipText("Stop Current Experiment");
        jComponent4.add(jButton);
        ((JToolBar)jComponent4).setFloatable(false);
        this.expScroller = new JScrollPane();
        this.experiments = new GUIExperimentTable(this);
        this.experiments.addMouseListener(this);
        this.expScroller.addMouseListener(this);
        this.expScroller.setViewportView(this.experiments);
        jComponent3.setLayout(new BorderLayout());
        jComponent3.add((Component)jComponent4, "North");
        jComponent3.add((Component)this.expScroller, "Center");
        jComponent4 = new JPanel(new GridLayout(1, 1));
        this.graphHandler = new GUIGraphHandler(this.getGUI(), this, true);
        jComponent4.add(this.graphHandler);
        jComponent4.setPreferredSize(new Dimension(300, 300));
        ((JSplitPane)jComponent2).setOrientation(0);
        ((JSplitPane)jComponent2).setTopComponent(jComponent3);
        ((JSplitPane)jComponent2).setBottomComponent(jComponent4);
        ((JSplitPane)jComponent2).setDividerLocation(0.5);
        ((JSplitPane)jComponent2).setDividerSize(5);
        ((JSplitPane)jComponent2).setResizeWeight(0.5);
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(new TitledBorder("Experiments"));
        jComponent.add((Component)jComponent2, "Center");
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jComponent);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jPanel = new JPanel();
        this.fileTextField = new JTextField();
        this.fileTextField.setHorizontalAlignment(2);
        this.fileTextField.setBorder(new EtchedBorder());
        this.fileTextField.setMinimumSize(new Dimension(40, 25));
        this.fileTextField.setEditable(false);
        this.fileTextField.setBackground(null);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fileTextField, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel, "North");
        this.propMenu = new JMenu("Properties");
        this.propMenu.add(this.newProps);
        this.propMenu.add(new JSeparator());
        this.propMenu.add(this.openProps);
        this.propMenu.add(this.insertProps);
        this.propMenu.add(new JSeparator());
        this.propMenu.add(this.saveProps);
        this.propMenu.add(this.savePropsAs);
        this.propMenu.add(new JSeparator());
        this.propMenu.add(this.verifySelected);
        this.propMenu.add(this.simulate);
        this.propMenu.add(this.newExperiment);
        jComponent = new JMenu("Export labels");
        ((AbstractButton)jComponent).setMnemonic('E');
        ((AbstractButton)jComponent).setIcon(GUIPrism.getIconFromImage("smallExport.png"));
        ((JMenu)jComponent).add(this.exportLabelsPlain);
        ((JMenu)jComponent).add(this.exportLabelsMatlab);
        this.propMenu.add((JMenuItem)jComponent);
        this.propMenu.setMnemonic('P');
        this.createPopups();
        this.propsFilter = new GUIPrismFileFilter[1];
        this.propsFilter[0] = new GUIPrismFileFilter("PRISM properties (*.props, *.pctl, *.csl)");
        this.propsFilter[0].addExtension("props");
        this.propsFilter[0].addExtension("pctl");
        this.propsFilter[0].addExtension("csl");
        this.resultsFilter = new GUIPrismFileFilter[2];
        this.resultsFilter[0] = new GUIPrismFileFilter("Plain text files (*.txt)");
        this.resultsFilter[0].addExtension("txt");
        this.resultsFilter[1] = new GUIPrismFileFilter("Comma-separated values (*.csv)");
        this.resultsFilter[1].addExtension("csv");
        this.textFilter = new GUIPrismFileFilter[2];
        this.textFilter[0] = new GUIPrismFileFilter("Plain text files (*.txt)");
        this.textFilter[0].addExtension("txt");
        this.textFilter[1] = new GUIPrismFileFilter("Label files (*.lab)");
        this.textFilter[1].addExtension("lab");
        this.matlabFilter = new GUIPrismFileFilter[1];
        this.matlabFilter[0] = new GUIPrismFileFilter("Matlab files (*.m)");
        this.matlabFilter[0].addExtension("m");
    }

    private void createPopups() {
        this.propertiesPopup = new JPopupMenu();
        this.propertiesPopup.add(this.editProperty);
        this.propertiesPopup.add(this.newProperty);
        this.propertiesPopup.add(new JSeparator());
        this.propertiesPopup.add(this.verifySelected);
        this.propertiesPopup.add(this.simulate);
        this.propertiesPopup.add(this.newExperiment);
        this.propertiesPopup.add(this.details);
        this.propertiesPopup.add(new JSeparator());
        this.propertiesPopup.add(GUIPrism.getClipboardPlugin().getCutAction());
        this.propertiesPopup.add(GUIPrism.getClipboardPlugin().getCopyAction());
        this.propertiesPopup.add(GUIPrism.getClipboardPlugin().getPasteAction());
        this.propertiesPopup.add(GUIPrism.getClipboardPlugin().getDeleteAction());
        this.propertiesPopup.add(new JSeparator());
        this.propertiesPopup.add(GUIPrism.getClipboardPlugin().getSelectAllAction());
        this.constantsPopup = new JPopupMenu();
        this.constantsPopup.add(this.newConstant);
        this.constantsPopup.add(this.removeConstant);
        this.labelsPopup = new JPopupMenu();
        this.labelsPopup.add(this.newLabel);
        this.labelsPopup.add(this.removeLabel);
        this.consTable.addMouseListener(this);
        this.propList.addMouseListener(this);
        this.experimentPopup = new JPopupMenu();
        this.experimentPopup.add(this.newExperiment);
        this.experimentPopup.add(this.deleteExperiment);
        this.experimentPopup.add(new JSeparator());
        this.experimentPopup.add(this.viewResults);
        this.experimentPopup.add(this.plotResults);
        JMenu jMenu = new JMenu("Export results");
        jMenu.setMnemonic('E');
        jMenu.setIcon(GUIPrism.getIconFromImage("smallExport.png"));
        jMenu.add(this.exportResultsListText);
        jMenu.add(this.exportResultsListCSV);
        jMenu.add(this.exportResultsMatrixText);
        jMenu.add(this.exportResultsMatrixCSV);
        this.experimentPopup.add(jMenu);
    }

    private void setupActions() {
        this.newProps = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_newList();
            }
        };
        this.newProps.putValue("LongDescription", "Clears the current properties list, and the current active properties list.");
        this.newProps.putValue("MnemonicKey", new Integer(78));
        this.newProps.putValue("Name", "New properties list");
        this.newProps.putValue("SmallIcon", GUIPrism.getIconFromImage("smallNew.png"));
        this.newProps.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.openProps = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_open();
            }
        };
        this.openProps.putValue("LongDescription", "Opens a properties list, checking that it is valid according to the current parsed model");
        this.openProps.putValue("MnemonicKey", new Integer(79));
        this.openProps.putValue("Name", "Open properties list...");
        this.openProps.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOpen.png"));
        this.openProps.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.saveProps = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_save();
            }
        };
        this.saveProps.putValue("LongDescription", "Saves all properties to the current active properties list, if non exists the user is prompted with a dialog.");
        this.saveProps.putValue("MnemonicKey", new Integer(83));
        this.saveProps.putValue("Name", "Save properties list");
        this.saveProps.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSave.png"));
        this.saveProps.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.savePropsAs = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_saveAs();
            }
        };
        this.savePropsAs.putValue("LongDescription", "Saves all properties to a new file selected by the user from a dialog.");
        this.savePropsAs.putValue("MnemonicKey", new Integer(65));
        this.savePropsAs.putValue("Name", "Save properties list as...");
        this.savePropsAs.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSaveAs.png"));
        this.insertProps = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_insert();
            }
        };
        this.insertProps.putValue("LongDescription", "Inserts properties from user selected file into the properties list.  The active property file remains the same however.");
        this.insertProps.putValue("MnemonicKey", new Integer(73));
        this.insertProps.putValue("Name", "Insert properties list...");
        this.insertProps.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.simulate = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_simulateSelected();
            }
        };
        this.simulate.putValue("LongDescription", "Calls the PRISM simulator to approximately model check the selected properties against the parsed model.");
        this.simulate.putValue("MnemonicKey", new Integer(83));
        this.simulate.putValue("Name", "Simulate");
        this.simulate.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSimulate.png"));
        this.simulate.putValue("AcceleratorKey", KeyStroke.getKeyStroke(117, 0));
        this.details = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_detailSelected();
            }
        };
        this.details.putValue("LongDescription", "Shows the details for the currently selected properties in a dialog box.");
        this.details.putValue("MnemonicKey", new Integer(68));
        this.details.putValue("Name", "Show details");
        this.details.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDetails.png"));
        this.verifySelected = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_verifySelected();
            }
        };
        this.verifySelected.putValue("LongDescription", "Model checks the selected properties against the model that is built.  If there is no built model, the parsed model is automatically built.  If the parsed model has changed since the last build, the user is prompted as to whether they wish to re-build the model.  If the model text has been modified since the last build, the user is asked whether they want to re-parse and re-build.");
        this.verifySelected.putValue("MnemonicKey", new Integer(86));
        this.verifySelected.putValue("Name", "Verify");
        this.verifySelected.putValue("SmallIcon", GUIPrism.getIconFromImage("smallTick.png"));
        this.verifySelected.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        this.newProperty = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_newProperty();
            }
        };
        this.newProperty.putValue("LongDescription", "Brings up a dialog to add a new property to the list.");
        this.newProperty.putValue("MnemonicKey", new Integer(68));
        this.newProperty.putValue("Name", "Add");
        this.newProperty.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.editProperty = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_editProperty();
            }
        };
        this.editProperty.putValue("LongDescription", "Brings up a dialog to edit a selected property.");
        this.editProperty.putValue("MnemonicKey", new Integer(69));
        this.editProperty.putValue("Name", "Edit");
        this.editProperty.putValue("SmallIcon", GUIPrism.getIconFromImage("smallEdit.png"));
        this.newConstant = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_addConstant();
            }
        };
        this.newConstant.putValue("LongDescription", "Adds a new constant to the constants list");
        this.newConstant.putValue("MnemonicKey", new Integer(68));
        this.newConstant.putValue("Name", "Add constant");
        this.newConstant.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.removeConstant = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_removeSelectedConstants();
            }
        };
        this.removeConstant.putValue("LongDescription", "Deletes selected constants");
        this.removeConstant.putValue("MnemonicKey", new Integer(68));
        this.removeConstant.putValue("Name", "Delete constant");
        this.removeConstant.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.newLabel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_addLabel();
            }
        };
        this.newLabel.putValue("LongDescription", "Adds a new Label to the Labels list");
        this.newLabel.putValue("MnemonicKey", new Integer(68));
        this.newLabel.putValue("Name", "Add label");
        this.newLabel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.removeLabel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_removeSelectedLabels();
            }
        };
        this.removeLabel.putValue("LongDescription", "Deletes selected Labels");
        this.removeLabel.putValue("MnemonicKey", new Integer(68));
        this.removeLabel.putValue("Name", "Delete label");
        this.removeLabel.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.newExperiment = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_newExperiment();
            }
        };
        this.newExperiment.putValue("LongDescription", "Creates a new experiment");
        this.newExperiment.putValue("MnemonicKey", new Integer(78));
        this.newExperiment.putValue("Name", "New experiment");
        this.newExperiment.putValue("SmallIcon", GUIPrism.getIconFromImage("smallExperiment.png"));
        this.newExperiment.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
        this.deleteExperiment = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_deleteExperiment();
            }
        };
        this.deleteExperiment.putValue("LongDescription", "Deletes the selected experiment");
        this.deleteExperiment.putValue("MnemonicKey", new Integer(68));
        this.deleteExperiment.putValue("Name", "Delete experiment");
        this.deleteExperiment.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.viewResults = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_viewResults();
            }
        };
        this.viewResults.putValue("LongDescription", "View the results of this experiment");
        this.viewResults.putValue("MnemonicKey", new Integer(86));
        this.viewResults.putValue("Name", "View results");
        this.viewResults.putValue("SmallIcon", GUIPrism.getIconFromImage("smallView.png"));
        this.plotResults = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_plotResults();
            }
        };
        this.plotResults.putValue("LongDescription", "Plot the results of this experiment in a graph series");
        this.plotResults.putValue("MnemonicKey", new Integer(80));
        this.plotResults.putValue("Name", "Plot results");
        this.plotResults.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.parametric = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_newExperiment();
            }
        };
        this.parametric.putValue("LongDescription", "Perform parametric model checking");
        this.parametric.putValue("MnemonicKey", new Integer(80));
        this.parametric.putValue("Name", "Parametric");
        this.parametric.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.exportResultsListText = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportResults(false, "\t");
            }
        };
        this.exportResultsListText.putValue("LongDescription", "Export the results of this experiment to a text file");
        this.exportResultsListText.putValue("MnemonicKey", new Integer(76));
        this.exportResultsListText.putValue("Name", "List (text)");
        this.exportResultsListText.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileText.png"));
        this.exportResultsListCSV = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportResults(false, ", ");
            }
        };
        this.exportResultsListCSV.putValue("LongDescription", "Export the results of this experiment to a CSV file");
        this.exportResultsListCSV.putValue("MnemonicKey", new Integer(76));
        this.exportResultsListCSV.putValue("Name", "List (CSV)");
        this.exportResultsListCSV.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportResultsMatrixText = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportResults(true, "\t");
            }
        };
        this.exportResultsMatrixText.putValue("LongDescription", "Export the results of this experiment to a file in matrix form");
        this.exportResultsMatrixText.putValue("MnemonicKey", new Integer(77));
        this.exportResultsMatrixText.putValue("Name", "Matrix (text)");
        this.exportResultsMatrixText.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileText.png"));
        this.exportResultsMatrixCSV = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportResults(true, ", ");
            }
        };
        this.exportResultsMatrixCSV.putValue("LongDescription", "Export the results of this experiment to a file in matrix form");
        this.exportResultsMatrixCSV.putValue("MnemonicKey", new Integer(77));
        this.exportResultsMatrixCSV.putValue("Name", "Matrix (CSV)");
        this.exportResultsMatrixCSV.putValue("SmallIcon", GUIPrism.getIconFromImage("smallMatrix.png"));
        this.exportLabelsPlain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportLabels(1);
            }
        };
        this.exportLabelsPlain.putValue("LongDescription", "Exports the model and property file's labels and their satisfying states to a plain text file");
        this.exportLabelsPlain.putValue("MnemonicKey", new Integer(80));
        this.exportLabelsPlain.putValue("Name", "Plain text file");
        this.exportLabelsPlain.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileText.png"));
        this.exportLabelsMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_exportLabels(2);
            }
        };
        this.exportLabelsMatlab.putValue("LongDescription", "Exports the model and property file's labels and their satisfying states to a Matlab file");
        this.exportLabelsMatlab.putValue("MnemonicKey", new Integer(77));
        this.exportLabelsMatlab.putValue("Name", "Matlab file");
        this.exportLabelsMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileMatlab.png"));
        this.stopExperiment = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiProperties.this.a_stopExperiment();
            }
        };
        this.stopExperiment.putValue("LongDescription", "Stops the Experiment that is currently running");
        this.stopExperiment.putValue("SmallIcon", GUIPrism.getIconFromImage("smallStop.png"));
        this.stopExperiment.setEnabled(false);
    }

    public GUIPropertiesList getPropList() {
        return this.propList;
    }

    public GUIPropConstantList getConsTable() {
        return this.consTable;
    }

    public GUIPropLabelList getLabTable() {
        return this.labTable;
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        this.displayFontFast = prismSettings.getFontColorPair((String)"properties.font").f;
        this.setFont(this.displayFontFast);
        this.backgroundFast = new Color(202, 225, 255);
        this.warningFast = prismSettings.getColor("properties.warningColour");
        this.repaint();
    }

    public static DataFlavor getGUIClipboardPropertiesDataFlavor() {
        return new DataFlavor(GUIClipboardProperties.class, "PRISM Property List");
    }

    public class GUIClipboardProperties
    implements Transferable {
        private ArrayList<GUIProperty> listOfProperties;
        private StringSelection stringRepresentation;

        public GUIClipboardProperties(ArrayList<GUIProperty> arrayList) {
            this.listOfProperties = arrayList;
            String string = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                GUIProperty gUIProperty = arrayList.get(i);
                if (gUIProperty.getComment().trim().length() > 0) {
                    string = string + "//" + gUIProperty.getComment() + "\n";
                }
                string = string + gUIProperty.getPropString();
                if (i == arrayList.size() - 1) continue;
                string = string + "\n";
            }
            this.stringRepresentation = new StringSelection(string);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.getRepresentationClass() == this.getClass()) {
                return this;
            }
            return this.stringRepresentation.getTransferData(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.stringRepresentation.getTransferDataFlavors();
            DataFlavor[] dataFlavorArray2 = new DataFlavor[dataFlavorArray.length + 1];
            dataFlavorArray2[0] = GUIMultiProperties.getGUIClipboardPropertiesDataFlavor();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                dataFlavorArray2[i + 1] = dataFlavorArray[i];
            }
            return dataFlavorArray2;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.stringRepresentation.isDataFlavorSupported(dataFlavor) || dataFlavor.equals(GUIMultiProperties.getGUIClipboardPropertiesDataFlavor());
        }

        public ArrayList<GUIProperty> getProperties() {
            return this.listOfProperties;
        }
    }
}

