/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import parser.State;
import parser.Values;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.Type;
import prism.DefinedConstant;
import prism.PrismException;
import prism.Result;
import prism.ResultsCollection;
import prism.UndefinedConstants;
import userinterface.GUIComputationThread;
import userinterface.GUISimulationPicker;
import userinterface.SimulationInformation;
import userinterface.properties.GUIExperimentTable;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.util.GUIComputationEvent;

public class GUIExperiment {
    private GUIMultiProperties guiProp;
    private GUIExperimentTable table;
    private ResultsCollection results;
    private boolean finished = false;
    private UndefinedConstants cons;
    private PropertiesFile prop;
    private boolean running = false;
    private Thread theThread;
    private boolean useSimulation;
    private Values definedMFConstants;
    private Values definedPFConstants;
    private Result res;

    public GUIExperiment(GUIExperimentTable gUIExperimentTable, GUIMultiProperties gUIMultiProperties, PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, boolean bl) {
        this.table = gUIExperimentTable;
        this.guiProp = gUIMultiProperties;
        this.prop = propertiesFile;
        this.cons = undefinedConstants;
        this.useSimulation = bl;
        this.results = new ResultsCollection(undefinedConstants, propertiesFile.getProperty(0).getResultName());
    }

    public int getTotalIterations() {
        return this.cons.getNumIterations();
    }

    public int getCurrentIterations() {
        return this.results.getCurrentIteration();
    }

    public Vector<DefinedConstant> getRangingConstants() {
        return this.cons.getRangingConstants();
    }

    public String getDefinedConstantsString() {
        return this.cons.getDefinedConstantsString();
    }

    public String getPFDefinedConstantsString() {
        return this.cons.getPFDefinedConstantsString();
    }

    public String getPropertyString() {
        int n = this.prop.getNumProperties() - 1;
        return this.prop.getProperty(n).toString();
    }

    public Type getPropertyType() {
        int n = this.prop.getNumProperties() - 1;
        return this.prop.getProperty(n).getType();
    }

    public ResultsCollection getResults() {
        return this.results;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUseSimulation() {
        return this.useSimulation;
    }

    public GUIExperimentTable getTable() {
        return this.table;
    }

    public void startExperiment() {
        this.theThread = new ExperimentThread(this.guiProp, this.cons, this.prop);
        this.running = true;
        this.theThread.start();
    }

    public synchronized void experimentDone() {
        this.running = false;
        this.theThread = null;
        this.finished = true;
        this.table.repaint();
    }

    public synchronized void experimentFailed() {
        this.running = false;
        this.theThread = null;
        this.finished = true;
        this.table.repaint();
    }

    public synchronized void experimentInterrupted() {
        this.running = false;
        this.theThread = null;
        this.finished = true;
        this.table.repaint();
    }

    public synchronized void setResult(Values values, Values values2, Result result) {
        this.results.setResult(values, values2, result.getResult());
    }

    public synchronized void setMultipleErrors(Values values, Values values2, Exception exception) {
        this.results.setMultipleErrors(values, values2, exception);
    }

    public void stop() {
        if (this.running && this.theThread != null) {
            if (this.useSimulation) {
                this.guiProp.getPrism().getSimulator().stopSampling();
            }
            this.theThread.interrupt();
        }
    }

    public void clear() {
    }

    class ExperimentThread
    extends GUIComputationThread {
        private UndefinedConstants undefinedConstants;
        private PropertiesFile propertiesFile;

        public ExperimentThread(GUIMultiProperties gUIMultiProperties, UndefinedConstants undefinedConstants, PropertiesFile propertiesFile) {
            super(gUIMultiProperties);
            this.undefinedConstants = undefinedConstants;
            this.propertiesFile = propertiesFile;
        }

        @Override
        public void run() {
            int n = this.propertiesFile.getNumProperties() - 1;
            Property property = this.propertiesFile.getPropertyObject(n);
            SimulationInformation simulationInformation = null;
            boolean bl = false;
            boolean bl2 = false;
            GUIExperiment.this.definedMFConstants = null;
            GUIExperiment.this.definedPFConstants = null;
            GUIExperiment.this.res = null;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIExperiment.this.guiProp.startProgress();
                        GUIExperiment.this.guiProp.setTaskBarText("Running experiment...");
                        GUIExperiment.this.guiProp.notifyEventListeners(new GUIComputationEvent(0, GUIExperiment.this.guiProp));
                        GUIExperiment.this.guiProp.notifyEventListeners(new GUIPropertiesEvent(3));
                    }
                });
                for (int i = 0; i < this.undefinedConstants.getNumModelIterations(); ++i) {
                    block25: {
                        try {
                            GUIExperiment.this.definedMFConstants = this.undefinedConstants.getMFConstantValues();
                            this.prism.setPRISMModelConstants(GUIExperiment.this.definedMFConstants);
                        }
                        catch (PrismException prismException) {
                            this.errorLog(prismException.getMessage());
                            GUIExperiment.this.setMultipleErrors(GUIExperiment.this.definedMFConstants, null, prismException);
                            this.undefinedConstants.iterateModel();
                            continue;
                        }
                        if (GUIExperiment.this.useSimulation && !bl) {
                            try {
                                simulationInformation = null;
                                simulationInformation = GUISimulationPicker.defineSimulationWithDialog(GUIExperiment.this.guiProp.getGUI(), property.getExpression(), this.prism.getPRISMModel(), "(" + GUIExperiment.this.definedMFConstants + ")");
                            }
                            catch (PrismException prismException) {
                                this.errorLog(prismException.getMessage());
                                GUIExperiment.this.setMultipleErrors(GUIExperiment.this.definedMFConstants, null, prismException);
                                this.undefinedConstants.iterateModel();
                                continue;
                            }
                            if (simulationInformation == null) break;
                            if (this.undefinedConstants.getNumModelIterations() > 1 && !bl2) {
                                bl2 = true;
                                int n2 = GUIExperiment.this.guiProp.questionYesNo("Do you want to reuse the same simulation\nparameters for the remaining models in this experiment?\nIf not you will be prompted for new values for each one.");
                                if (n2 == 0) {
                                    bl = true;
                                }
                            }
                        }
                        if (GUIExperiment.this.useSimulation && this.prism.getSettings().getBoolean("simulator.simultaneous") && this.undefinedConstants.getNumPropertyIterations() > 1) {
                            try {
                                State state = simulationInformation.getInitialState() == null ? null : new State(simulationInformation.getInitialState(), this.prism.getPRISMModel());
                                this.prism.modelCheckSimulatorExperiment(this.propertiesFile, this.undefinedConstants, GUIExperiment.this.results, property.getExpression(), state, simulationInformation.getMaxPathLength(), simulationInformation.createSimulationMethod());
                                GUIExperiment.this.table.progressChanged();
                                break block25;
                            }
                            catch (PrismException prismException) {
                                this.errorLog(prismException.getMessage());
                                GUIExperiment.this.setMultipleErrors(GUIExperiment.this.definedMFConstants, null, prismException);
                                this.undefinedConstants.iterateModel();
                                continue;
                            }
                        }
                        for (int j = 0; j < this.undefinedConstants.getNumPropertyIterations(); ++j) {
                            if (ExperimentThread.interrupted()) {
                                throw new InterruptedException();
                            }
                            try {
                                if (this.propertiesFile != null) {
                                    GUIExperiment.this.definedPFConstants = this.undefinedConstants.getPFConstantValues();
                                    this.propertiesFile.setSomeUndefinedConstants(GUIExperiment.this.definedPFConstants);
                                }
                                if (!GUIExperiment.this.useSimulation) {
                                    GUIExperiment.this.res = this.prism.modelCheck(this.propertiesFile, property);
                                } else {
                                    State state = simulationInformation.getInitialState() == null ? null : new State(simulationInformation.getInitialState(), this.prism.getPRISMModel());
                                    GUIExperiment.this.res = this.prism.modelCheckSimulator(this.propertiesFile, property.getExpression(), GUIExperiment.this.definedPFConstants, state, simulationInformation.getMaxPathLength(), simulationInformation.createSimulationMethod());
                                }
                            }
                            catch (PrismException prismException) {
                                this.errorLog(prismException.getMessage());
                                GUIExperiment.this.res = new Result(prismException);
                            }
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    GUIExperiment.this.setResult(GUIExperiment.this.definedMFConstants, GUIExperiment.this.definedPFConstants, GUIExperiment.this.res);
                                }
                            });
                            GUIExperiment.this.table.progressChanged();
                            this.undefinedConstants.iterateProperty();
                            ExperimentThread.yield();
                        }
                    }
                    this.undefinedConstants.iterateModel();
                    ExperimentThread.yield();
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIExperiment.this.guiProp.stopProgress();
                        GUIExperiment.this.guiProp.setTaskBarText("Running experiment... done.");
                        GUIExperiment.this.guiProp.notifyEventListeners(new GUIComputationEvent(1, GUIExperiment.this.guiProp));
                        GUIExperiment.this.guiProp.notifyEventListeners(new GUIPropertiesEvent(4));
                    }
                });
                GUIExperiment.this.experimentDone();
                if (GUIExperiment.this.results.containsErrors()) {
                    this.errorDialog("One or more errors occured during this experiment.\nSelect \"View results\" or check the log for more information");
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            GUIExperiment.this.guiProp.stopProgress();
                            GUIExperiment.this.guiProp.setTaskBarText("Running experiment... interrupted.");
                            GUIExperiment.this.guiProp.notifyEventListeners(new GUIComputationEvent(1, GUIExperiment.this.guiProp));
                            GUIExperiment.this.guiProp.notifyEventListeners(new GUIPropertiesEvent(4));
                        }
                    });
                }
                catch (InterruptedException interruptedException2) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                GUIExperiment.this.experimentInterrupted();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

